/*
 * Decompiled with CFR 0.152.
 */
package view;

import comm.msg.MFld;
import doc.AppxToolkit;
import doc.Globals;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;
import view.AppxAntiAliasControl;
import view.AppxAntiAliasHelper;
import view.AppxAquaTextFieldBorder;
import view.AppxButton;
import view.AppxControl;
import view.AppxControlCache;
import view.AppxControlItem;
import view.AppxControlItemObj;
import view.AppxControlUtils;
import view.AppxField;
import view.CharView;
import view.Display;
import view.FixedLengthPlainDocument;

public class AppxFormattedTextField
extends JFormattedTextField
implements ComboBoxEditor,
AppxControl,
AppxControlItem,
AppxControlCache,
FocusListener,
KeyListener,
DocumentListener,
AppxAntiAliasControl {
    private boolean touched = false;
    private boolean resizable = true;
    private boolean firstGotFocus = true;
    private boolean contentAreaFilled = true;
    private boolean upperCase = false;
    private String jmask = null;
    private AppxButton scanButton;
    private byte[] rawDate;
    private int maxLen;
    private Color disabledFg;
    private Color disabledBg;
    private Color enabledFg;
    private Color enabledBg;
    private Rectangle bounds;
    private Rectangle offset = new Rectangle(0, 0, 0, 0);
    private String dialogTitle = null;
    private MFld dataModel = null;
    private Display parent;
    private AppxControlItemObj appxControlItemObj = new AppxControlItemObj();
    private AppxAntiAliasHelper antiAlias = new AppxAntiAliasHelper();
    private boolean movable = false;
    private int focusOffset;
    private Color pushedBg;

    public boolean isUpperCase() {
        return this.upperCase;
    }

    public void setUpperCase(boolean upperCase) {
        this.upperCase = upperCase;
    }

    public AppxFormattedTextField(Display disp, int x, int y, int width, int height, boolean ucs) {
        this(disp, width, ucs);
        this.setCellBounds(x, y, width, height);
    }

    public AppxFormattedTextField(Display disp, int len, boolean ucs) {
        this.setDocument(new FixedLengthPlainDocument(len, ucs, this, this.parent));
        this.getDocument().addDocumentListener(this);
        this.upperCase = ucs;
        this.maxLen = len;
        this.parent = disp;
        this.setTouched(false);
        this.offset = AppxControlUtils.nullOffset;
        this.dataModel = null;
        this.setOpaque(true);
        this.setFont(this.parent.getStdFont());
        this.addFocusListener(this);
        this.addKeyListener(this);
        if (AppxToolkit.isWebLook()) {
            this.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        }
        if (UIManager.getBorder("InsetBorder.aquaVariant") != null) {
            this.setBorder(new AppxAquaTextFieldBorder());
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CharView.view.mousePressed(e);
            }
        });
        this.addMouseMotionListener(CharView.view);
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        if (AppxControlUtils.keyPressed(evt, this.parent)) {
            if (evt.getKeyCode() == 39 && this.getCaretPosition() == this.maxLen) {
                this.setSelectionStart(this.maxLen);
                this.setSelectionEnd(this.maxLen);
                evt.consume();
            } else if (evt.getKeyCode() == 10) {
                JButton jb = this.parent.getView().getDefaultButton();
                if (jb != null) {
                    jb.doClick();
                } else {
                    this.parent.getView().bufferAppxEvent(new ActionEvent(this, 1001, "304"));
                }
                evt.consume();
            }
        }
    }

    @Override
    public Point getLocation() {
        if (AppxToolkit.isWebLook() || this.parent.scrollerContains(this.bounds.x, this.bounds.y)) {
            return new Point(this.bounds.x * CharView.charWidth - 2 + this.offset.x, this.bounds.y * CharView.charHeight + 3 + this.offset.y);
        }
        return new Point(this.bounds.x * CharView.charWidth + this.offset.x, this.bounds.y * CharView.charHeight + this.offset.y);
    }

    @Override
    public Dimension getPreferredSize() {
        if (AppxToolkit.isWebLook() || this.parent.scrollerContains(this.bounds.x, this.bounds.y)) {
            return new Dimension(this.bounds.width * CharView.charWidth + 4 + this.offset.width - 1, this.bounds.height * CharView.charHeight - 2 + this.offset.height - 1);
        }
        return new Dimension(this.bounds.width * CharView.charWidth + 5 + this.offset.width, this.bounds.height * CharView.charHeight + this.offset.height);
    }

    @Override
    public void replaceSelection(String content) {
        if (Globals.validateEncodedString(content, this.getEncodingType())) {
            super.replaceSelection(content);
        }
    }

    public void setMask(String msk) {
        this.jmask = msk;
        try {
            MaskFormatter mf = new MaskFormatter(this.jmask);
            mf.setOverwriteMode(true);
            mf.setCommitsOnValidEdit(true);
            this.setFormatterFactory(new DefaultFormatterFactory(mf));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        AppxControlUtils.keyReleased(evt, this.parent);
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        AppxControlUtils.keyTyped(evt, this.parent);
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        try {
            AppxControlUtils.focusGained(this.parent);
            if (this.parent.scrollerContains(this.bounds.x, this.bounds.y) && this.isEnabled()) {
                this.setBorder(BorderFactory.createLineBorder(Color.black));
            }
            if (Globals.getOptionValueBoolean("autoSelect")) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AppxFormattedTextField.this.selectAll();
                    }
                });
            } else {
                int len = this.getText().length();
                this.setSelectionStart(len);
                this.setSelectionEnd(len);
            }
            if (!this.parent.isScreenLocked()) {
                this.parent.getView().putCursor(this.getCellBounds().x, this.getCellBounds().y);
            }
        }
        catch (Exception ex) {
            System.err.println("AppxFormatField.focusGained() exception=" + ex);
        }
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        try {
            if (this.parent.scrollerContains(this.bounds.x, this.bounds.y) && this.isEnabled()) {
                this.setBorder(BorderFactory.createLineBorder(Color.lightGray));
                this.repaint();
            }
            this.setSelectionStart(0);
            this.setSelectionEnd(0);
        }
        catch (Exception ex) {
            System.err.println("AppxFormatField.focusLost() exception=" + ex);
        }
    }

    @Override
    public void initControl(Display disp, int x, int y, int w, int h, boolean ucs) {
        this.setDocument(new FixedLengthPlainDocument(w, ucs, this, disp));
        this.getDocument().addDocumentListener(this);
        this.offset = new Rectangle(0, 0, 0, 0);
        this.maxLen = w;
        this.parent = disp;
        this.setCellBounds(x, y, w, h);
        this.setOpaque(true);
        this.setFont(this.parent.getStdFont());
        this.setHorizontalAlignment(2);
        this.disabledBg = (Color)UIManager.get("ComboBox.disabledBackground");
        this.upperCase = ucs;
        this.pushedBg = null;
        if (UIManager.getBorder("InsetBorder.aquaVariant") != null) {
            this.disabledBg = (Color)UIManager.get("Panel.background");
        }
        this.setTabable(0);
        this.firstGotFocus = true;
        if (AppxToolkit.isWebLook()) {
            this.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        }
    }

    public void setDisabledBackground(Color c) {
        this.disabledBg = c;
        if (this.enabledBg == null) {
            this.enabledBg = this.getBackground();
        }
    }

    public void setDisabledForeground(Color c) {
        this.disabledFg = c;
        if (this.enabledFg == null) {
            this.enabledFg = this.getForeground();
        }
    }

    @Override
    public void updateOptions(AppxControlCache options) {
        AppxField op = (AppxField)options;
        this.setBounds(0, 0, 0, 0);
        this.setToolTipText(op.getToolTipText());
        this.setBackground(op.getBackground());
        this.setForeground(op.getForeground());
        this.setDisabledBackground(op.getDisabledBackground());
        this.setDisabledForeground(op.getDisabledForeground());
        this.setFont(op.getFont());
        this.setText(op.getText());
        this.setBorder(op.getBorder());
        this.setEnabled(op.isEnabled());
        this.setOpaque(op.isOpaque());
        this.setHorizontalAlignment(op.getHorizontalAlignment());
        this.setMargin(op.getMargin());
        this.setOffset(op.getOffset());
        this.setTabable(op.getTabable());
        this.setTouched(op.isTouched());
        this.setMovable(op.isMovable());
    }

    @Override
    public void addScanButton(boolean add) {
    }

    @Override
    public boolean containsCell(int x, int y) {
        return this.bounds.contains(new Point(x, y));
    }

    @Override
    public String getAppxText() {
        return this.getText();
    }

    @Override
    public Rectangle getCellBounds() {
        return this.bounds;
    }

    @Override
    public Rectangle getOffset() {
        return this.offset;
    }

    @Override
    public boolean isTouched() {
        return this.touched;
    }

    @Override
    public void setAppxText(String str) {
        String newStr = str;
        this.setText(newStr);
        this.setCaretPosition(0);
        this.setTouched(false);
    }

    @Override
    public void setCellBounds(int x, int y, int width, int height) {
        this.bounds = new Rectangle(x, y, width, height);
    }

    public void setOffset(int x, int y, int width, int height) {
        this.offset.x = x;
        this.offset.y = y;
        this.offset.width = width;
        this.offset.height = height;
    }

    @Override
    public void setOffset(Rectangle rect) {
        if (rect == null) {
            this.setOffset(0, 0, 0, 0);
        } else {
            this.setOffset(rect.x, rect.y, rect.width, rect.height);
        }
    }

    @Override
    public void setTouched(boolean newTouched) {
        if (this.touched != newTouched) {
            AppxControlUtils.setTouched(newTouched);
        }
        this.touched = newTouched;
    }

    @Override
    public boolean isMovable() {
        return this.movable;
    }

    @Override
    public void setMovable(boolean b) {
        this.movable = b;
    }

    @Override
    public void setOffsetLocation(int x, int y) {
        this.offset.x = x;
        this.offset.y = y;
    }

    @Override
    public Component getEditorComponent() {
        return this;
    }

    @Override
    public Object getItem() {
        return this.getText();
    }

    @Override
    public void setItem(Object anObject) {
        if (anObject != null) {
            this.setText(anObject.toString());
        } else {
            this.setText("");
        }
    }

    @Override
    public boolean isAntiAlias() {
        return this.antiAlias.isAntiAlias();
    }

    @Override
    public void setAntiAlias(boolean b) {
        this.antiAlias.setAntiAlias(b);
    }

    @Override
    public void changedUpdate(DocumentEvent arg0) {
        this.setTouched(true);
    }

    @Override
    public void insertUpdate(DocumentEvent arg0) {
        this.setTouched(true);
    }

    @Override
    public void removeUpdate(DocumentEvent arg0) {
        this.setTouched(true);
    }

    @Override
    public int getTabable() {
        return this.appxControlItemObj.getTabable(this.parent);
    }

    @Override
    public void setTabable(int tab) {
        this.appxControlItemObj.setTabable(tab);
    }

    @Override
    public void setTabable(boolean tab) {
        this.appxControlItemObj.setTabable(tab);
    }

    public byte[] getRawDate() {
        return this.rawDate;
    }

    public void setRawDate(byte[] raw) {
        this.rawDate = raw;
    }

    public void setFld(MFld fld) {
        this.dataModel = fld;
    }

    public MFld getFld() {
        return this.dataModel;
    }

    public void setScanButton(AppxButton b) {
        this.scanButton = b;
    }

    public int getEncodingType() {
        if (this.dataModel == null) {
            return 0;
        }
        return this.dataModel.getEncodingType();
    }

    @Override
    public void pushBgColor(Color c) {
        if (this.pushedBg == null) {
            this.pushedBg = super.getBackground();
            super.setBackground(c);
        }
    }

    @Override
    public void popBgColor() {
        if (this.pushedBg != null) {
            super.setBackground(this.pushedBg);
        }
        this.pushedBg = null;
    }
}

