/*
 * Decompiled with CFR 0.152.
 */
package view;

import doc.AppxToolkit;
import doc.Document;
import doc.Globals;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import view.AppxAquaTextFieldBorder;
import view.AppxButton;
import view.AppxControl;
import view.AppxControlItem;
import view.AppxControlItemObj;
import view.AppxControlUtils;
import view.CharView;
import view.Display;
import view.FixedLengthPlainDocument;
import view.JMaskedTextField;

public class AppxFormatField
extends JMaskedTextField
implements AppxControl,
AppxControlItem,
ActionListener,
FocusListener,
KeyListener,
DocumentListener {
    private static final long serialVersionUID = -7426080031646326263L;
    private byte[] rawDate;
    private boolean touched;
    private boolean upperCase;
    private int maxLen;
    private Color colorSave;
    private Rectangle bounds;
    private Rectangle offset = new Rectangle(0, 0, 0, 0);
    private AppxButton scanButton;
    private AppxControlItemObj ctlItmObj;
    private Display parent;
    private int gotFocusCommand = 65535;
    private int lostFocusCommand = 65535;
    private int valueAdjustedCommand = 65535;
    private boolean movable = false;
    private Color pushedBg;

    public AppxFormatField(Display disp, int x, int y, int width, int height, boolean ucs) {
        this(disp, width, ucs);
        this.setCellBounds(x, y, width, height);
    }

    public AppxFormatField(Display disp, int len, boolean ucs) {
        super(null, len);
        this.setDocument(new FixedLengthPlainDocument(len, ucs, this, this.parent));
        this.getDocument().addDocumentListener(this);
        this.upperCase = ucs;
        this.maxLen = len;
        this.parent = disp;
        this.setTouched(false);
        this.colorSave = null;
        this.offset = AppxControlUtils.nullOffset;
        this.scanButton = null;
        this.ctlItmObj = new AppxControlItemObj();
        this.setFld(null);
        this.setOpaque(true);
        this.setFont(this.parent.getStdFont());
        this.addFocusListener(this);
        this.addKeyListener(this);
        if (AppxToolkit.isWebLook()) {
            this.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        }
        if (UIManager.getBorder("InsetBorder.aquaVariant") != null) {
            this.setBorder(new AppxAquaTextFieldBorder());
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CharView.view.mousePressed(e);
            }
        });
        this.addMouseMotionListener(CharView.view);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
    }

    @Override
    public void addScanButton(boolean add) {
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
        this.setTouched(true);
    }

    @Override
    public boolean containsCell(int x, int y) {
        return this.bounds.contains(new Point(x, y));
    }

    @Override
    public void focusGained(FocusEvent evt) {
        if (this.gotFocusCommand != 65535 && Document.isLocked()) {
            return;
        }
        try {
            AppxControlUtils.focusGained(this.parent, this);
            if (this.parent.scrollerContains(this.bounds.x, this.bounds.y) && this.isEnabled()) {
                this.setBorder(BorderFactory.createLineBorder(Color.black));
            }
            if (Globals.getOptionValueBoolean("autoSelect")) {
                this.selectAll();
            } else {
                int len = this.getText().length();
                this.setSelectionStart(len);
                this.setSelectionEnd(len);
            }
            if (!this.parent.isScreenLocked()) {
                this.parent.getView().putCursor(this.getCellBounds().x, this.getCellBounds().y);
            }
        }
        catch (Exception ex) {
            System.err.println("AppxFormatField.focusGained() exception=" + ex);
        }
        if (this.gotFocusCommand != 65535 && CharView.view.readyForInput) {
            CharView.view.readyForInput = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ActionEvent e = new ActionEvent(AppxFormatField.this, 1001, "" + AppxFormatField.this.gotFocusCommand, 0);
                    AppxFormatField.this.parent.getView().bufferAppxEvent(e);
                }
            });
        }
    }

    @Override
    public void replaceSelection(String content) {
        if (Globals.validateEncodedString(content, this.getEncodingType())) {
            super.replaceSelection(content);
        }
    }

    @Override
    public void focusLost(FocusEvent evt) {
        try {
            AppxControlUtils.focusLost(this.parent, this);
            if (this.parent.scrollerContains(this.bounds.x, this.bounds.y) && this.isEnabled()) {
                this.setBorder(BorderFactory.createLineBorder(Color.lightGray));
                this.repaint();
            }
            this.setSelectionStart(0);
            this.setSelectionEnd(0);
        }
        catch (Exception ex) {
            System.err.println("AppxFormatField.focusLost() exception=" + ex);
        }
        if (this.lostFocusCommand != 65535 && CharView.view.readyForInput && this.parent.getView().isWindowActive()) {
            this.parent.getView().setLostFocusCommand(this.lostFocusCommand, 65535, this);
        }
    }

    @Override
    public String getAppxText() {
        return this.getText();
    }

    @Override
    public Rectangle getCellBounds() {
        return this.bounds;
    }

    @Override
    public Point getLocation() {
        if (AppxToolkit.isWebLook() || this.parent.scrollerContains(this.bounds.x, this.bounds.y)) {
            return new Point(this.bounds.x * CharView.charWidth - 2 + this.offset.x, this.bounds.y * CharView.charHeight + 3 + this.offset.y);
        }
        return new Point(this.bounds.x * CharView.charWidth + this.offset.x, this.bounds.y * CharView.charHeight + this.offset.y);
    }

    @Override
    public Rectangle getOffset() {
        return this.offset;
    }

    @Override
    public Dimension getPreferredSize() {
        if (AppxToolkit.isWebLook() || this.parent.scrollerContains(this.bounds.x, this.bounds.y)) {
            return new Dimension(this.bounds.width * CharView.charWidth + 4 + this.offset.width - 1, this.bounds.height * CharView.charHeight - 2 + this.offset.height - 1);
        }
        return new Dimension(this.bounds.width * CharView.charWidth + 5 + this.offset.width, this.bounds.height * CharView.charHeight + this.offset.height);
    }

    public byte[] getRawDate() {
        return this.rawDate;
    }

    @Override
    public int getTabable() {
        return this.ctlItmObj.getTabable(this.parent);
    }

    @Override
    public String getText() {
        return this.getCleanText();
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        this.setTouched(true);
    }

    @Override
    public boolean isFocusable() {
        return this.ctlItmObj.isFocusable(this.isEnabled() ? super.isFocusable() : false);
    }

    @Override
    public boolean isManagingFocus() {
        return false;
    }

    @Override
    public boolean isTouched() {
        return this.touched;
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        if (AppxControlUtils.keyPressed(evt, this.parent)) {
            if (evt.getKeyCode() == 39 && this.getCaretPosition() == this.maxLen) {
                this.setSelectionStart(this.maxLen);
                this.setSelectionEnd(this.maxLen);
                evt.consume();
            } else if (evt.getKeyCode() == 10) {
                JButton jb = this.parent.getView().getDefaultButton();
                if (jb != null) {
                    jb.doClick();
                } else {
                    this.parent.getView().bufferAppxEvent(new ActionEvent(this, 1001, "304"));
                }
                evt.consume();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        AppxControlUtils.keyReleased(evt, this.parent);
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        AppxControlUtils.keyTyped(evt, this.parent);
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        this.setTouched(true);
    }

    @Override
    public void setAppxText(String str) {
        this.setText(str);
        this.setCaretPosition(0);
    }

    @Override
    public void setCellBounds(int x, int y, int width, int height) {
        this.bounds = new Rectangle(x, y, width, height);
    }

    public void setCellSize(int width, int height) {
    }

    @Override
    public void setEnabled(boolean b) {
        if (this.isEnabled() != b) {
            super.setEnabled(b);
        }
        if (this.isEditable() != b) {
            super.setEditable(b);
        }
        if (this.isEditable()) {
            if (this.colorSave != null) {
                super.setBackground(this.colorSave);
            }
        } else {
            this.colorSave = super.getBackground();
            super.setBackground((Color)UIManager.get("ComboBox.disabledBackground"));
        }
        if (this.scanButton != null) {
            this.scanButton.setEnabled(b);
        }
    }

    public void setFontSize(int s) {
    }

    @Override
    public void setMask(String msk) {
        if (this.upperCase) {
            msk = ">" + msk;
        }
        super.setMask(msk);
    }

    @Override
    public void setOffset(Rectangle r) {
        this.offset = r;
    }

    public void setRawDate(byte[] raw) {
        this.rawDate = raw;
    }

    public void setScanButton(AppxButton b) {
        this.scanButton = b;
    }

    @Override
    public void setTabable(int tab) {
        this.ctlItmObj.setTabable(tab);
    }

    @Override
    public void setTabable(boolean tab) {
        this.ctlItmObj.setTabable(tab);
    }

    @Override
    public void setTouched(boolean newTouched) {
        if (this.parent.isScreenLocked()) {
            return;
        }
        if (this.touched != newTouched) {
            AppxControlUtils.setTouched(newTouched);
        }
        this.touched = newTouched;
    }

    public void updateOptions(AppxControl options) {
        AppxFormatField op = (AppxFormatField)options;
        this.setToolTipText(op.getToolTipText());
        this.setBackground(op.getBackground());
        this.setForeground(op.getForeground());
        this.setFont(op.getFont());
        this.setText(op.getText());
        this.setBorder(op.getBorder());
        this.setEnabled(op.isEnabled());
        this.setHorizontalAlignment(op.getHorizontalAlignment());
        this.setMargin(op.getMargin());
    }

    @Override
    public void paintImmediately(int x, int y, int w, int h) {
        if (!this.parent.isScreenLocked()) {
            super.paintImmediately(x, y, w, h);
        }
    }

    @Override
    public boolean isMovable() {
        return this.movable;
    }

    @Override
    public void setMovable(boolean b) {
        this.movable = b;
    }

    @Override
    public void setOffsetLocation(int x, int y) {
        this.offset.x = x;
        this.offset.y = y;
    }

    public void setGotFocusCommand(int s) {
        this.gotFocusCommand = s;
    }

    public void setGotFocusCommand(String s) {
        this.gotFocusCommand = Integer.parseInt(s);
    }

    public int getGotFocusCommand() {
        return this.gotFocusCommand;
    }

    public void setLostFocusCommand(int s) {
        this.lostFocusCommand = s;
    }

    public void setLostFocusCommand(String s) {
        this.lostFocusCommand = Integer.parseInt(s);
    }

    public int getLostFocusCommand() {
        return this.lostFocusCommand;
    }

    public void setValueAdjustedCommand(int s) {
        this.valueAdjustedCommand = s;
    }

    public void setValueAdjustedCommand(String s) {
        this.valueAdjustedCommand = Integer.parseInt(s);
    }

    public int getValueAdjustedCommand() {
        return this.valueAdjustedCommand;
    }

    @Override
    public void pushBgColor(Color c) {
        if (this.pushedBg == null) {
            this.pushedBg = super.getBackground();
            super.setBackground(c);
        }
    }

    @Override
    public void popBgColor() {
        if (this.pushedBg != null) {
            super.setBackground(this.pushedBg);
        }
        this.pushedBg = null;
    }
}

