/*
 * Decompiled with CFR 0.152.
 */
package view;

import debug.AppxDebug;
import doc.Document;
import doc.Globals;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.KeyEventPostProcessor;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import view.AppxControl;
import view.AppxControlItem;
import view.CharView;
import view.MenuButton;

public class AppxFocusManager
extends FocusManager {
    Stack<Component> history = new Stack();
    CharView parent = null;
    private boolean letter_I_pressed = false;
    private boolean consumeNextKeyTyped = false;

    Component[] childrenTabOrder(Container co) {
        Component[] children = co.getComponents();
        return children;
    }

    void clearHistory() {
        this.history.removeAllElements();
    }

    public boolean compareTabOrder(Component a, Component b) {
        int bx;
        int by;
        Rectangle bounds;
        int ax;
        int ay;
        if (a instanceof JComponent) {
            ay = ((JComponent)a).getY();
            ax = ((JComponent)a).getX();
        } else {
            bounds = a.getBounds();
            ay = bounds.y;
            ax = bounds.x;
        }
        if (b instanceof JComponent) {
            by = ((JComponent)b).getY();
            bx = ((JComponent)b).getX();
        } else {
            bounds = b.getBounds();
            by = bounds.y;
            bx = bounds.x;
        }
        if (Math.abs(ay - by) < 10) {
            return ax < bx;
        }
        return ay < by;
    }

    @Override
    public void focusNextComponent(Component aComponent) {
        if (aComponent instanceof JComponent) {
            Component nc;
            JComponent fc = (JComponent)aComponent;
            Container root = this.getFocusRoot(fc);
            if (!this.history.empty() && this.history.peek() != aComponent) {
                this.history.removeAllElements();
            }
            if (root != null && (nc = this.getFocusableComponentAfter(fc, root, true)) != null) {
                if (this.history.empty() || this.history.peek() == aComponent) {
                    this.history.push(nc);
                }
                if (nc instanceof JComponent) {
                    ((JComponent)nc).grabFocus();
                } else {
                    nc.requestFocus();
                }
            }
        }
    }

    public void focusNextComponentTypeout(Component aComponent) {
        if (aComponent instanceof JComponent) {
            JComponent fc = (JComponent)aComponent;
            Container root = this.getFocusRoot(fc);
            if (!this.history.empty() && this.history.peek() != aComponent) {
                this.history.removeAllElements();
            }
            if (root != null) {
                Component nc = this.getFocusableComponentAfter(fc, root, true);
                if (nc != null && nc instanceof MenuButton) {
                    nc = CharView.focusBox != null && CharView.focusBox.defaultButton != null ? CharView.focusBox.defaultButton : null;
                }
                if (nc != null) {
                    if (this.history.empty() || this.history.peek() == aComponent) {
                        this.history.push(nc);
                    }
                    if (nc instanceof JComponent) {
                        ((JComponent)nc).grabFocus();
                    } else {
                        nc.requestFocus();
                    }
                }
            }
        }
    }

    @Override
    public void focusPreviousComponent(Component aComponent) {
        if (aComponent instanceof JComponent) {
            Component nc;
            JComponent fc = (JComponent)aComponent;
            Container root = this.getFocusRoot(fc);
            if (!this.history.empty() && this.history.peek() == aComponent) {
                this.history.pop();
                if (!this.history.empty()) {
                    Component nc2 = this.history.peek();
                    if (nc2 instanceof JComponent) {
                        ((JComponent)nc2).grabFocus();
                    } else {
                        nc2.requestFocus();
                    }
                    return;
                }
            }
            this.history.removeAllElements();
            if (root != null && (nc = this.getFocusableComponentAfter(fc, root, false)) != null) {
                if (nc instanceof JComponent) {
                    ((JComponent)nc).grabFocus();
                } else {
                    nc.requestFocus();
                }
            }
        }
    }

    public Component getComponentAfter(Container aContainer, Component aComponent) {
        Component nc;
        if (aComponent instanceof JComponent && (nc = (Component)((JComponent)aComponent).getClientProperty("nextFocus")) != null) {
            return nc;
        }
        return this.tabOrderNextComponent(aContainer, aComponent);
    }

    public Component getComponentBefore(Container aContainer, Component aComponent) {
        Component comp = this.inverseGetNextFocusable(aContainer, aComponent);
        if (comp != null) {
            return comp;
        }
        return this.tabOrderPreviousComponent(aContainer, aComponent);
    }

    private Component getDeepestLastComponent(Component component) {
        if (component.isVisible() && (component instanceof JComponent && !((JComponent)component).isManagingFocus() || !(component instanceof JComponent)) && component instanceof Container && ((Container)component).getComponentCount() > 0) {
            return this.getDeepestLastComponent(this.getLastComponent((Container)component));
        }
        return component;
    }

    public Component getFirstComponent(Container aContainer) {
        Component[] orderedChildren = this.childrenTabOrder(aContainer);
        if (orderedChildren.length > 0) {
            return orderedChildren[0];
        }
        return null;
    }

    private Component getFocusableComponentAfter(Component focusedComponent, Container rootContainer, boolean moveForward) {
        Component initialComponent;
        Component nextComponent = initialComponent = focusedComponent;
        while (!((nextComponent = moveForward ? this.getNextComponent(nextComponent, rootContainer, true) : this.getPreviousComponent(nextComponent, rootContainer)) == null || nextComponent == initialComponent || nextComponent.isVisible() && nextComponent.isFocusable() && !(nextComponent instanceof JScrollBar) && (nextComponent.isEnabled() || nextComponent instanceof AppxControlItem && ((AppxControlItem)((Object)nextComponent)).getTabable() == 1))) {
        }
        return nextComponent;
    }

    Container getFocusRoot(Component c) {
        Container p = c.getParent();
        while (p != null) {
            if (p instanceof JComponent && ((JComponent)p).isFocusCycleRoot() || p instanceof Window || p instanceof Dialog) {
                return p;
            }
            p = p.getParent();
        }
        return null;
    }

    public Component getLastComponent(Container aContainer) {
        Component[] orderedChildren = this.childrenTabOrder(aContainer);
        if (orderedChildren.length > 0) {
            return orderedChildren[orderedChildren.length - 1];
        }
        return null;
    }

    private Component getNextComponent(Component component, Container root, boolean canGoDown) {
        Component nsv = null;
        if (canGoDown && component.isVisible() && (!(component instanceof JComponent) || !((JComponent)component).isManagingFocus()) && component instanceof Container && ((Container)component).getComponentCount() > 0) {
            return this.getFirstComponent((Container)component);
        }
        Container parent = component.getParent();
        nsv = this.getComponentAfter(parent, component);
        if (nsv != null) {
            return nsv;
        }
        if (parent == root) {
            return root;
        }
        return this.getNextComponent(parent, root, false);
    }

    private Component getPreviousComponent(Component component, Container root) {
        Container parent = component.getParent();
        if (component instanceof JViewport) {
            component = parent;
            parent = parent.getParent();
        }
        if (component == root) {
            return this.getDeepestLastComponent(root);
        }
        Component nsv = this.getComponentBefore(parent, component);
        if (nsv != null) {
            return this.getDeepestLastComponent(nsv);
        }
        return parent;
    }

    private Component inverseGetNextFocusable(Container cont, Component comp) {
        Component[] children = cont.getComponents();
        int i = 0;
        int c = children.length;
        while (i < c) {
            if (children[i] instanceof JComponent && ((JComponent)children[i]).getClientProperty("nextFocus") == comp) {
                return children[i];
            }
            ++i;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void processKeyEvent(Component focusedComponent, KeyEvent anEvent) {
        if (this.consumeNextKeyTyped && anEvent.getID() == 400) {
            anEvent.consume();
            this.consumeNextKeyTyped = false;
            return;
        }
        if (Globals.getOptionValueBoolean("showTypeaheadLog")) {
            AppxDebug.log("AppxFocusManager.processKeyEvent() event=" + anEvent);
            AppxDebug.log("----");
        }
        if (anEvent.getModifiers() == 2 && anEvent.getID() == 401 && anEvent.getKeyCode() == 112) {
            CharView.view.accessServer(280);
            anEvent.consume();
            return;
        }
        if (anEvent.getKeyChar() == 'I' || anEvent.getKeyChar() == 'i') {
            if (anEvent.getID() == 401) {
                this.letter_I_pressed = true;
            } else if (anEvent.getID() == 402) {
                this.letter_I_pressed = false;
            } else if (anEvent.getID() == 400 && !this.letter_I_pressed) {
                System.err.println("Inexpected Letter 'I' keyboard event received!");
                System.err.println("evt=" + anEvent);
                anEvent.consume();
                return;
            }
        }
        if (anEvent.getKeyCode() == 19) {
            anEvent.consume();
            return;
        }
        try {
            if (this.parent != null && this.parent.isConnected() && CharView.document != null && Document.isLocked()) {
                loops = 0;
                ** if (anEvent.getID() != 401) goto lbl42
                while (Document.isLocked()) {
                    ++loops;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (loops < 5 || !this.parent.paintComponents) continue;
                    loops = 0;
                    this.parent.paintNow();
lbl-1000:
                    // 2 sources

                    {
                    }
                }
            }
lbl42:
            // 4 sources

            if (!(this.parent != null && CharView.focusBox != null && (CharView.topBox.isImageEditor() || !Globals.getOptionValueBoolean("guiInterface") || CharView.focusBox.isIlfEditor()) || anEvent.getKeyCode() != 9 && anEvent.getKeyChar() != '\t' && anEvent.getKeyCode() != CharView.view.getTabSpecialKeyId())) {
                if (focusedComponent instanceof JComponent && (fc = (JComponent)focusedComponent).isManagingFocus() && (anEvent.getModifiers() & 2) != 2) {
                    return;
                }
                if (anEvent.getID() != 401) {
                    anEvent.consume();
                    return;
                }
                this.consumeNextKeyTyped = true;
                if ((anEvent.getModifiers() & 1) == 1) {
                    this.focusPreviousComponent(focusedComponent);
                } else {
                    this.focusNextComponent(focusedComponent);
                }
                anEvent.consume();
            }
        }
        catch (Exception ex) {
            System.err.println("AppxFocusManager.exception=" + ex);
        }
    }

    public void setView(CharView v) {
        this.parent = v;
    }

    private Component tabOrderNextComponent(Container cont, Component cmp) {
        Component[] orderedChildren = this.childrenTabOrder(cont);
        int c = orderedChildren.length;
        if (c == 1) {
            return null;
        }
        int i = 0;
        while (i < c - 1) {
            if (orderedChildren[i] == cmp) {
                return orderedChildren[i + 1];
            }
            ++i;
        }
        return null;
    }

    private Component tabOrderPreviousComponent(Container cont, Component cmp) {
        Component[] orderedChildren = this.childrenTabOrder(cont);
        int c = orderedChildren.length;
        if (c == 1) {
            return null;
        }
        int i = 1;
        while (i < c) {
            if (orderedChildren[i] == cmp) {
                return orderedChildren[i - 1];
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean dispatchEvent(AWTEvent e) {
        FocusEvent fe;
        Component newFocusOwner;
        if (Thread.currentThread().getName().startsWith("CommHandler")) {
            return false;
        }
        if (e.getID() == 1004 && (newFocusOwner = (fe = (FocusEvent)e).getComponent()) instanceof AppxControl && newFocusOwner instanceof FocusListener) {
            FocusListener fl = (FocusListener)((Object)newFocusOwner);
            fl.focusGained(fe);
            super.dispatchEvent(e);
            return true;
        }
        return super.dispatchEvent(e);
    }

    public void waitForComponent(Component comp) {
        long wait = 1L;
        super.enqueueKeyEvents(wait, comp);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        Container target;
        Component source;
        ComponentPeer peer;
        if (!e.isConsumed()) {
            Component comp = e.getComponent();
            this.redispatchEvent(comp, e);
        }
        boolean stopPostProcessing = false;
        List<KeyEventPostProcessor> processors = this.getKeyEventPostProcessors();
        if (processors != null) {
            Iterator<KeyEventPostProcessor> iter = processors.iterator();
            while (!stopPostProcessing && iter.hasNext()) {
                stopPostProcessing = iter.next().postProcessKeyEvent(e);
            }
        }
        if (!stopPostProcessing) {
            this.postProcessKeyEvent(e);
        }
        if (((peer = (source = e.getComponent()).getPeer()) == null || peer instanceof LightweightPeer) && (target = this.getNativeContainer(source)) != null) {
            peer = target.getPeer();
        }
        if (peer != null) {
            if (Globals.getOptionValueBoolean("showTypeaheadLog")) {
                AppxDebug.log("AppxFocusManager.dispatchKeyEvent() peer.handleEvent() event=" + e);
            }
            peer.handleEvent(e);
        }
        return true;
    }

    Container getNativeContainer(Component c) {
        Container p = c.getParent();
        while (p != null && p.isDisplayable() && p.isLightweight()) {
            p = p.getParent();
        }
        return p;
    }

    @Override
    public Component getFocusOwner() {
        if (!Document.isLocked() && CharView.view.isPopupMenuVisible()) {
            return CharView.view.getRootPane();
        }
        return super.getFocusOwner();
    }
}

