/*
 * Decompiled with CFR 0.152.
 */
package view;

import comm.msg.MFld;
import doc.AppxToolkit;
import doc.Document;
import doc.ExtensionFileFilter;
import doc.Globals;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.View;
import view.AppxAntiAliasControl;
import view.AppxAntiAliasHelper;
import view.AppxAquaTextFieldBorder;
import view.AppxControl;
import view.AppxControlCache;
import view.AppxControlItem;
import view.AppxControlItemObj;
import view.AppxControlUtils;
import view.AppxOval3DBorder;
import view.CharView;
import view.Display;
import view.FixedLengthPlainDocument;
import view.ImageEditorBorder;

public class AppxField
extends JTextField
implements ComboBoxEditor,
AppxControl,
AppxControlCache,
AppxControlItem,
FocusListener,
KeyListener,
DocumentListener,
AppxAntiAliasControl,
ActionListener {
    private static final long serialVersionUID = 7764163067975869017L;
    private boolean touched = false;
    private boolean resizable = true;
    private boolean firstGotFocus = true;
    private boolean contentAreaFilled = true;
    private int gotFocusCommand = 65535;
    private int lostFocusCommand = 65535;
    private int valueAdjustedCommand = 65535;
    private Timer valueTimer = new Timer(Globals.getOptionValueInteger("valueChangedTimer"), this);
    private byte[] rawDate;
    private int maxLen;
    private Color disabledFg;
    private Color disabledBg;
    private Color enabledFg;
    private Color enabledBg;
    private Rectangle bounds;
    private Rectangle offset = new Rectangle(0, 0, 0, 0);
    private String dialogTitle = null;
    private int fileChooserMode = -1;
    private MFld dataModel = null;
    private Display parent;
    private ExtensionFileFilter[] fileFilters;
    private AppxControlItemObj appxControlItemObj = new AppxControlItemObj();
    private AppxAntiAliasHelper antiAlias = new AppxAntiAliasHelper();
    private boolean movable = false;
    private int focusOffset;
    private Color pushedBg;

    public void setFileFilter(String s) {
        if (s == null) {
            this.fileFilters = null;
            return;
        }
        String[] filters = s.split("\\|");
        this.fileFilters = new ExtensionFileFilter[filters.length];
        int i = 0;
        while (i < filters.length) {
            String[] exts;
            String desc;
            String[] temp;
            if (filters[i].charAt(0) == '\"') {
                temp = filters[i].substring(1).split("\"");
                desc = temp[0];
                exts = temp[1].split(",");
            } else {
                temp = filters[i].split(",");
                desc = temp[0];
                exts = new String[temp.length - 1];
                System.arraycopy(temp, 1, exts, 0, temp.length - 1);
            }
            this.fileFilters[i] = new ExtensionFileFilter(desc, exts);
            ++i;
        }
    }

    public void setFileFilter(ExtensionFileFilter[] ff) {
        this.fileFilters = ff;
    }

    public ExtensionFileFilter[] getFileFilter() {
        return this.fileFilters;
    }

    @Override
    public boolean isAntiAlias() {
        return this.antiAlias.isAntiAlias();
    }

    @Override
    public void setAntiAlias(boolean b) {
        this.antiAlias.setAntiAlias(b);
    }

    @Override
    public void addScanButton(boolean add) {
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
        this.setTouched(true);
    }

    @Override
    public boolean containsCell(int x, int y) {
        return this.bounds.contains(new Point(x, y));
    }

    @Override
    public void setCaretPosition(int i) {
        super.setCaretPosition(i);
    }

    @Override
    public void focusGained(FocusEvent evt) {
        this.valueTimer.stop();
        if (this.gotFocusCommand != 65535 && Document.isLocked()) {
            return;
        }
        if (!this.firstGotFocus) {
            this.firstGotFocus = true;
            return;
        }
        this.firstGotFocus = false;
        AppxControlUtils.focusGained(this.parent, this);
        this.parent.getView().currentComponent = this;
        if (this.parent.scrollerContains(this.bounds.x, this.bounds.y) && this.isEnabled()) {
            this.setBorder(BorderFactory.createLineBorder(Color.black));
            this.repaint();
        } else if (this.parent.scrollerContains(this.bounds.x, this.bounds.y) && this.isFocusable()) {
            this.setBorder(new ImageEditorBorder());
            this.repaint();
        }
        if (!this.parent.getView().isWindowActive() || this.parent.getView().isJustGotFocus()) {
            if (this.parent.getView().isJustGotFocus()) {
                this.parent.getView().setJustGotFocus(false);
            }
            return;
        }
        if (!(this.parent.isScreenLocked() || this.parent.getCursorPos().x >= this.getCellBounds().x && this.parent.getCursorPos().x < this.getCellBounds().x + this.getCellBounds().width && this.parent.getCursorPos().y >= this.getCellBounds().y && this.parent.getCursorPos().y < this.getCellBounds().y + this.getCellBounds().height)) {
            this.parent.getView().putCursor(this.getCellBounds().x, this.getCellBounds().y);
        }
        int len = this.getText().length();
        if (this.focusOffset > 0) {
            if (this.focusOffset > len) {
                String tmpStr = this.getAppxText();
                while (len < this.focusOffset) {
                    ++len;
                    tmpStr = String.valueOf(tmpStr) + " ";
                }
                this.setAppxText(tmpStr);
            }
            this.setCaretPosition(this.focusOffset);
            this.focusOffset = 0;
        } else if (Globals.getOptionValueBoolean("autoSelect") && CharView.view.lastOption != 333) {
            this.setCaretPosition(len);
            this.moveCaretPosition(0);
        } else if (CharView.view.lastOption == 333 && CharView.view.lastOffset >= 0 && this.getText().length() > CharView.view.lastOffset) {
            this.setCaretPosition(CharView.view.lastOffset);
        } else {
            this.setSelectionStart(len);
            this.setSelectionEnd(len);
        }
        if (this.gotFocusCommand != 65535 && CharView.view.readyForInput) {
            CharView.view.readyForInput = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ActionEvent e = new ActionEvent(AppxField.this, 1001, "" + AppxField.this.gotFocusCommand, 0);
                    AppxField.this.parent.getView().bufferAppxEvent(e);
                }
            });
        }
    }

    @Override
    public void focusLost(FocusEvent evt) {
        this.valueTimer.stop();
        if (Document.isLocked()) {
            return;
        }
        this.setSelectionStart(0);
        this.setSelectionEnd(0);
        this.firstGotFocus = true;
        AppxControlUtils.focusLost(this.parent, this);
        this.parent.getView().currentComponent = null;
        if (this.parent.scrollerContains(this.bounds.x, this.bounds.y) && this.isEnabled()) {
            this.setBorder(BorderFactory.createLineBorder(Color.lightGray));
            this.repaint();
        } else if (this.parent.scrollerContains(this.bounds.x, this.bounds.y) && this.isFocusable()) {
            this.setBorder(BorderFactory.createLineBorder(Color.white));
            this.repaint();
        }
        if (this.lostFocusCommand != 65535 && CharView.view.readyForInput && this.parent.getView().isWindowActive()) {
            this.parent.getView().setLostFocusCommand(this.lostFocusCommand, 65535, this);
        }
    }

    @Override
    public String getAppxText() {
        return this.getText();
    }

    @Override
    public Rectangle getCellBounds() {
        return this.bounds;
    }

    public String getDialogTitle() {
        return this.dialogTitle;
    }

    public void setFileChooserMode(int mode) {
        this.fileChooserMode = mode;
    }

    public int getFileChooserMode() {
        switch (this.fileChooserMode) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    public Color getDisabledBackground() {
        return this.disabledBg;
    }

    public Color getDisabledForeground() {
        return this.disabledFg;
    }

    @Override
    public Component getEditorComponent() {
        return this;
    }

    public MFld getFld() {
        return this.dataModel;
    }

    @Override
    public Object getItem() {
        return this.getText();
    }

    @Override
    public Point getLocation() {
        if (AppxToolkit.isWebLook() || this.parent.scrollerContains(this.bounds.x, this.bounds.y)) {
            return new Point(this.bounds.x * CharView.charWidth - 2 + this.offset.x, this.bounds.y * CharView.charHeight + 3 + this.offset.y);
        }
        return new Point(this.bounds.x * CharView.charWidth + this.offset.x, this.bounds.y * CharView.charHeight + this.offset.y);
    }

    @Override
    public Rectangle getOffset() {
        return this.offset;
    }

    @Override
    public Dimension getPreferredSize() {
        if (AppxToolkit.isWebLook() || this.parent.scrollerContains(this.bounds.x, this.bounds.y)) {
            return new Dimension(this.bounds.width * CharView.charWidth + 4 + this.offset.width - 1, this.bounds.height * CharView.charHeight - 2 + this.offset.height - 1);
        }
        return new Dimension(this.bounds.width * CharView.charWidth + 5 + this.offset.width, this.bounds.height * CharView.charHeight + this.offset.height);
    }

    public byte[] getRawDate() {
        return this.rawDate;
    }

    @Override
    public int getTabable() {
        return this.appxControlItemObj.getTabable(this.parent);
    }

    @Override
    public void initControl(Display disp, int x, int y, int w, int h, boolean ucs) {
        this.setDocument(new FixedLengthPlainDocument(w, ucs, this, disp));
        this.getDocument().addDocumentListener(this);
        this.offset = new Rectangle(0, 0, 0, 0);
        this.maxLen = w;
        this.setResizable(true);
        this.parent = disp;
        this.setCellBounds(x, y, w, h);
        this.setOpaque(true);
        this.setFont(this.parent.getStdFont());
        this.setHorizontalAlignment(2);
        this.disabledBg = (Color)UIManager.get("ComboBox.disabledBackground");
        this.fileFilters = null;
        this.gotFocusCommand = 65535;
        this.lostFocusCommand = 65535;
        this.valueAdjustedCommand = 65535;
        this.pushedBg = null;
        if (UIManager.getBorder("InsetBorder.aquaVariant") != null) {
            this.disabledBg = (Color)UIManager.get("Panel.background");
        }
        this.setTabable(0);
        this.setFocusOffset(0);
        this.firstGotFocus = true;
        if (AppxToolkit.isWebLook()) {
            this.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        }
    }

    @Override
    public void replaceSelection(String content) {
        if (Globals.validateEncodedString(content, this.getEncodingType())) {
            super.replaceSelection(content);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        this.setTouched(true);
    }

    @Override
    public boolean isFocusable() {
        return this.appxControlItemObj.isFocusable(this.isEnabled() ? super.isFocusable() : false);
    }

    @Override
    public boolean isManagingFocus() {
        return false;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    @Override
    public boolean isTouched() {
        return this.touched;
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        try {
            if (evt.getKeyCode() == 0) {
                AppxControlUtils.keyFix(evt);
            }
            if (!Globals.getOptionValueBoolean("guiInterface") && evt.getKeyCode() == 39) {
                if (this.getCaretPosition() == this.maxLen) {
                    this.parent.getView().putCursor(this.getCellBounds().x + this.getCaretPosition(), this.getCellBounds().y, true);
                    evt.consume();
                }
            } else if (!Globals.getOptionValueBoolean("guiInterface") && evt.getKeyCode() == 37) {
                if (this.getCaretPosition() == 0) {
                    this.parent.getView().putCursor(this.getCellBounds().x + this.getCaretPosition() - 1, this.getCellBounds().y, true);
                    evt.consume();
                }
            } else if (evt.getKeyCode() == 10) {
                JButton jb = this.parent.getView().getDefaultButton();
                if (jb != null) {
                    jb.doClick();
                } else {
                    this.parent.getView().bufferAppxEvent(new ActionEvent(this, 1001, "304"));
                }
                evt.consume();
            } else {
                if (!Globals.getOptionValueBoolean("guiInterface")) {
                    this.parent.getView().putCursor(this.getCellBounds().x + this.getCaretPosition(), this.getCellBounds().y);
                }
                if (AppxControlUtils.keyPressed(evt, this.parent) && evt.getKeyCode() == 39 && evt.getModifiers() == 0 && this.getSelectedText() != null) {
                    int pos = this.getSelectionEnd();
                    this.setSelectionStart(pos);
                    this.setSelectionEnd(pos);
                    evt.consume();
                }
            }
        }
        catch (Exception ex) {
            System.err.println("AppxField.keyPressed() exception=" + ex);
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 0) {
            AppxControlUtils.keyFix(evt);
        }
        if (UIManager.getBorder("InsetBorder.aquaVariant") != null) {
            if (evt.getKeyCode() == 40) {
                CharView.view.processArrowKey(20003);
            } else if (evt.getKeyCode() == 38) {
                CharView.view.processArrowKey(20002);
            }
        } else {
            AppxControlUtils.keyReleased(evt, this.parent);
        }
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        AppxControlUtils.keyTyped(evt, this.parent);
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        this.setTouched(true);
    }

    @Override
    public void setAppxText(String str) {
        Container editor;
        View vw;
        BasicTextUI bt = (BasicTextUI)this.getUI();
        if (bt != null && (vw = bt.getRootView(null)) != null && (editor = vw.getContainer()) != null) {
            editor.setSize(this.getPreferredSize());
        }
        this.setText(str);
        this.setCaretPosition(0);
        this.setTouched(false);
    }

    @Override
    public void setBackground(Color c) {
        this.enabledBg = c;
        super.setBackground(c);
    }

    @Override
    public void setCellBounds(int x, int y, int width, int height) {
        this.bounds = new Rectangle(x, y, width, height);
    }

    public void setCellLocation(int x, int y) {
        if (this.bounds != null) {
            this.bounds.x = x + this.parent.getCellBounds().x;
            this.bounds.y = y + this.parent.getCellBounds().y;
        }
    }

    public void setCellSize(int width, int height) {
        if (this.bounds != null) {
            this.bounds.width = width;
            this.bounds.height = height;
        }
    }

    public void setDialogTitle(String title) {
        this.dialogTitle = title;
    }

    public void setDisabledBackground(Color c) {
        this.disabledBg = c;
        if (this.enabledBg == null) {
            this.enabledBg = this.getBackground();
        }
    }

    public void setDisabledForeground(Color c) {
        this.disabledFg = c;
        if (this.enabledFg == null) {
            this.enabledFg = this.getForeground();
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        if (this.isEnabled() != enable) {
            super.setEnabled(enable);
        }
        if (this.isEditable() != enable) {
            super.setEditable(enable);
        }
        if (this.isEnabled()) {
            if (this.enabledFg != null) {
                super.setForeground(this.enabledFg);
            }
            if (this.enabledBg != null) {
                super.setBackground(this.enabledBg);
            }
        } else {
            if (this.disabledFg != null) {
                super.setForeground(this.disabledFg);
            }
            if (this.disabledBg != null) {
                super.setBackground(this.disabledBg);
            }
        }
    }

    public void setFld(MFld fld) {
        this.dataModel = fld;
        if ((fld.getSpecial() & 0x40) == 64) {
            this.setLostFocusCommand("336");
        }
    }

    public void setFontSize(int s) {
    }

    @Override
    public void setForeground(Color c) {
        this.enabledFg = c;
        super.setForeground(c);
    }

    @Override
    public void setItem(Object anObject) {
        if (anObject != null) {
            this.setText(anObject.toString());
        } else {
            this.setText("");
        }
    }

    public void setMaxLen(int len) {
        this.maxLen = len;
        ((FixedLengthPlainDocument)this.getDocument()).setMaxLength(len);
    }

    public void setOffset(int x, int y, int width, int height) {
        this.offset.x = x;
        this.offset.y = y;
        this.offset.width = width;
        this.offset.height = height;
    }

    @Override
    public void setOffset(Rectangle rect) {
        if (rect == null) {
            this.setOffset(0, 0, 0, 0);
        } else {
            this.setOffset(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public void setRawDate(byte[] raw) {
        this.rawDate = raw;
    }

    public void setResizable(boolean b) {
        this.resizable = b;
    }

    @Override
    public void setTabable(int tab) {
        this.appxControlItemObj.setTabable(tab);
    }

    @Override
    public void setTabable(boolean tab) {
        this.appxControlItemObj.setTabable(tab);
    }

    @Override
    public void setTouched(boolean newTouched) {
        if (this.touched != newTouched) {
            AppxControlUtils.setTouched(newTouched);
        }
        this.touched = newTouched;
        if (this.touched && this.valueAdjustedCommand != 65535) {
            this.valueTimer.setDelay(Globals.getOptionValueInteger("valueChangedTimer"));
            this.valueTimer.setInitialDelay(Globals.getOptionValueInteger("valueChangedTimer"));
            this.valueTimer.restart();
        } else {
            this.valueTimer.stop();
        }
    }

    public void setUpperCaseOnly(boolean ucs) {
        ((FixedLengthPlainDocument)this.getDocument()).setUpperCaseOnly(ucs);
    }

    @Override
    public void updateOptions(AppxControlCache options) {
        AppxField op = (AppxField)options;
        this.setBounds(0, 0, 0, 0);
        this.setToolTipText(op.getToolTipText());
        this.setBackground(op.getBackground());
        this.setForeground(op.getForeground());
        this.setDisabledBackground(op.getDisabledBackground());
        this.setDisabledForeground(op.getDisabledForeground());
        this.setFont(op.getFont());
        this.setText(op.getText());
        this.setBorder(op.getBorder());
        this.setEnabled(op.isEnabled());
        this.setOpaque(op.isOpaque());
        this.setHorizontalAlignment(op.getHorizontalAlignment());
        this.setMargin(op.getMargin());
        this.setOffset(op.getOffset());
        this.setResizable(op.isResizable());
        this.setTabable(op.getTabable());
        this.setTouched(op.isTouched());
        this.setMovable(op.isMovable());
        this.setGotFocusCommand(op.getGotFocusCommand());
        this.setLostFocusCommand(op.getLostFocusCommand());
        this.setValueAdjustedCommand(op.getValueAdjustedCommand());
    }

    public AppxField() {
        this.addFocusListener(this);
        this.addKeyListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CharView.view.mousePressed(e);
            }
        });
        this.addMouseMotionListener(CharView.view);
        if (UIManager.getBorder("InsetBorder.aquaVariant") != null) {
            this.setBorder(new AppxAquaTextFieldBorder());
        }
    }

    @Override
    public void paintImmediately(int x, int y, int w, int h) {
        if (!this.parent.isScreenLocked()) {
            super.paintImmediately(x, y, w, h);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.antiAlias.adjustGraphics((Graphics2D)g);
        AppxControlUtils.paintUiComponent(this, g, this.contentAreaFilled);
        super.paintComponent(g);
        this.antiAlias.restoreGraphics((Graphics2D)g);
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        if (border instanceof AppxOval3DBorder) {
            this.contentAreaFilled = this.isOpaque();
            super.setOpaque(false);
        }
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        super.setOpaque(isOpaque);
        this.contentAreaFilled = isOpaque;
    }

    @Override
    public boolean isMovable() {
        return this.movable;
    }

    @Override
    public void setMovable(boolean b) {
        this.movable = b;
    }

    @Override
    public void setOffsetLocation(int x, int y) {
        this.offset.x = x;
        this.offset.y = y;
    }

    public void setFocusOffset(int i) {
        this.focusOffset = i;
    }

    public int getEncodingType() {
        if (this.dataModel == null) {
            return 0;
        }
        return this.dataModel.getEncodingType();
    }

    public void setGotFocusCommand(int s) {
        this.gotFocusCommand = s;
    }

    public void setGotFocusCommand(String s) {
        this.gotFocusCommand = Integer.parseInt(s);
    }

    public int getGotFocusCommand() {
        return this.gotFocusCommand;
    }

    public void setLostFocusCommand(int s) {
        this.lostFocusCommand = s;
    }

    public void setLostFocusCommand(String s) {
        this.lostFocusCommand = Integer.parseInt(s);
    }

    public int getLostFocusCommand() {
        return this.lostFocusCommand;
    }

    public void setValueAdjustedCommand(int s) {
        this.valueAdjustedCommand = s;
    }

    public void setValueAdjustedCommand(String s) {
        this.valueAdjustedCommand = Integer.parseInt(s);
    }

    public int getValueAdjustedCommand() {
        return this.valueAdjustedCommand;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this.valueAdjustedCommand != 65535) {
            CharView.view.lastOffset = this.getCaretPosition();
            CharView.view.readyForInput = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ActionEvent e = new ActionEvent(AppxField.this, 1001, "" + AppxField.this.valueAdjustedCommand, 0);
                    AppxField.this.parent.getView().bufferAppxEvent(e);
                }
            });
        }
    }

    @Override
    public void pushBgColor(Color c) {
        if (this.pushedBg == null) {
            this.pushedBg = super.getBackground();
            super.setBackground(c);
        }
    }

    @Override
    public void popBgColor() {
        if (this.pushedBg != null) {
            super.setBackground(this.pushedBg);
        }
        this.pushedBg = null;
    }
}

