/*
 * Decompiled with CFR 0.152.
 */
package view;

import comm.msg.MDragAndDrop;
import de.wim.outldd.OutlookContactItem;
import de.wim.outldd.OutlookDD;
import de.wim.outldd.OutlookData;
import de.wim.outldd.OutlookItem;
import de.wim.outldd.OutlookMsgItem;
import de.wim.outldd.OutlookMsgProperties;
import de.wim.outldd.OutlookNoteItem;
import doc.AppxToolkit;
import doc.Globals;
import doc.NativeWindows;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import view.AppxTextArea;
import view.CharView;
import view.Display;

public class AppxDropTarget
extends DropTargetAdapter {
    public static final String dirDrop = String.valueOf(Globals.getOptionValueString("dropCachePath")) + File.separator;
    public static final String dirTemp = String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator;
    private static boolean bFirstCall = true;
    public DropTarget dropTarget = new DropTarget();
    private Border borderBeforeDnD = null;
    private int col = 0;
    private JComponent component = null;
    private String wDragAndDrop = null;
    private Display parent = null;
    private int prntType = 0;
    private int row = 0;
    private String command = null;

    public AppxDropTarget(Display disp, int x, int y, int prntType, JComponent comp, String wDnD, String command) {
        if (command == null || command.length() == 0) {
            command = "335";
        }
        if (bFirstCall) {
            bFirstCall = false;
            if (Globals.isWindowsOS()) {
                OutlookDD.setTempDir((File)new File(dirDrop));
                OutlookDD.init((int)OutlookDD.MODE_MEMORY_STREAMS);
            }
        }
        if (disp != null && comp != null && wDnD != null) {
            this.parent = disp;
            this.col = x;
            this.row = y;
            this.prntType = prntType;
            this.component = comp;
            this.command = command;
            String string = this.wDragAndDrop = wDnD == null ? "" : wDnD.toLowerCase();
            if (comp instanceof AppxTextArea) {
                this.dropTarget.setComponent(((AppxTextArea)comp).getTextWidget());
            } else {
                this.dropTarget.setComponent(comp);
            }
            try {
                this.dropTarget.addDropTargetListener(this);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        block21: {
            try {
                try {
                    ArrayList<MDragAndDrop> dndData;
                    block23: {
                        dndData = new ArrayList<MDragAndDrop>();
                        Transferable t = dtde.getTransferable();
                        int action = this.isDnDOk(t);
                        if (this.parent.isScreenLocked() || action == 0) break block21;
                        dtde.acceptDrop(action);
                        if (Globals.isWindowsOS() && OutlookDD.isDataAvail()) {
                            try {
                                try {
                                    OutlookData outlData = OutlookDD.getData();
                                    List items = outlData.getItems();
                                    if (items.size() != 0) {
                                        int i = 0;
                                        for (OutlookItem item : items) {
                                            this.showProgress(++i, items.size());
                                            File tmp = AppxDropTarget.getDropTempFile(item.getFileName());
                                            if (tmp == null) continue;
                                            item.saveContent(tmp);
                                            dndData.add(this.parseDropFile(tmp, item.getFileName(), item));
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    OutlookDD.release();
                                    break block23;
                                }
                            }
                            catch (Throwable throwable) {
                                OutlookDD.release();
                                throw throwable;
                            }
                            OutlookDD.release();
                        } else if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                            int i = 0;
                            List items = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                            for (Object o : items) {
                                File ftmp;
                                System.out.println("file=" + o);
                                if (!(o instanceof File)) continue;
                                this.showProgress(++i, items.size());
                                File item = (File)o;
                                if (item.isDirectory() && !this.wDragAndDrop.equals("file")) {
                                    if (this.wDragAndDrop.equals("dir") || this.wDragAndDrop.equals("both")) {
                                        dndData.add(this.parseDropFile(item, item.getName(), null));
                                        continue;
                                    }
                                    for (File f : this.listEntries(item, true)) {
                                        dndData.add(this.parseDropFile(f, f.getName(), null));
                                    }
                                    continue;
                                }
                                if (!item.isFile() || this.wDragAndDrop.equals("dir")) continue;
                                if (item.getCanonicalPath().toLowerCase().contains(new File(dirTemp).getCanonicalPath().toLowerCase()) && (ftmp = AppxDropTarget.getDropTempFile(item.getName())) != null) {
                                    AppxToolkit.copyURL(item.toURI().toURL(), ftmp);
                                    if (ftmp.canRead()) {
                                        item.delete();
                                        item = ftmp;
                                    }
                                }
                                dndData.add(this.parseDropFile(item, item.getName(), null));
                            }
                        }
                    }
                    if (dndData.size() > 0) {
                        CharView.document.getIOHandler().dndData = dndData;
                        CharView.view.setStatusText("");
                        CharView.view.toFront();
                        System.err.println("AppxDragAndDrop() drop() command=[" + this.command + "]");
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ActionEvent e = new ActionEvent(this.getClass(), 1001, AppxDropTarget.this.command, 0);
                                AppxDropTarget.this.parent.getView().bufferAppxEvent(e);
                            }
                        });
                        break block21;
                    }
                    CharView.view.setStatusText("No valid items dropped");
                    this.dragExit(null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    dtde.dropComplete(true);
                }
            }
            finally {
                dtde.dropComplete(true);
            }
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        Color clr = Color.RED;
        int action = this.isDnDOk(dtde.getTransferable());
        if (action != 0) {
            clr = Color.GREEN;
            dtde.acceptDrag(action);
        } else {
            dtde.rejectDrag();
        }
        this.borderBeforeDnD = this.component.getBorder();
        this.component.setBorder(BorderFactory.createLineBorder(clr));
        this.component.repaint();
    }

    @Override
    public void dragExit(DropTargetEvent dtde) {
        this.component.setBorder(this.borderBeforeDnD);
        this.component.repaint();
        this.borderBeforeDnD = null;
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        dtde.acceptDrag(this.isDnDOk(dtde.getTransferable()));
    }

    protected void finalize() {
        try {
            try {
                super.finalize();
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.dropTarget.removeDropTargetListener(this);
            }
        }
        finally {
            this.dropTarget.removeDropTargetListener(this);
        }
    }

    private static File getDropTempFile(String fn) {
        File tmp = null;
        try {
            tmp = File.createTempFile("dnd", "." + AppxDropTarget.getExtension(fn), new File(dirDrop));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tmp;
    }

    private static String getExtension(String fn) {
        if (fn != null && (fn = new File(fn).getName()).contains(".") && !fn.endsWith(".")) {
            return fn.substring(fn.lastIndexOf(".") + 1).toLowerCase();
        }
        return "";
    }

    private int isDnDOk(Transferable t) {
        int action = 1;
        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            return action;
        }
        if (Globals.isWindowsOS() && OutlookDD.isDataAvail()) {
            return action;
        }
        return 0;
    }

    private List<File> listEntries(File topEntry, boolean recursive) {
        ArrayList<File> files = new ArrayList<File>();
        if (topEntry.isDirectory()) {
            File[] fileArray = topEntry.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File entry = fileArray[n2];
                if (entry.isDirectory()) {
                    if (recursive) {
                        files.addAll(this.listEntries(entry, recursive));
                    }
                } else {
                    files.add(entry);
                }
                ++n2;
            }
        } else {
            files.add(topEntry);
        }
        return files;
    }

    private MDragAndDrop parseDropFile(File fi, String name, OutlookItem item) {
        String path = "";
        String ext = "";
        String type = "";
        int size = 0;
        HashMap<String, String> propsmap = new HashMap<String, String>();
        try {
            String wcmd;
            path = fi.getCanonicalPath();
            ext = AppxDropTarget.getExtension(name);
            if (ext != "" && Globals.isWindowsOS() && (wcmd = NativeWindows.getWindowsCommandForExtension(ext, "open")) != null) {
                propsmap.put("command", wcmd);
            }
            size = (int)fi.length();
            if (item == null) {
                type = fi.isDirectory() ? "folder" : "file";
            } else if (item instanceof OutlookContactItem) {
                String[] stringArray = ((OutlookContactItem)item).getProperties();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    System.out.println("OutlookContactItem prop: " + s);
                    ++n2;
                }
                type = "OutlookContactItem";
            } else if (item instanceof OutlookMsgItem) {
                OutlookMsgProperties props = ((OutlookMsgItem)item).getProperties();
                Enumeration keys = props.keys();
                while (keys.hasMoreElements()) {
                    Object key = keys.nextElement();
                    propsmap.put(key.toString(), props.get(key).toString());
                }
                type = "OutlookMsgItem";
            } else if (item instanceof OutlookNoteItem) {
                propsmap.put("name", ((OutlookNoteItem)item).getName());
                type = "OutlookNoteItem";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new MDragAndDrop(this.row, this.col, this.prntType, path, name, ext, type, size, propsmap);
    }

    private void showProgress(int item, int items) {
        this.parent.getView().setStatusText("Saving dropped item " + item + " of " + items, item / items * 100);
    }
}

