/*
 * Decompiled with CFR 0.152.
 */
package view;

import debug.AppxDebug;
import doc.Globals;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import view.AppxBorder;
import view.AppxControl;
import view.AppxControlItem;
import view.AppxKeyEvent;
import view.AppxOval3DBorder;
import view.CharView;
import view.Display;

public abstract class AppxControlUtils {
    public static Rectangle nullOffset = new Rectangle(0, 0, 0, 0);
    private static int lastKeyPressedCode = -1;

    public static void focusGained(Display display) {
        AppxControlUtils.focusGained(display, null);
    }

    public static void focusGained(Display display, AppxControl ctrl) {
        display.getView().setDefaultButton(display.getDefaultButton());
        if (ctrl != null && ctrl instanceof AppxControlItem && Globals.getOptionValueString("colorFocusedFieldBg") != null && Globals.getOptionValueString("colorFocusedFieldBg").length() > 0) {
            ((AppxControlItem)((Object)ctrl)).pushBgColor(CharView.xlateColor(Globals.getOptionValueString("colorFocusedFieldBg")));
        }
    }

    public static void focusLost(Display display, AppxControl ctrl) {
        if (ctrl != null && ctrl instanceof AppxControlItem && Globals.getOptionValueString("colorFocusedFieldBg") != null && Globals.getOptionValueString("colorFocusedFieldBg").length() > 0) {
            ((AppxControlItem)((Object)ctrl)).popBgColor();
        }
    }

    public static void keyFix(KeyEvent ke) {
        if (ke.getKeyCode() == 0) {
            char c = ke.getKeyChar();
            if (c >= 'a' && c <= 'z') {
                ke.setModifiers(1);
                c = (char)(c - 32);
            }
            ke.setKeyCode(c);
            AppxDebug.log("keyFix 0->" + c);
        }
    }

    public static boolean keyPressed(KeyEvent keyevent, Display display) {
        lastKeyPressedCode = keyevent.getKeyCode();
        if (display.getView().bufferEvents() && !(keyevent instanceof AppxKeyEvent)) {
            display.getView().bufferAppxEvent(keyevent);
            keyevent.consume();
            return false;
        }
        if (CharView.view.optionKey != '\uffff' && keyevent.getKeyChar() == CharView.view.optionKey || CharView.view.optionSpecialKeyId != 0 && keyevent.getKeyCode() != 0 && CharView.view.optionSpecialKeyId == keyevent.getKeyCode() || CharView.view.optionSpecialKey != null && CharView.view.optionSpecialKey.length() != 0 && keyevent.getKeyChar() == CharView.view.optionSpecialKey.charAt(0)) {
            display.getView().bufferAppxEvent(keyevent);
            keyevent.consume();
            return false;
        }
        display.getView().keyPressed(keyevent);
        return true;
    }

    public static boolean keyReleased(KeyEvent keyevent, Display display) {
        display.getView().startInteractiveTimer();
        if (display.getView().bufferEvents() && !(keyevent instanceof AppxKeyEvent)) {
            display.getView().bufferAppxEvent(keyevent);
            keyevent.consume();
            return false;
        }
        display.getView().keyReleased(keyevent);
        return true;
    }

    public static boolean keyTyped(KeyEvent keyevent, Display display) {
        if (display.getView().bufferEvents() && !(keyevent instanceof AppxKeyEvent)) {
            display.getView().bufferAppxEvent(keyevent);
            keyevent.consume();
            return false;
        }
        if (lastKeyPressedCode == CharView.view.optionSpecialKeyId) {
            keyevent.consume();
        }
        if (CharView.view.optionKey != '\uffff' && keyevent.getKeyChar() == CharView.view.optionKey || CharView.view.optionSpecialKeyId != 0 && keyevent.getKeyCode() != 0 && CharView.view.optionSpecialKeyId == keyevent.getKeyCode() || CharView.view.optionSpecialKey != null && CharView.view.optionSpecialKey.length() != 0 && keyevent.getKeyChar() == CharView.view.optionSpecialKey.charAt(0)) {
            display.getView().bufferAppxEvent(keyevent);
            keyevent.consume();
        } else if (display.getView().seqIdx > 0 && keyevent.getKeyChar() >= '0' && keyevent.getKeyChar() <= '9') {
            display.getView().bufferAppxEvent(keyevent);
            keyevent.consume();
        }
        return true;
    }

    public static void setMargin(JComponent comp, Insets insets) {
        Border activeBorder = comp.getBorder();
        Border marginBorder = BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right);
        if (activeBorder == null) {
            comp.setBorder(marginBorder);
        } else {
            comp.setBorder(BorderFactory.createCompoundBorder(activeBorder, marginBorder));
        }
    }

    public static void paintUiComponent(JComponent c, Graphics g, boolean filled) {
        if (!c.isOpaque() && filled && c.getBorder() instanceof AppxOval3DBorder) {
            AppxOval3DBorder b = (AppxOval3DBorder)c.getBorder();
            b.fillBackground(g, 0, 0, c.getPreferredSize().width, c.getPreferredSize().height, c.getBackground());
        }
    }

    public static void fillComponent(JComponent c, Graphics g) {
        AppxBorder b = (AppxBorder)c.getBorder();
        b.fillBackground(g, 0, 0, c.getPreferredSize().width, c.getPreferredSize().height, c.getBackground());
    }

    public static void setTouched(boolean newTouched) {
        CharView.view.setTouched(newTouched);
    }
}

