/*
 * Decompiled with CFR 0.152.
 */
package view;

import doc.AppxResource;
import doc.AppxToolkit;
import doc.Document;
import doc.Globals;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import view.AppxAntiAliasControl;
import view.AppxAntiAliasHelper;
import view.AppxAquaTextFieldBorder;
import view.AppxControl;
import view.AppxControlCache;
import view.AppxControlItem;
import view.AppxControlItemObj;
import view.AppxControlUtils;
import view.AppxFocusManager;
import view.CharView;
import view.Display;

public final class AppxCheckBox
extends JCheckBox
implements AppxControl,
AppxControlCache,
AppxControlItem,
ActionListener,
KeyListener,
ItemListener,
FocusListener,
AppxAntiAliasControl {
    private static final long serialVersionUID = 6123107148497081201L;
    public static final int STATE_FALSE = 2;
    public static final int STATE_NULL = 0;
    public static final int STATE_TRUE = 1;
    private AppxControlItemObj appxControlItemObj = new AppxControlItemObj();
    protected int appxState = 0;
    private Rectangle bounds;
    private boolean focus = false;
    private boolean nullOk = true;
    private Rectangle offset = new Rectangle(0, 0, 0, 0);
    private Display parent;
    private boolean touched = false;
    private Color disabledBg;
    private Color disabledFg;
    private Color enabledBg;
    private Color enabledFg;
    private Color rolloverBg;
    private Color rolloverFg;
    private int gotFocusCommand = 65535;
    private int lostFocusCommand = 65535;
    private int valueAdjustedCommand = 65535;
    private Timer valueTimer = new Timer(Globals.getOptionValueInteger("valueChangedTimer"), this);
    private AppxAntiAliasHelper antiAlias = new AppxAntiAliasHelper();
    private boolean movable = false;
    private Color pushedBg;

    @Override
    public boolean isAntiAlias() {
        return this.antiAlias.isAntiAlias();
    }

    @Override
    public void setAntiAlias(boolean b) {
        this.antiAlias.setAntiAlias(b);
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.antiAlias.adjustGraphics((Graphics2D)g);
        AppxControlUtils.paintUiComponent(this, g, this.isContentAreaFilled());
        super.paintComponent(g);
        this.antiAlias.restoreGraphics((Graphics2D)g);
    }

    public AppxCheckBox() {
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.setBorderPainted(true);
        JToggleButton.ToggleButtonModel bm = new JToggleButton.ToggleButtonModel(){
            private static final long serialVersionUID = -6873583677609772498L;

            @Override
            public boolean isSelected() {
                return AppxCheckBox.this.appxState == 1;
            }
        };
        if (UIManager.getBorder("InsetBorder.aquaVariant") != null) {
            this.setBorder(new AppxAquaTextFieldBorder());
        } else {
            this.setBorder(UIManager.getBorder("TextField.border"));
        }
        bm.addItemListener(this);
        this.setModel(bm);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CharView.view.mousePressed(e);
            }
        });
        this.addMouseMotionListener(CharView.view);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this.valueAdjustedCommand != 65535) {
            CharView.view.lastOffset = 0;
            CharView.view.readyForInput = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ActionEvent e = new ActionEvent(AppxCheckBox.this, 1001, "" + AppxCheckBox.this.valueAdjustedCommand, 0);
                    AppxCheckBox.this.parent.getView().bufferAppxEvent(e);
                }
            });
        } else {
            this.parent.getView().bufferAppxEvent(arg0);
        }
    }

    @Override
    public void addScanButton(boolean add) {
    }

    @Override
    public boolean containsCell(int x, int y) {
        return this.bounds.contains(new Point(x, y));
    }

    @Override
    public void focusGained(FocusEvent evt) {
        this.valueTimer.stop();
        if (this.gotFocusCommand != 65535 && Document.isLocked()) {
            return;
        }
        AppxControlUtils.focusGained(this.parent, this);
        this.focus = true;
        if (!this.parent.isScreenLocked()) {
            this.parent.getView().putCursor(this.bounds.x, this.bounds.y);
        }
        if (this.gotFocusCommand != 65535 && CharView.view.readyForInput) {
            CharView.view.readyForInput = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ActionEvent e = new ActionEvent(AppxCheckBox.this, 1001, "" + AppxCheckBox.this.gotFocusCommand, 0);
                    AppxCheckBox.this.parent.getView().bufferAppxEvent(e);
                }
            });
        }
    }

    @Override
    public void focusLost(FocusEvent evt) {
        this.focus = false;
        this.valueTimer.stop();
        AppxControlUtils.focusLost(this.parent, this);
        if (this.lostFocusCommand != 65535 && CharView.view.readyForInput && this.parent.getView().isWindowActive()) {
            this.parent.getView().setLostFocusCommand(this.lostFocusCommand, 65535, this);
        }
    }

    public int getAppxState() {
        return this.appxState;
    }

    @Override
    public String getAppxText() {
        char ch = ' ';
        if (this.getAppxState() == 1) {
            ch = (char)CharView.document.langId.ucsYes;
        }
        if (this.getAppxState() == 2) {
            ch = (char)CharView.document.langId.ucsNo;
        }
        return "" + ch;
    }

    @Override
    public Rectangle getCellBounds() {
        return this.bounds;
    }

    @Override
    public Icon getIcon() {
        if (this.appxState == 0) {
            return AppxResource.Gfx.CHECK_NULL_ICON.icon();
        }
        if (this.appxState == 1) {
            return AppxResource.Gfx.CHECK_TRUE_ICON.icon();
        }
        return AppxResource.Gfx.CHECK_FALSE_ICON.icon();
    }

    @Override
    public Insets getInsets() {
        return new Insets(3, 3, 3, 3);
    }

    @Override
    public Point getLocation() {
        if (this.parent.scrollerContains(this.bounds.x, this.bounds.y)) {
            return new Point(this.bounds.x * CharView.charWidth + this.offset.x, this.bounds.y * CharView.charHeight + this.offset.y + (CharView.charHeight - this.getPreferredSize().height) / 2 + 1);
        }
        return new Point(this.bounds.x * CharView.charWidth + this.offset.x, this.bounds.y * CharView.charHeight + this.offset.y + (CharView.charHeight - this.getPreferredSize().height) / 2);
    }

    @Override
    public Rectangle getOffset() {
        return this.offset;
    }

    @Override
    public Dimension getPreferredSize() {
        Icon icon = this.getIcon();
        return new Dimension(icon.getIconWidth() + 6, icon.getIconHeight() + 6);
    }

    @Override
    public int getTabable() {
        return this.appxControlItemObj.getTabable(this.parent);
    }

    @Override
    public String getText() {
        return null;
    }

    @Override
    public void initControl(Display disp, int x, int y, int width, int height, boolean ucs) {
        this.parent = disp;
        this.setTouched(false);
        this.pushedBg = null;
        this.disabledBg = (Color)UIManager.get("ComboBox.disabledBackground");
        if (AppxToolkit.isWebLook()) {
            this.setBackground(Color.white);
        }
        this.setOpaque(true);
        this.setCellBounds(x, y, width, height);
        this.offset = new Rectangle(0, 0, 0, 0);
    }

    boolean isFocus() {
        return this.focus;
    }

    @Override
    public boolean isFocusable() {
        return this.appxControlItemObj.isFocusable(this.isEnabled() ? super.isFocusable() : false);
    }

    @Override
    public boolean isManagingFocus() {
        return false;
    }

    public boolean isNullOk() {
        return this.nullOk;
    }

    @Override
    public boolean isTouched() {
        return this.touched;
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        this.setTouched(true);
        ++this.appxState;
        if (this.appxState > 2) {
            this.appxState = 0;
        }
        if (this.appxState == 0 && !this.nullOk) {
            this.appxState = 1;
        }
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        AppxControlUtils.keyPressed(evt, this.parent);
        if (evt.getKeyCode() == 10) {
            JButton jb = this.parent.getView().getDefaultButton();
            if (jb != null) {
                jb.doClick();
            } else {
                this.parent.getView().bufferAppxEvent(new ActionEvent(this, 1001, "304"));
            }
            evt.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        AppxControlUtils.keyReleased(evt, this.parent);
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        if (AppxControlUtils.keyTyped(evt, this.parent)) {
            if (!this.isEnabled()) {
                return;
            }
            FocusManager fm = FocusManager.getCurrentManager();
            if (this.parent.getView().isLogYes((byte)evt.getKeyChar())) {
                this.setAppxState(1);
                this.setTouched(true);
                this.fireStateChanged();
                if (fm instanceof AppxFocusManager) {
                    ((AppxFocusManager)fm).focusNextComponentTypeout(this);
                } else {
                    fm.focusNextComponent(this);
                }
            } else if (this.parent.getView().isLogNo((byte)evt.getKeyChar())) {
                this.setAppxState(2);
                this.setTouched(true);
                this.fireStateChanged();
                if (fm instanceof AppxFocusManager) {
                    ((AppxFocusManager)fm).focusNextComponentTypeout(this);
                } else {
                    fm.focusNextComponent(this);
                }
            } else if (evt.getKeyChar() == ' ') {
                this.doClick();
            }
            evt.consume();
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (UIManager.getBorder("InsetBorder.aquaVariant") != null) {
            return;
        }
        if (this.hasFocus()) {
            this.paintFocus(g);
        }
    }

    protected void paintFocus(Graphics g) {
        if (this.hasFocus()) {
            Dimension ps = this.getPreferredSize();
            Border b = this.getBorder();
            Insets bi = null;
            bi = b == null ? Globals.zeroInsets : (AppxToolkit.isJavaLook() ? new Insets(2, 2, 2, 2) : b.getBorderInsets(this));
            g.setXORMode(Color.white);
            g.setColor(new Color(0, 0, 128));
            g.drawRect(bi.left, bi.top, ps.width - bi.right - bi.left - 1, ps.height - bi.bottom - bi.top - 1);
            g.setPaintMode();
        }
    }

    public void setAppxState(int newAppxState) {
        this.appxState = newAppxState;
    }

    @Override
    public void setAppxText(String str) {
        if (str != null && str.length() > 0 && str.charAt(0) == CharView.document.langId.ucsYes) {
            this.setAppxState(1);
        } else if (str != null && str.length() > 0 && str.charAt(0) == CharView.document.langId.ucsNo) {
            this.setAppxState(2);
        } else {
            this.setAppxState(0);
        }
    }

    @Override
    public void setCellBounds(int x, int y, int width, int height) {
        this.bounds = new Rectangle(x, y, width, height);
    }

    public void setCellSize(int width, int height) {
        if (this.bounds != null) {
            this.bounds.width = width;
            this.bounds.height = height;
        }
    }

    void setFocus(boolean newFocus) {
        this.focus = newFocus;
    }

    public void setNullOk(boolean newNullOk) {
        this.nullOk = newNullOk;
    }

    public void setOffset(int x, int y, int width, int height) {
        this.offset.x = x;
        this.offset.y = y;
        this.offset.width = width;
        this.offset.height = height;
    }

    @Override
    public void setOffset(Rectangle rect) {
        if (rect == null) {
            this.setOffset(0, 0, 0, 0);
        } else {
            this.setOffset(rect.x, rect.y, rect.width, rect.height);
        }
    }

    @Override
    public void setTabable(boolean tab) {
        this.appxControlItemObj.setTabable(tab);
    }

    @Override
    public void setTabable(int tab) {
        this.appxControlItemObj.setTabable(tab);
    }

    @Override
    public void setText(String s) {
    }

    @Override
    public void setTouched(boolean newTouched) {
        if (this.parent.isScreenLocked()) {
            return;
        }
        if (this.touched != newTouched) {
            AppxControlUtils.setTouched(newTouched);
        }
        this.touched = newTouched;
        if (this.touched && this.valueAdjustedCommand != 65535) {
            this.valueTimer.setDelay(Globals.getOptionValueInteger("valueChangedTimer"));
            this.valueTimer.setInitialDelay(Globals.getOptionValueInteger("valueChangedTimer"));
            this.valueTimer.restart();
        } else {
            this.valueTimer.stop();
        }
    }

    @Override
    public void updateOptions(AppxControlCache options) {
        AppxCheckBox op = (AppxCheckBox)options;
        this.setActionCommand(op.getActionCommand());
        this.setToolTipText(op.getToolTipText());
        this.setBackground(op.getBackground());
        this.setForeground(op.getForeground());
        this.setFont(op.getFont());
        this.setRolloverEnabled(op.isRolloverEnabled());
        this.setRolloverIcon(null);
        this.setDisabledIcon(null);
        this.setRolloverSelectedIcon(null);
        this.setPressedIcon(null);
        this.setSelectedIcon(null);
        this.setIcon(null);
        this.setText(op.getText());
        this.setSelected(op.isSelected());
        this.setBorder(op.getBorder());
        this.setBorderPainted(op.isBorderPainted());
        this.setFocusPainted(op.isFocusPainted());
        this.setEnabled(op.isEnabled());
        this.setOpaque(op.isOpaque());
        this.setHorizontalAlignment(op.getHorizontalAlignment());
        this.setVerticalAlignment(op.getVerticalAlignment());
        this.setHorizontalTextPosition(op.getHorizontalTextPosition());
        this.setVerticalTextPosition(op.getVerticalTextPosition());
        this.setMnemonic(op.getMnemonic());
        this.setMargin(op.getMargin());
        this.setOffset(op.getOffset());
        this.setMovable(op.isMovable());
    }

    public Color getDisabledBackground() {
        return this.disabledBg;
    }

    public Color getDisabledForeground() {
        return this.disabledFg;
    }

    public Color getRolloverBackground() {
        return this.rolloverBg;
    }

    public Color getRolloverForeground() {
        return this.rolloverFg;
    }

    @Override
    public void setBackground(Color c) {
        this.enabledBg = c;
        super.setBackground(c);
    }

    public void setDisabledBackground(Color c) {
        this.disabledBg = c;
        if (this.enabledBg == null) {
            this.enabledBg = this.getBackground();
        }
    }

    public void setDisabledForeground(Color c) {
        this.disabledFg = c;
        if (this.enabledFg == null) {
            this.enabledFg = this.getForeground();
        }
    }

    @Override
    public void setForeground(Color c) {
        this.enabledFg = c;
        super.setForeground(c);
    }

    public void setRolloverBackground(Color c) {
        this.rolloverBg = c;
        if (this.enabledBg == null) {
            this.enabledBg = this.getBackground();
        }
    }

    public void setRolloverForeground(Color c) {
        this.rolloverFg = c;
        if (this.enabledFg == null) {
            this.enabledFg = this.getForeground();
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        if (this.isEnabled() != enable) {
            super.setEnabled(enable);
        }
        if (this.isEnabled()) {
            if (this.enabledFg != null) {
                super.setForeground(this.enabledFg);
            }
            if (this.enabledBg != null) {
                super.setBackground(this.enabledBg);
            }
        } else {
            if (this.disabledFg != null) {
                super.setForeground(this.disabledFg);
            }
            if (this.disabledBg != null) {
                super.setBackground(this.disabledBg);
            }
        }
    }

    @Override
    public void paintImmediately(int x, int y, int w, int h) {
        if (!this.parent.isScreenLocked()) {
            super.paintImmediately(x, y, w, h);
        }
    }

    public void processMouseEvent2(MouseEvent e) {
        if (!this.isEnabled()) {
            e.consume();
            return;
        }
        int id = e.getID();
        boolean repaint = false;
        switch (id) {
            case 505: {
                if (this.enabledFg != null) {
                    super.setForeground(this.enabledFg);
                    if (this.enabledFg.getAlpha() < 255) {
                        repaint = true;
                    }
                }
                if (this.enabledBg == null) break;
                super.setBackground(this.enabledBg);
                if (this.enabledBg.getAlpha() >= 255) break;
                repaint = true;
                break;
            }
            case 504: {
                if (this.isEnabled() && this.rolloverFg != null) {
                    super.setForeground(this.rolloverFg);
                    if (this.rolloverFg.getAlpha() < 255) {
                        repaint = true;
                    }
                }
                if (!this.isEnabled() || this.rolloverBg == null) break;
                super.setBackground(this.rolloverBg);
                if (this.rolloverBg.getAlpha() >= 255) break;
                repaint = true;
            }
        }
        if (repaint) {
            this.parent.repaint();
        }
    }

    @Override
    public boolean isMovable() {
        return this.movable;
    }

    @Override
    public void setMovable(boolean b) {
        this.movable = b;
    }

    @Override
    public void setOffsetLocation(int x, int y) {
        this.offset.x = x;
        this.offset.y = y;
    }

    public void setGotFocusCommand(int s) {
        this.gotFocusCommand = s;
    }

    public void setGotFocusCommand(String s) {
        this.gotFocusCommand = Integer.parseInt(s);
    }

    public int getGotFocusCommand() {
        return this.gotFocusCommand;
    }

    public void setLostFocusCommand(int s) {
        this.lostFocusCommand = s;
    }

    public void setLostFocusCommand(String s) {
        this.lostFocusCommand = Integer.parseInt(s);
    }

    public int getLostFocusCommand() {
        return this.lostFocusCommand;
    }

    public void setValueAdjustedCommand(int s) {
        this.valueAdjustedCommand = s;
    }

    public void setValueAdjustedCommand(String s) {
        this.valueAdjustedCommand = Integer.parseInt(s);
    }

    public int getValueAdjustedCommand() {
        return this.valueAdjustedCommand;
    }

    @Override
    public void pushBgColor(Color c) {
        if (this.pushedBg == null) {
            this.pushedBg = super.getBackground();
            super.setBackground(c);
        }
    }

    @Override
    public void popBgColor() {
        if (this.pushedBg != null) {
            super.setBackground(this.pushedBg);
        }
        this.pushedBg = null;
    }
}

