/*
 * Decompiled with CFR 0.152.
 */
package view;

import doc.AppxResource;
import doc.AppxToolkit;
import doc.Globals;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.plaf.ButtonUI;
import view.AppxBasicButtonUI;
import view.AppxControl;
import view.AppxControlUtils;
import view.CharView;
import view.Display;

public final class AppxButton
extends JButton
implements AppxControl {
    private static final long serialVersionUID = -2692010082351057179L;
    public static final String what_str = "@(#)Appx $Header: /src/cvs/joe/view/AppxButton.java,v 1.2.2.14 2007/12/11 19:31:31 pete Exp $";
    public static final int SCAN = 2;
    public static final int DATE = 4;
    public static final int COLOR = 6;
    public static final int FILE = 8;
    private Point position;
    private int buttonType;
    private Display parent;
    private AppxControl field;
    private Rectangle offset = AppxControlUtils.nullOffset;
    private boolean movable = false;

    @Override
    public void addScanButton(boolean add) {
    }

    @Override
    public boolean containsCell(int x, int y) {
        return false;
    }

    @Override
    public String getAppxText() {
        return this.getText();
    }

    @Override
    public Rectangle getCellBounds() {
        return null;
    }

    public Point getCellLocation() {
        return this.position;
    }

    public AppxControl getField() {
        return this.field;
    }

    @Override
    public Point getLocation() {
        switch (this.buttonType) {
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                if (this.field == null) {
                    if (AppxToolkit.isWebLook()) {
                        return new Point(this.position.x * CharView.charWidth + 1, this.position.y * CharView.charHeight + 3);
                    }
                    return new Point(this.position.x * CharView.charWidth + 2, this.position.y * CharView.charHeight + 3);
                }
                return new Point(this.field.getLocation().x + this.field.getPreferredSize().width, this.field.getLocation().y);
            }
        }
        return new Point(0, 0);
    }

    @Override
    public Rectangle getOffset() {
        return this.offset;
    }

    @Override
    public Dimension getPreferredSize() {
        if (Globals.getOptionValueBoolean("newScanButton") && this.buttonType == 2) {
            return super.getMinimumSize();
        }
        return new Dimension((int)((double)CharView.charWidth * 2.75), CharView.charHeight);
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public boolean isManagingFocus() {
        return this.parent != null && this.parent.isIlfEditor();
    }

    @Override
    public boolean isTouched() {
        return false;
    }

    public AppxButton(Display disp, int x, int y, int type) {
        this.setFocusPainted(false);
        this.parent = disp;
        this.setOpaque(true);
        this.buttonType = type;
        this.position = new Point(x, y);
        this.updateUI();
        if (AppxToolkit.isWebLook()) {
            this.setBorder(BorderFactory.createLineBorder(Color.darkGray));
            if (this.buttonType == 2 || this.buttonType == 4 || this.buttonType == 6 || this.buttonType == 8) {
                this.setBackground(Color.white);
            } else {
                this.setBackground(new Color(255, 255, 204));
            }
        }
        switch (this.buttonType) {
            case 2: {
                this.setActionCommand(Integer.toString(257));
                this.setToolTipText(Globals.getOptionValueString("scanTooltip"));
                if (!Globals.getOptionValueBoolean("newScanButton")) break;
                this.setIcon(AppxResource.Gfx.SCAN_ICON.icon());
                this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
                this.setMargin(Globals.zeroInsets);
                this.setOpaque(false);
                break;
            }
            case 4: {
                this.setActionCommand(Integer.toString(21000));
                break;
            }
            case 6: {
                this.setActionCommand(Integer.toString(21001));
                break;
            }
            case 8: {
                this.setActionCommand(Integer.toString(21002));
            }
        }
    }

    @Override
    public boolean isOpaque() {
        if (Globals.getOptionValueBoolean("newScanButton")) {
            return false;
        }
        return super.isOpaque();
    }

    public AppxButton(Display disp, int type) {
        this(disp, 0, 0, type);
    }

    @Override
    public void paintComponent(Graphics g) {
        Point start;
        Point center;
        Dimension prefSize;
        super.paintComponent(g);
        if (this.getIcon() != null) {
            return;
        }
        if (this.buttonType == 2) {
            prefSize = this.getPreferredSize();
            center = new Point(prefSize.width / 2, prefSize.height / 2);
            start = new Point(center.x - 5, center.y - 5);
            if (this.isEnabled()) {
                g.setColor(Color.black);
            } else {
                g.setColor(Color.gray);
            }
            g.drawLine(start.x + 0, start.y + 3, start.x + 0, start.y + 9);
            g.drawLine(start.x + 1, start.y + 2, start.x + 1, start.y + 3);
            g.drawLine(start.x + 2, start.y + 0, start.x + 2, start.y + 9);
            g.drawLine(start.x + 3, start.y + 0, start.x + 3, start.y + 9);
            g.drawLine(start.x + 5, start.y + 4, start.x + 5, start.y + 6);
            g.drawLine(start.x + 6, start.y + 0, start.x + 6, start.y + 9);
            g.drawLine(start.x + 7, start.y + 0, start.x + 7, start.y + 9);
            g.drawLine(start.x + 8, start.y + 2, start.x + 8, start.y + 9);
            g.drawLine(start.x + 9, start.y + 3, start.x + 9, start.y + 9);
            g.drawLine(start.x + 4, start.y + 4, start.x + 5, start.y + 4);
            g.drawLine(start.x + 1, start.y + 6, start.x + 5, start.y + 6);
            g.drawLine(start.x + 1, start.y + 9, start.x + 2, start.y + 9);
        }
        if (this.buttonType == 8) {
            prefSize = this.getPreferredSize();
            center = new Point(prefSize.width / 2 + 1, prefSize.height / 2);
            start = new Point(center.x - 5, center.y - 5);
            g.drawLine(start.x + 5, start.y + 0, start.x + 6, start.y + 0);
            g.drawLine(start.x + 7, start.y + 1, start.x + 9, start.y + 3);
            g.drawLine(start.x + 7, start.y + 3, start.x + 8, start.y + 3);
            g.drawLine(start.x + 9, start.y + 1, start.x + 9, start.y + 2);
            g.drawLine(start.x - 2, start.y + 2, start.x + 0, start.y + 2);
            g.drawLine(start.x - 3, start.y + 3, start.x - 3, start.y + 10);
            g.drawLine(start.x + 1, start.y + 3, start.x + 5, start.y + 3);
            g.drawLine(start.x + 5, start.y + 3, start.x + 5, start.y + 4);
            g.drawLine(start.x - 2, start.y + 10, start.x + 5, start.y + 10);
            g.drawLine(start.x + 6, start.y + 9, start.x + 9, start.y + 6);
            g.drawLine(start.x + 2, start.y + 5, start.x + 9, start.y + 5);
            if (this.isEnabled()) {
                g.setColor(Color.yellow);
            } else {
                g.setColor(Color.lightGray);
            }
            g.drawLine(start.x - 2, start.y + 3, start.x + 0, start.y + 3);
            g.drawLine(start.x - 2, start.y + 4, start.x + 4, start.y + 4);
            g.drawLine(start.x - 2, start.y + 5, start.x + 1, start.y + 5);
            g.drawLine(start.x - 2, start.y + 6, start.x + 8, start.y + 6);
            g.drawLine(start.x - 2, start.y + 7, start.x + 7, start.y + 7);
            g.drawLine(start.x - 2, start.y + 8, start.x + 6, start.y + 8);
            g.drawLine(start.x - 2, start.y + 9, start.x + 5, start.y + 9);
            if (this.isEnabled()) {
                g.setColor(Color.black);
            } else {
                g.setColor(Color.gray);
            }
            g.drawLine(start.x - 2, start.y + 9, start.x + 1, start.y + 6);
        }
        if (this.buttonType == 4) {
            prefSize = this.getPreferredSize();
            center = new Point(prefSize.width / 2 + 1, prefSize.height / 2);
            start = new Point(center.x - 5, center.y - 5);
            if (this.isEnabled()) {
                g.setColor(Color.blue);
            } else {
                g.setColor(Color.gray);
            }
            g.drawLine(start.x - 2, start.y + 0, start.x - 2, start.y + 0);
            g.drawLine(start.x + 0, start.y + 0, start.x + 0, start.y + 0);
            g.drawLine(start.x + 2, start.y + 0, start.x + 2, start.y + 0);
            g.drawLine(start.x + 4, start.y + 0, start.x + 4, start.y + 0);
            g.drawLine(start.x + 6, start.y + 0, start.x + 6, start.y + 0);
            g.drawLine(start.x + 8, start.y + 0, start.x + 8, start.y + 0);
            if (this.isEnabled()) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.gray);
            }
            g.drawLine(start.x - 2, start.y + 2, start.x + 8, start.y + 2);
            if (this.isEnabled()) {
                g.setColor(Color.black);
            } else {
                g.setColor(Color.gray);
            }
            g.drawLine(start.x + 0, start.y + 4, start.x + 0, start.y + 4);
            g.drawLine(start.x + 2, start.y + 4, start.x + 2, start.y + 4);
            g.drawLine(start.x + 4, start.y + 4, start.x + 4, start.y + 4);
            g.drawLine(start.x + 6, start.y + 4, start.x + 6, start.y + 4);
            g.drawLine(start.x + 8, start.y + 4, start.x + 8, start.y + 4);
            g.drawLine(start.x - 2, start.y + 6, start.x - 2, start.y + 6);
            g.drawLine(start.x + 0, start.y + 6, start.x + 0, start.y + 6);
            g.drawLine(start.x + 2, start.y + 6, start.x + 2, start.y + 6);
            g.drawLine(start.x + 4, start.y + 6, start.x + 4, start.y + 6);
            g.drawLine(start.x + 6, start.y + 6, start.x + 6, start.y + 6);
            g.drawLine(start.x + 8, start.y + 6, start.x + 8, start.y + 6);
            g.drawLine(start.x - 2, start.y + 8, start.x - 2, start.y + 8);
            g.drawLine(start.x + 0, start.y + 8, start.x + 0, start.y + 8);
            g.drawLine(start.x + 2, start.y + 8, start.x + 2, start.y + 8);
            g.drawLine(start.x + 4, start.y + 8, start.x + 4, start.y + 8);
            g.drawLine(start.x + 6, start.y + 8, start.x + 6, start.y + 8);
            g.drawLine(start.x + 8, start.y + 8, start.x + 8, start.y + 8);
            g.drawLine(start.x - 2, start.y + 10, start.x - 2, start.y + 10);
            g.drawLine(start.x + 0, start.y + 10, start.x + 0, start.y + 10);
            g.drawLine(start.x + 2, start.y + 10, start.x + 2, start.y + 10);
            g.drawLine(start.x + 4, start.y + 10, start.x + 4, start.y + 10);
            g.drawLine(start.x + 6, start.y + 10, start.x + 6, start.y + 10);
        }
        if (this.buttonType == 6) {
            prefSize = this.getPreferredSize();
            center = new Point(prefSize.width / 2, prefSize.height / 2);
            start = new Point(center.x - 5, center.y - 5);
            g.setColor(Color.gray);
            g.drawRect(start.x - 1, start.y - 1, 10, 11);
            if (this.isEnabled()) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.gray);
            }
            g.fillRect(start.x + 0, start.y + 0, 3, 10);
            if (this.isEnabled()) {
                g.setColor(Color.green);
            } else {
                g.setColor(Color.gray);
            }
            g.fillRect(start.x + 3, start.y + 0, 3, 10);
            if (this.isEnabled()) {
                g.setColor(Color.blue);
            } else {
                g.setColor(Color.gray);
            }
            g.fillRect(start.x + 6, start.y + 0, 3, 10);
        }
    }

    @Override
    public void setAppxText(String str) {
        this.setText(str);
    }

    @Override
    public void setCellBounds(int x, int y, int width, int height) {
    }

    public void setField(AppxControl obj) {
        this.field = obj;
    }

    @Override
    public void setOffset(Rectangle r) {
        this.offset = r;
    }

    @Override
    public void setTouched(boolean newTouched) {
    }

    @Override
    public void paintImmediately(int x, int y, int w, int h) {
        if (!this.parent.isScreenLocked()) {
            super.paintImmediately(x, y, w, h);
        }
    }

    @Override
    public boolean isMovable() {
        return this.movable;
    }

    @Override
    public void setMovable(boolean b) {
        this.movable = b;
    }

    @Override
    public void setOffsetLocation(int x, int y) {
        this.offset.x = x;
        this.offset.y = y;
    }

    @Override
    public void setUI(ButtonUI newUI) {
        if (Globals.getOptionValueBoolean("newScanButton")) {
            super.setUI(AppxBasicButtonUI.getInstance());
        } else {
            super.setUI(newUI);
        }
    }
}

