/*
 * Decompiled with CFR 0.152.
 */
package view;

import doc.AppxToolkit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import view.AppxAntiAliasControl;
import view.AppxAntiAliasHelper;
import view.AppxBorder;
import view.AppxControl;
import view.AppxControlCache;
import view.AppxControlUtils;
import view.CharView;
import view.Display;

public final class AppxBox
extends JComponent
implements AppxControl,
AppxControlCache,
AppxAntiAliasControl {
    private static final long serialVersionUID = -5353127655478939860L;
    private Rectangle bounds;
    private Display parent;
    private Rectangle offset = new Rectangle(0, 0, 0, 0);
    private AppxAntiAliasHelper antiAlias = new AppxAntiAliasHelper();
    private boolean movable = false;

    @Override
    public boolean isAntiAlias() {
        return this.antiAlias.isAntiAlias();
    }

    public void setScroller(boolean b) {
        this.parent.setScroller(this.bounds);
    }

    @Override
    public void setAntiAlias(boolean b) {
        this.antiAlias.setAntiAlias(b);
    }

    @Override
    public void addScanButton(boolean add) {
    }

    @Override
    public boolean containsCell(int x, int y) {
        return this.bounds.contains(new Point(x, y));
    }

    @Override
    public String getAppxText() {
        return this.getText();
    }

    @Override
    public Rectangle getCellBounds() {
        return this.bounds;
    }

    @Override
    public Font getFont() {
        TitledBorder b = (TitledBorder)this.getBorder();
        if (b != null) {
            if (b.getTitleFont() == null) {
                return UIManager.getFont("TitledBorder.font");
            }
            return b.getTitleFont();
        }
        if (this.parent != null) {
            return this.parent.getView().footerFont;
        }
        return null;
    }

    @Override
    public Point getLocation() {
        if (AppxToolkit.isWebLook() || this.parent.scrollerContains(this.bounds.x, this.bounds.y)) {
            return new Point(this.bounds.x * CharView.charWidth - 2 + this.offset.x, this.bounds.y * CharView.charHeight + 3 + this.offset.y);
        }
        return new Point(this.bounds.x * CharView.charWidth + this.offset.x, this.bounds.y * CharView.charHeight + this.offset.y);
    }

    @Override
    public Rectangle getOffset() {
        return this.offset;
    }

    @Override
    public Dimension getPreferredSize() {
        if (AppxToolkit.isWebLook() || this.parent.scrollerContains(this.bounds.x, this.bounds.y)) {
            return new Dimension(this.bounds.width * CharView.charWidth + 4 + this.offset.width, this.bounds.height * CharView.charHeight - 2 + this.offset.height);
        }
        return new Dimension(this.bounds.width * CharView.charWidth + this.offset.width, this.bounds.height * CharView.charHeight + this.offset.height);
    }

    public String getText() {
        TitledBorder brdr = (TitledBorder)this.getBorder();
        if (brdr != null) {
            return null;
        }
        return brdr.getTitle();
    }

    @Override
    public void initControl(Display disp, int x, int y, int width, int height, boolean junk) {
        this.parent = disp;
        this.setOpaque(false);
        this.setCellBounds(x, y, width, height);
        this.setAntiAlias(false);
    }

    @Override
    public boolean isTouched() {
        return false;
    }

    public AppxBox(Display disp, int x, int y, int width, int height) {
        this(disp);
        this.setCellBounds(x, y, width, height);
    }

    public AppxBox(Display disp) {
        this();
        this.parent = disp;
    }

    @Override
    public void setAppxText(String str) {
        this.setText(str);
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this.setOpaque(c != null);
    }

    @Override
    public void paint(Graphics g) {
        this.antiAlias.adjustGraphics((Graphics2D)g);
        super.paint(g);
        this.antiAlias.restoreGraphics((Graphics2D)g);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            int y2;
            int x2;
            int y1;
            int x1;
            Border b = this.getBorder();
            if (b instanceof TitledBorder && ((TitledBorder)b).getTitle() != null && ((TitledBorder)b).getTitle().length() > 0) {
                x1 = b.getBorderInsets((Component)this).left / 2;
                y1 = (int)((double)b.getBorderInsets((Component)this).top / 2.2);
                x2 = this.getPreferredSize().width - b.getBorderInsets((Component)this).right / 2 - x1;
                y2 = this.getPreferredSize().height - b.getBorderInsets((Component)this).bottom / 2 - y1;
                if (((TitledBorder)b).getBorder() instanceof AppxBorder) {
                    --x1;
                    --y1;
                    x2 += 2;
                    y2 += 2;
                }
            } else {
                x1 = 0;
                y1 = 0;
                x2 = this.getPreferredSize().width;
                y2 = this.getPreferredSize().height;
            }
            if (b instanceof TitledBorder && ((TitledBorder)b).getBorder() instanceof AppxBorder) {
                AppxBorder ab = (AppxBorder)((TitledBorder)b).getBorder();
                ab.fillBackground(g, x1, y1, x2, y2, this.getBackground());
            } else {
                g.setColor(this.getBackground());
                g.fillRect(x1, y1, x2, y2);
            }
        }
    }

    @Override
    public void setBorder(Border b) {
        super.setBorder(new TitledBorder(b));
    }

    @Override
    public void setCellBounds(int x, int y, int width, int height) {
        this.bounds = new Rectangle(x, y, width, height);
    }

    public void setCellLocation(int x, int y) {
        if (this.bounds != null) {
            this.bounds.x = x + this.parent.getCellBounds().x;
            this.bounds.y = y + this.parent.getCellBounds().y;
        }
    }

    public void setCellSize(int width, int height) {
        if (this.bounds != null) {
            this.bounds.width = width;
            this.bounds.height = height;
        }
    }

    @Override
    public void setFont(Font f) {
        TitledBorder b = (TitledBorder)this.getBorder();
        if (b != null) {
            b.setTitleFont(f);
        }
    }

    public void setFontSize(int s) {
        Font f = this.getFont();
        this.setFont(new Font(f.getName(), f.getStyle(), (int)((double)s * 0.86)));
    }

    @Override
    public void setForeground(Color c) {
        TitledBorder b = (TitledBorder)this.getBorder();
        if (b != null) {
            b.setTitleColor(c);
        }
    }

    public void setHorizontalAlignment(int align) {
        TitledBorder b = (TitledBorder)this.getBorder();
        if (b != null) {
            int justification = 0;
            switch (align) {
                case 2: {
                    justification = 1;
                    break;
                }
                case 0: {
                    justification = 2;
                    break;
                }
                case 4: {
                    justification = 3;
                }
            }
            b.setTitleJustification(justification);
        }
    }

    @Override
    public void setOffset(Rectangle r) {
        this.offset = r;
    }

    @Override
    public void setOpaque(boolean b) {
        super.setOpaque(b);
    }

    public void setText(String str) {
        TitledBorder brdr = (TitledBorder)this.getBorder();
        if (brdr == null) {
            this.setBorder(BorderFactory.createEtchedBorder());
            brdr = (TitledBorder)this.getBorder();
        }
        brdr.setTitle(str);
    }

    @Override
    public void setTouched(boolean newTouched) {
    }

    public void setVerticalAlignment(int align) {
        TitledBorder b = (TitledBorder)this.getBorder();
        if (b != null) {
            int position = 0;
            switch (align) {
                case 1: {
                    position = 2;
                    break;
                }
                case 3: {
                    position = 5;
                }
            }
            b.setTitlePosition(position);
        }
    }

    public void setVerticalTextPosition(int align) {
        TitledBorder b = (TitledBorder)this.getBorder();
        if (b != null) {
            int position = b.getTitlePosition();
            switch (align) {
                case 1: {
                    if (position == 5) {
                        position = 4;
                        break;
                    }
                    position = 1;
                    break;
                }
                case 3: {
                    position = position == 5 ? 6 : 3;
                }
            }
            b.setTitlePosition(position);
        }
    }

    @Override
    public void updateOptions(AppxControlCache options) {
        AppxBox op = (AppxBox)options;
        this.setToolTipText(op.getToolTipText());
        this.setBackground(op.getBackground());
        this.setForeground(op.getForeground());
        this.setFont(op.getFont());
        this.setBorder(op.getBorder());
        this.setOffset(op.getOffset());
        this.setOpaque(op.isOpaque());
        this.setMovable(op.isMovable());
    }

    public AppxBox() {
        this.setBackground(null);
        this.setOpaque(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CharView.view.mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                CharView.view.mouseReleased(e);
            }
        });
        this.addMouseMotionListener(CharView.view);
    }

    @Override
    public void setMargin(Insets insets) {
        AppxControlUtils.setMargin(this, insets);
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void paintImmediately(int x, int y, int w, int h) {
        if (!this.parent.isScreenLocked()) {
            super.paintImmediately(x, y, w, h);
        }
    }

    @Override
    public boolean isMovable() {
        return this.movable;
    }

    @Override
    public void setMovable(boolean b) {
        this.movable = b;
    }

    @Override
    public void setOffsetLocation(int x, int y) {
        this.offset.x = x;
        this.offset.y = y;
    }

    public void setDisabledForeground(Color c) {
    }

    public void setFileChooserMode(int a) {
    }
}

