/*
 * Decompiled with CFR 0.152.
 */
package view;

import doc.CompileDate;
import doc.Globals;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.table.TableModel;

public final class AboutDialog
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -7643630549222904280L;
    public static final String clientVersion = "5.4.2";
    public static final String clientVersionNum = "050402.28";
    private String serverPid = "Unknown";
    private JTable jt;
    private Runtime rt;
    private NumberFormat nf;
    private TableModel tm;
    private int memoryInfoStartSlot;
    private String totalMem;
    private String usedMem;
    private String freeMem;

    public AboutDialog(String title) {
        super(title);
        this.setVisible(false);
    }

    public void setServerPid(String newValue) {
        Globals.setOptionValue("lastPid", newValue);
        this.serverPid = newValue;
    }

    public void showIt() {
        Object[][] data = new String[9][2];
        Object[] names = new String[]{"Label", "Value"};
        int slot = 0;
        data[slot][0] = new String("Client Version");
        data[slot][1] = clientVersion;
        data[++slot][0] = new String("Client Build");
        data[slot][1] = clientVersionNum;
        data[++slot][0] = new String("Client Compiled");
        data[slot][1] = CompileDate.getCompileDate();
        data[++slot][0] = new String("Server Process");
        data[slot][1] = this.serverPid;
        data[++slot][0] = new String("Client Path");
        data[slot][1] = System.getProperty("user.dir");
        data[++slot][0] = new String("Cache Path");
        data[slot][1] = Globals.getOptionValueString("cachePath");
        data[++slot][0] = new String("Memory - Allocated");
        data[slot][1] = NumberFormat.getInstance().format(Runtime.getRuntime().totalMemory());
        this.memoryInfoStartSlot = slot++;
        data[slot][0] = new String("Memory - In Use");
        data[slot][1] = NumberFormat.getInstance().format(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
        data[++slot][0] = new String("Memory - Free");
        data[slot][1] = NumberFormat.getInstance().format(Runtime.getRuntime().freeMemory());
        this.getContentPane().setLayout(new BorderLayout());
        this.jt = new JTable(data, names);
        this.jt.setRowSelectionAllowed(false);
        this.jt.setColumnSelectionAllowed(false);
        this.jt.setCellSelectionEnabled(false);
        this.jt.clearSelection();
        JScrollPane js = new JScrollPane(this.jt);
        this.getContentPane().add("Center", js);
        JButton snap = new JButton("Check Memory Now");
        snap.addActionListener(this);
        this.getContentPane().add("South", snap);
        this.setSize(300, 200);
        this.setVisible(true);
        System.err.println("Memory Allocation: Allocated=" + (String)data[this.memoryInfoStartSlot][1] + ", used=" + (String)data[this.memoryInfoStartSlot + 1][1] + ", free=" + (String)data[this.memoryInfoStartSlot + 2][1]);
        this.rt = Runtime.getRuntime();
        this.nf = NumberFormat.getInstance();
        this.tm = this.jt.getModel();
        Timer interactT = new Timer(Globals.getOptionValueInteger("memoryCheckTimer") * 1000, this);
        interactT.start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.rt.gc();
        this.totalMem = this.nf.format(this.rt.totalMemory());
        this.usedMem = this.nf.format(this.rt.totalMemory() - this.rt.freeMemory());
        this.freeMem = this.nf.format(this.rt.freeMemory());
        this.tm.setValueAt(this.totalMem, this.memoryInfoStartSlot, 1);
        this.tm.setValueAt(this.usedMem, this.memoryInfoStartSlot + 1, 1);
        this.tm.setValueAt(this.freeMem, this.memoryInfoStartSlot + 2, 1);
        this.repaint();
        System.err.println("Memory Allocation: allocated=" + this.totalMem + ", used=" + this.usedMem + ", free=" + this.freeMem);
    }

    public AboutDialog() {
        this("About APPX");
    }
}

