/*
 * Decompiled with CFR 0.152.
 */
package start;

import doc.Globals;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;

class SplashWindowShow
extends Window {
    private static final long serialVersionUID = -2143621730402851111L;
    Image splashIm;
    Image offscreen = null;
    String statusText = null;
    Color borderColor = new Color(16, 109, 132);
    Font splashFont = new Font("Helvetica", 1, 10);

    SplashWindowShow(Frame parent, Image splashIm) {
        super(parent);
        this.splashIm = splashIm;
        this.setSize(splashIm.getWidth(null), splashIm.getHeight(null));
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle winDim = this.getBounds();
        Rectangle monDim = Globals.getGraphicsConfiguration().getBounds();
        this.setLocation((screenDim.width - winDim.width) / 2 + monDim.x, (screenDim.height - winDim.height) / 2 + monDim.y);
        this.setVisible(true);
    }

    public void setStatusText(String s) {
        this.statusText = s;
        this.invalidate();
        this.repaint();
    }

    @Override
    public void update(Graphics g) {
        if (this.offscreen == null) {
            this.offscreen = this.createImage(this.getSize().width, this.getSize().height);
        }
        Graphics offgc = this.offscreen.getGraphics();
        this.paint(offgc);
        g.drawImage(this.offscreen, 0, 0, this);
    }

    @Override
    public void paint(Graphics g) {
        if (this.splashIm != null) {
            g.drawImage(this.splashIm, 0, 0, this);
            g.setColor(this.borderColor);
            g.setFont(this.splashFont);
            g.drawString("Version: 5.4.2", 10, 105);
            if (this.statusText != null) {
                g.setColor(this.borderColor);
                g.setFont(this.splashFont);
                g.drawString(this.statusText, 10, 155);
            }
        }
    }
}

