/*
 * Decompiled with CFR 0.152.
 */
package start;

import chrriis.dj.nativeswing.swtimpl.NativeInterface;
import de.wim.outldd.OutlookDD;
import debug.AppxDebug;
import doc.Globals;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;
import java.util.concurrent.Executor;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JApplet;
import start.SplashWindowFrame;
import view.AltGrPatch;
import view.AppxMain;

public final class Appx
extends JApplet
implements Runnable {
    private static final long serialVersionUID = -542166036775314114L;
    public static final String what_str = "@(#)Appx $Header: /src/cvs/appx/Joe/start/Appx.java,v 1.1.2.6 2001/11/26 15:33:09 pete Exp $";
    public static boolean connected = false;
    private static AppxMain mainAppx;
    public static boolean modeSet;
    private static final Hashtable<String, String> paramTable;

    static {
        modeSet = false;
        paramTable = new Hashtable();
    }

    private static final void addToTable(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        if (key.toLowerCase().equalsIgnoreCase("mode") || key.toLowerCase().equalsIgnoreCase("connectMode")) {
            modeSet = true;
        }
        paramTable.put(key, value);
    }

    private static final String getFromTable(String key) {
        if (key == null) {
            return null;
        }
        return paramTable.get(key);
    }

    private static final void applyOptions() {
        int optionCount = Globals.getCompleteOptionCount();
        int i = 0;
        while (i < optionCount) {
            String keyword = Globals.getOptionTag(i);
            String datavalue = Appx.getFromTable(keyword);
            if (datavalue != null) {
                Globals.setOptionValue(keyword, datavalue);
            } else {
                String oldkeyword = Globals.getOptionOldTag(i);
                datavalue = Appx.getFromTable(oldkeyword);
                if (datavalue != null) {
                    Globals.setOptionValue(keyword, datavalue);
                }
            }
            ++i;
        }
    }

    public static String getArchFilename(String prefix) {
        return String.valueOf(prefix) + "_" + Appx.getOSName() + "_" + Appx.getArchName() + ".jar";
    }

    private static String getOSName() {
        String osNameProperty = System.getProperty("os.name");
        if (osNameProperty == null) {
            throw new RuntimeException("os.name property now set");
        }
        if ((osNameProperty = osNameProperty.toLowerCase()).contains("win")) {
            return "win";
        }
        if (osNameProperty.contains("mac")) {
            return "osx";
        }
        if (osNameProperty.contains("linux") || osNameProperty.contains("nix")) {
            return "linux";
        }
        throw new RuntimeException("Unknown OS name: " + osNameProperty);
    }

    private static String getArchName() {
        String osArch = System.getProperty("os.arch");
        if (osArch != null && osArch.contains("64")) {
            return "64";
        }
        return "32";
    }

    public static void addJarToClasspath(File jarFile) {
        System.err.println("addJatToClasspath() [" + jarFile.getAbsolutePath() + "]");
        try {
            URL url = jarFile.toURI().toURL();
            URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            Class<URLClassLoader> urlClass = URLClassLoader.class;
            Method method = urlClass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)urlClassLoader, url);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void enableFocusLogging() {
        Logger focusLog = Logger.getLogger("java.awt.focus.Component");
        focusLog.setLevel(Level.ALL);
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.ALL);
        focusLog.addHandler(handler);
    }

    public static void main(String[] args) {
        SplashWindowFrame splash;
        block47: {
            String arg;
            int n;
            String[] stringArray;
            System.setProperty("sun.awt.disableMixing", "true");
            Appx.addJarToClasspath(new File("lib/capsapi_classes.jar"));
            Appx.addJarToClasspath(new File("lib/DJNativeSwing.jar"));
            Appx.addJarToClasspath(new File("lib/DJNativeSwing-SWT.jar"));
            Appx.addJarToClasspath(new File("lib/js.jar"));
            Appx.addJarToClasspath(new File("lib/jsoup.jar"));
            Appx.addJarToClasspath(new File("lib/outldd.jar"));
            Appx.addJarToClasspath(new File("lib/SyntaxHighlighter.jar"));
            Appx.addJarToClasspath(new File("lib/ckeditor_" + Appx.getOSName() + ".jar"));
            Appx.addJarToClasspath(new File("lib/swt_" + Appx.getOSName() + "_" + Appx.getArchName() + ".jar"));
            try {
                boolean isAppleOSX = System.getProperty("os.name").equals("Mac OS X");
                if (isAppleOSX) {
                    Class<?> comAppleConcurrentDispatch = Class.forName("com.apple.concurrent.Dispatch");
                    Method getInstance = comAppleConcurrentDispatch.getMethod("getInstance", null);
                    Object dispatchInstance = getInstance.invoke(null, null);
                    Method getNonBlockingMainQueueExecutor = dispatchInstance.getClass().getMethod("getNonBlockingMainQueueExecutor", null);
                    Executor executor = (Executor)getNonBlockingMainQueueExecutor.invoke(dispatchInstance, null);
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                NativeInterface.open();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    });
                } else {
                    NativeInterface.open();
                }
            }
            catch (Exception exc) {
                System.out.println("Exception=" + exc);
            }
            System.setSecurityManager(null);
            Globals.setArgs(args);
            if (System.getProperty("exe4j.launchName") == null) {
                if (Globals.isWindowsOS()) {
                    Globals.setLaunchName("\"" + System.getProperty("java.home") + "/bin/javaw\"" + " -cp \"" + System.getProperty("java.class.path") + "\" start.Appx");
                } else {
                    Globals.setLaunchName(System.getProperty("java.home") + "/bin/java" + " -cp " + System.getProperty("java.class.path") + " start.Appx");
                }
            } else {
                Globals.setLaunchName("\"" + System.getProperty("exe4j.launchName") + "\"");
            }
            boolean showSplash = true;
            boolean showDebug = false;
            splash = null;
            String tmpIniFile = null;
            if (args != null && args.length > 0 && args[0] != null) {
                stringArray = args;
                n = args.length;
                int executor = 0;
                while (executor < n) {
                    arg = stringArray[executor];
                    if (arg.equalsIgnoreCase("-showSplash=false")) {
                        showSplash = false;
                    }
                    if (arg.equalsIgnoreCase("-debug=true") || arg.equalsIgnoreCase("-debug")) {
                        showDebug = true;
                    }
                    if (arg.toLowerCase().startsWith("-inifile=")) {
                        tmpIniFile = arg.indexOf(47) >= 0 || arg.indexOf(92) >= 0 ? arg.substring(9) : String.valueOf(System.getProperty("user.home")) + File.separator + ".appx" + File.separator + arg.substring(9);
                    }
                    ++executor;
                }
            }
            if (showDebug) {
                AppxDebug.setLoggingEnabled(true);
            } else {
                AppxDebug.setLoggingEnabled(false);
            }
            new AltGrPatch();
            Globals.setIniFile(tmpIniFile, null);
            AppxDebug.startSystemLog();
            if (args != null && args.length > 0 && args[0] != null) {
                stringArray = args;
                n = args.length;
                int executor = 0;
                while (executor < n) {
                    arg = stringArray[executor];
                    AppxDebug.log("command line argument [" + arg + "]");
                    ++executor;
                }
            }
            int i = 0;
            while (i < args.length) {
                String argdata;
                int hyphen = args[i].indexOf(45);
                int equalsign = args[i].indexOf(61);
                int dquote = args[i].indexOf(34);
                int squote = args[i].indexOf(39);
                if (hyphen != 0 && equalsign > 0 && dquote > 0 && args[i].charAt(args[i].length() - 1) != '\"') {
                    argdata = "-" + args[i].substring(0, dquote) + args[i].substring(dquote + 1);
                    hyphen = argdata.indexOf(45);
                    equalsign = argdata.indexOf(61);
                    dquote = argdata.indexOf(34);
                    squote = args[i].indexOf(39);
                } else if (hyphen != 0 && equalsign > 0 && squote > 0 && args[i].charAt(args[i].length() - 1) != '\'') {
                    argdata = "-" + args[i].substring(0, squote) + args[i].substring(squote + 1);
                    hyphen = argdata.indexOf(45);
                    equalsign = argdata.indexOf(61);
                    dquote = argdata.indexOf(34);
                    squote = args[i].indexOf(39);
                } else {
                    argdata = args[i];
                }
                if (hyphen == 0) {
                    String datavalue;
                    String keyword;
                    if (equalsign > 0) {
                        keyword = argdata.substring(1, equalsign);
                        datavalue = argdata.substring(equalsign + 1);
                        Appx.addToTable(keyword, datavalue);
                    } else {
                        keyword = argdata.substring(1);
                        datavalue = "true";
                        Appx.addToTable(keyword, datavalue);
                    }
                }
                ++i;
            }
            Appx.applyOptions();
            if (!showSplash) {
                try {
                    Class<?> splashscreen = Class.forName("com.install4j.api.launcher.SplashScreen");
                    if (splashscreen == null) {
                        splashscreen = Class.forName("com.install4j.api.launcher.Controller");
                    }
                    if (splashscreen != null) {
                        Method m = splashscreen.getMethod("writeMessage", String.class);
                        m.invoke(splashscreen, "Version: 5.4.2");
                        break block47;
                    }
                    System.err.println("Install4J writeMessage() no splashscreen");
                }
                catch (Exception e) {
                    System.err.println("Install4J writeMessage() exception=" + e);
                }
            } else {
                splash = new SplashWindowFrame("splash.png");
                splash.setStatusText("Starting...");
            }
        }
        if (!Globals.getOptionValueBoolean("allowXpTheme")) {
            System.setProperty("swing.noxp", "true");
        }
        if (splash != null) {
            splash.setStatusText("Starting client...");
        }
        try {
            try {
                mainAppx = new AppxMain();
                AppxMain.params = new Hashtable();
                mainAppx.getStartedFirst(null);
                if (splash != null) {
                    splash.removeSplash();
                }
                splash = null;
                mainAppx.start();
            }
            catch (Exception ex) {
                System.err.println("Appx.main() exception=" + ex);
                ex.printStackTrace();
                try {
                    NativeInterface.runEventPump();
                }
                catch (Exception ex2) {
                    System.err.println("SWT Exception=" + ex2);
                }
                if (Globals.isWindowsOS()) {
                    OutlookDD.done();
                }
            }
        }
        finally {
            try {
                NativeInterface.runEventPump();
            }
            catch (Exception ex) {
                System.err.println("SWT Exception=" + ex);
            }
            if (Globals.isWindowsOS()) {
                OutlookDD.done();
            }
        }
    }

    @Override
    public void init() {
        if (connected) {
            return;
        }
        Thread initThread = new Thread(){

            @Override
            public void run() {
                Appx.this.init2();
            }
        };
        initThread.start();
        try {
            initThread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void init2() {
        new AltGrPatch();
        Globals.setIniFile(null, null);
        int optionCount = Globals.getOptionCount();
        int i = 0;
        while (i < optionCount) {
            String keyword = Globals.getOptionTag(i);
            String datavalue = this.getParameter(keyword);
            if (datavalue != null) {
                Appx.addToTable(keyword, datavalue);
            } else {
                String oldkeyword = Globals.getOptionOldTag(i);
                if (oldkeyword != null) {
                    datavalue = this.getParameter(oldkeyword);
                }
                if (datavalue != null) {
                    Appx.addToTable(keyword, datavalue);
                }
            }
            ++i;
        }
        if (Appx.getFromTable("iniFile") != null || Appx.getFromTable("profileName") != null) {
            Globals.setIniFile(Appx.getFromTable("iniFile"), Appx.getFromTable("profileName"));
        }
        Appx.applyOptions();
        mainAppx = new AppxMain();
        AppxMain.params = new Hashtable();
        mainAppx.getStartedFirst(this);
    }

    @Override
    public void run() {
        this.start2();
    }

    public void start2() {
        mainAppx.start();
    }

    @Override
    public void start() {
        if (connected) {
            return;
        }
        connected = true;
        Thread runner = new Thread(this);
        runner.start();
    }
}

