/*
 * Decompiled with CFR 0.152.
 */
package doc.jscript;

import doc.jscript.AppxJScript;
import doc.jscript.JScriptObject;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;

public class JScriptUtil
extends JScriptObject {
    private static final long serialVersionUID = 488397682712588982L;

    @JScriptObject.Script
    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    @JScriptObject.Script
    public static BufferedImage captureRect(int x, int y, int width, int height) {
        BufferedImage screenshot = null;
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] gs = ge.getScreenDevices();
            Robot robot = gs.length > 1 ? new Robot(gs[1]) : new Robot();
            screenshot = robot.createScreenCapture(new Rectangle(x, y, width, height));
        }
        catch (Exception ex) {
            AppxJScript.showError(ex);
        }
        return screenshot;
    }

    @JScriptObject.Script
    public static BufferedImage captureScreen() {
        Dimension d = JScriptUtil.getScreenSize();
        return JScriptUtil.captureRect(0, 0, d.width, d.height);
    }

    @JScriptObject.Script
    public static Dimension getScreenSize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    @JScriptObject.Script
    public static Image toImage(Object bufferedImage) {
        return Toolkit.getDefaultToolkit().createImage(((BufferedImage)bufferedImage).getSource());
    }
}

