/*
 * Decompiled with CFR 0.152.
 */
package doc.jscript;

import doc.jscript.AppxJScript;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public abstract class JScriptObject
extends ScriptableObject {
    private static final long serialVersionUID = -7231750856798112870L;

    public JScriptObject() {
        this.defineScriptProperties();
    }

    private void defineScriptProperties() {
        Method[] methods;
        Field[] fields;
        Field[] fieldArray = fields = ((Object)((Object)this)).getClass().getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            int mod;
            Field fld = fieldArray[n2];
            if (fld.isAnnotationPresent(Script.class) && Modifier.isPublic(mod = fld.getModifiers())) {
                try {
                    Object val = fld.get((Object)this);
                    if (Modifier.isFinal(mod)) {
                        ScriptableObject.putConstProperty((Scriptable)this, (String)fld.getName(), (Object)val);
                    } else {
                        this.defineProperty(fld.getName(), ((Object)((Object)this)).getClass(), 0);
                    }
                }
                catch (Exception ex) {
                    AppxJScript.showError(ex);
                }
            }
            ++n2;
        }
        Vector<String> v = new Vector<String>();
        Method[] methodArray = methods = ((Object)((Object)this)).getClass().getDeclaredMethods();
        int n3 = methods.length;
        int n4 = 0;
        while (n4 < n3) {
            int mod;
            Method met = methodArray[n4];
            if (met.isAnnotationPresent(Script.class) && Modifier.isPublic(mod = met.getModifiers())) {
                v.add(met.getName());
            }
            ++n4;
        }
        Object[] scriptFunctions = new String[v.size()];
        v.copyInto(scriptFunctions);
        super.defineFunctionProperties((String[])scriptFunctions, ((Object)((Object)this)).getClass(), 0);
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public String getScriptName() {
        return ((Object)((Object)this)).getClass().getSimpleName().replaceFirst("JScript", "").toUpperCase();
    }

    public void scriptCleanup() {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Script {
    }
}

