/*
 * Decompiled with CFR 0.152.
 */
package doc.jscript;

import doc.AppxToolkit;
import doc.Document;
import doc.Globals;
import doc.jscript.AppxJScript;
import doc.jscript.JScriptObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import view.AppxControl;
import view.CharView;

public class JScriptAppx
extends JScriptObject {
    private Map<Component, Component> replacedWidgets = Collections.synchronizedMap(new HashMap());
    @JScriptObject.Script
    public static final String CLIENT_USERHOME = Globals.getClientUserHome();
    @JScriptObject.Script
    public static final String CLIENT_VERSION = "5.4.2";
    @JScriptObject.Script
    public static final String INI_FILE = Globals.getIniFile();
    private static final long serialVersionUID = 2858527170230983488L;

    public JScriptAppx() {
        this.defineScriptProperties();
    }

    private void defineScriptProperties() {
        try {
            Field[] fields;
            Field[] fieldArray = fields = CharView.document.getClass().getFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field fld = fieldArray[n2];
                if (fld.getName().startsWith("OPT_") && fld.getType().equals(Integer.TYPE)) {
                    ScriptableObject.putConstProperty((Scriptable)this, (String)fld.getName(), (Object)fld.getInt(fld));
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            AppxJScript.showError(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scriptCleanup() {
        Map<Component, Component> map = this.replacedWidgets;
        synchronized (map) {
            Iterator<Component> widgets = this.replacedWidgets.keySet().iterator();
            while (widgets.hasNext()) {
                this.restoreWidget(widgets.next());
            }
        }
    }

    @JScriptObject.Script
    public static String getAppId() {
        return CharView.document.applId.split(" ")[0];
    }

    @JScriptObject.Script
    public static String getAppVer() {
        return CharView.document.applId.split(" ")[1];
    }

    @JScriptObject.Script
    public static String getAppxPath() {
        String ap = Globals.getOptionValueString("lastPath");
        ap = String.valueOf(ap.substring(0, ap.lastIndexOf(File.separatorChar) + 1)) + "data";
        return ap;
    }

    @JScriptObject.Script
    public static int getCols() {
        return CharView.topBox.getColumns();
    }

    @JScriptObject.Script
    public static String getDatabase() {
        return CharView.document.dataBase;
    }

    @JScriptObject.Script
    public static String getMode() {
        return CharView.document.currMode;
    }

    @JScriptObject.Script
    public static String getPreference(String pref) {
        return Globals.getOptionValueString(pref);
    }

    @JScriptObject.Script
    public static String getProcId() {
        return CharView.document.getProcId();
    }

    @JScriptObject.Script
    public static int getRows() {
        return CharView.topBox.getRows();
    }

    @JScriptObject.Script
    public static String getScreenText(int row, int col, int len) {
        return CharView.document.lookupScreenText(row, col, len);
    }

    @JScriptObject.Script
    public static Dimension getSize() {
        return CharView.view.getSize();
    }

    @JScriptObject.Script
    public static String getStatus() {
        return CharView.view.getStatusText();
    }

    @JScriptObject.Script
    public static String getUser() {
        return CharView.document.userId;
    }

    @JScriptObject.Script
    public AppxControl getWidget(int row, int col) {
        AppxControl widget = null;
        if (!JScriptAppx.isDesigning()) {
            Component[] componentArray = CharView.topBox.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                AppxControl ac;
                Rectangle r;
                Component c = componentArray[n2];
                if (c instanceof AppxControl && c instanceof JComponent && (r = (ac = (AppxControl)((Object)((JComponent)c))).getCellBounds()) != null && r.x == col - 1 && r.y == row - 1) {
                    widget = ac;
                    break;
                }
                ++n2;
            }
        }
        return widget;
    }

    @JScriptObject.Script
    public static String getWindowTitle() {
        return CharView.view.getTitle();
    }

    @JScriptObject.Script
    public static boolean isAccessingServer() {
        return CharView.view.accessingServer;
    }

    @JScriptObject.Script
    public static boolean isDesigning() {
        return CharView.focusBox.isIlfEditor() || CharView.topBox.isImageEditor();
    }

    @JScriptObject.Script
    public static boolean isReady() {
        return !CharView.view.accessingServer && !Document.isLocked();
    }

    @JScriptObject.Script
    public static Image loadImage(String url) {
        return CharView.view.loadImage(url);
    }

    @JScriptObject.Script
    public static void loadUrl(String url) {
        CharView.view.loadUrl(url);
    }

    @JScriptObject.Script
    public static void logClear() {
        if (CharView.logText != null) {
            CharView.logText.setText("");
            CharView.logFrame.setVisible(false);
        }
    }

    @JScriptObject.Script
    public static void logPrint(String txt) {
        CharView.logPrint(String.valueOf(txt) + "\n");
        if (!CharView.logFrame.isVisible()) {
            CharView.logFrame.setSize(640, 480);
            CharView.viewLog();
        }
    }

    @JScriptObject.Script
    public void replaceWidget(Object arg0, Object arg1) {
        try {
            Component jcOld = (Component)Context.jsToJava((Object)arg0, Component.class);
            Component jcNew = (Component)Context.jsToJava((Object)arg1, Component.class);
            this.restoreWidget(jcOld);
            jcNew.setFocusable(false);
            jcNew.setLocation(jcOld.getLocation());
            jcNew.setPreferredSize(jcOld.getPreferredSize());
            jcOld.setVisible(false);
            jcOld.getParent().add(jcNew);
            this.replacedWidgets.put(jcOld, jcNew);
        }
        catch (Exception ex) {
            AppxJScript.showError(ex);
        }
    }

    @JScriptObject.Script
    public void restoreWidget(Object arg0) {
        try {
            Component jcOld = (Component)Context.jsToJava((Object)arg0, Component.class);
            if (this.replacedWidgets.containsKey(jcOld)) {
                Component jcNew = this.replacedWidgets.get(jcOld);
                jcNew.getParent().remove(jcNew);
                jcOld.setVisible(true);
                this.replacedWidgets.remove(jcOld);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @JScriptObject.Script
    public boolean runOption(String opt) {
        if (!(CharView.view.accessingServer || CharView.topBox.isScreenLocked() || Document.isLocked())) {
            CharView.view.bufferAppxEvent(new ActionEvent((Object)this, 1337, opt));
            return true;
        }
        return false;
    }

    @JScriptObject.Script
    public static Image scaleImage(Object img, int x, int y) {
        return CharView.view.scaleImage((Image)img, x, y);
    }

    @JScriptObject.Script
    public static Image scaleImageProp(Object img, int x, int y) {
        return CharView.view.scaleImageProp((Image)img, x, y);
    }

    @JScriptObject.Script
    public static void setBackground(Object clr) {
        CharView.topBox.setOpaque(true);
        CharView.topBox.setWallpaperBackground(JScriptAppx.translateColor(clr));
    }

    @JScriptObject.Script
    public static void setLocation(int x, int y) {
        CharView.view.setLocation(x, y);
    }

    @JScriptObject.Script
    public static boolean setLook(String look) {
        return AppxToolkit.setLook(look, CharView.view);
    }

    @JScriptObject.Script
    public static void setPreference(String pref, String val) {
        Globals.setOptionValue(pref, val);
    }

    @JScriptObject.Script
    public static void setStatus(String txt) {
        CharView.view.setStatusText(txt);
    }

    @JScriptObject.Script
    public static void setTitle(String txt) {
        CharView.topBox.setText(txt);
    }

    @JScriptObject.Script
    public static void setTitleAlignment(int hor, int ver) {
        CharView.topBox.setHorizontalAlignment(hor);
        CharView.topBox.setVerticalAlignment(ver);
    }

    @JScriptObject.Script
    public static void setTitleBackground(Object clr) {
        CharView.topBox.setBackground(JScriptAppx.translateColor(clr));
    }

    @JScriptObject.Script
    public static void setTitleClosable(boolean closable) {
        CharView.topBox.setCloseable(closable);
    }

    @JScriptObject.Script
    public static void setTitleForeground(Object clr) {
        CharView.topBox.setForeground(JScriptAppx.translateColor(clr));
    }

    @JScriptObject.Script
    public static void setTitleHelpable(boolean helpable) {
        CharView.topBox.setHelpable(helpable);
    }

    @JScriptObject.Script
    public static void setTitleOKable(boolean okable) {
        CharView.topBox.setOKable(okable);
    }

    @JScriptObject.Script
    public static void setTitleVisible(boolean visible) {
        CharView.topBox.setTitleVisible(visible);
    }

    @JScriptObject.Script
    public static void setVisible(boolean visible) {
        CharView.view.setVisible(visible);
    }

    @JScriptObject.Script
    public static void setWindowTitle(String title) {
        CharView.view.setTitle(title);
    }

    @JScriptObject.Script
    public static Color translateColor(Object clr) {
        if (clr instanceof String) {
            clr = CharView.xlateColor((String)clr);
        }
        return (Color)clr;
    }
}

