/*
 * Decompiled with CFR 0.152.
 */
package doc.jscript;

import doc.AppxExtension;
import doc.Document;
import doc.jscript.JScriptAppx;
import doc.jscript.JScriptJava;
import doc.jscript.JScriptObject;
import doc.jscript.JScriptUtil;
import java.awt.Container;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.shell.Global;
import view.CharView;

public final class AppxJScript
extends ContainerAdapter
implements AppxExtension {
    private Map<String, Scriptable> calledFunctions = Collections.synchronizedMap(new HashMap());
    private final Container onLoadHook;
    private List<JScriptObject> jscriptObjects;
    private Scriptable scope;
    private String script;
    private static final int MAX_RET = Short.MAX_VALUE;
    private static final String FUNCTION_ONLOAD = "onLoad";
    private static final String FUNCTION_ONUNLOAD = "onUnload";
    private static final String LS = System.getProperty("line.separator");
    private static final String SCOPE_DIR = "_DIR_";
    private static final String SCOPE_EXT = "_EXT_";
    private static final String SCOPE_FILE = "_FILE_";
    private static final String SCRIPT_EXT = ".js";
    private Document document;
    private int handle;

    public AppxJScript(String script) {
        this.onLoadHook = CharView.view.toolBar;
        this.jscriptObjects = Collections.synchronizedList(new ArrayList());
        this.scope = null;
        this.script = "";
        this.document = null;
        this.handle = 0;
        Context cx = ContextFactory.getGlobal().enterContext();
        try {
            try {
                this.setScript(script);
                Global global = new Global();
                global.init(cx);
                this.scope = cx.initStandardObjects((ScriptableObject)global);
                this.scope.put(SCOPE_DIR, this.scope, (Object)this.script.substring(0, this.script.lastIndexOf(File.separatorChar)));
                this.scope.put(SCOPE_EXT, this.scope, (Object)SCRIPT_EXT);
                this.scope.put(SCOPE_FILE, this.scope, (Object)new File(this.script).getName());
                this.addJScriptObject(new JScriptAppx());
                this.addJScriptObject(new JScriptJava());
                this.addJScriptObject(new JScriptUtil());
                cx.evaluateReader(this.scope, (Reader)new FileReader(this.script), this.script, 1, null);
                this.calledFunctions.put("global", this.scope);
                this.onLoadHook.addContainerListener(this);
            }
            catch (Exception ex) {
                AppxJScript.showError(ex);
                Context.exit();
            }
        }
        finally {
            Context.exit();
        }
    }

    private void addJScriptObject(JScriptObject po) {
        if (!this.jscriptObjects.contains((Object)po)) {
            this.jscriptObjects.add(po);
            this.scope.put(po.getScriptName(), this.scope, (Object)po);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callFunctions(String function) {
        Context cx = ContextFactory.getGlobal().enterContext();
        Map<String, Scriptable> map = this.calledFunctions;
        synchronized (map) {
            Collection<Scriptable> functions = this.calledFunctions.values();
            for (Scriptable f : functions) {
                try {
                    Function fg;
                    if (f == null || !f.has(function, f) || (fg = (Function)f.get(function, f)) == null) continue;
                    fg.call(cx, this.scope, f, null);
                }
                catch (Exception ex) {
                    AppxJScript.showError(ex);
                }
            }
        }
        Context.exit();
    }

    @Override
    public void componentAdded(ContainerEvent ce) {
        if (ce.getContainer().equals(this.onLoadHook)) {
            this.callFunctions(FUNCTION_ONLOAD);
        }
    }

    public String getScript() {
        return this.script;
    }

    public String runFunction(String function, String argNullDelim) {
        String funRet;
        block10: {
            funRet = "";
            Context cx = ContextFactory.getGlobal().enterContext();
            try {
                try {
                    String[] funProt = function.split("\\.");
                    Object[] funArgs = argNullDelim.split("\u0003");
                    Object funObj = this.scope.get(funProt[0], this.scope);
                    if (funObj instanceof Function) {
                        Function funFunc = (Function)funObj;
                        if (!this.calledFunctions.containsKey(funProt[0]) || funProt.length == 1) {
                            this.calledFunctions.put(funProt[0], (Scriptable)funFunc);
                            funRet = Context.toString((Object)funFunc.call(cx, this.scope, (Scriptable)funFunc, funArgs));
                        }
                        if (funProt.length == 2 && (funObj = funFunc.get(funProt[1], (Scriptable)funFunc)) instanceof Function) {
                            funRet = Context.toString((Object)((Function)funObj).call(cx, this.scope, (Scriptable)funFunc, funArgs));
                        }
                    } else if (funObj instanceof NativeObject && NativeObject.hasProperty((Scriptable)((NativeObject)funObj), (String)funProt[1])) {
                        funRet = Context.toString((Object)NativeObject.callMethod((Context)cx, (Scriptable)((NativeObject)funObj), (String)funProt[1], (Object[])funArgs));
                    }
                }
                catch (Exception ex) {
                    AppxJScript.showError(ex);
                    Context.exit();
                    break block10;
                }
            }
            catch (Throwable throwable) {
                Context.exit();
                throw throwable;
            }
            Context.exit();
        }
        return funRet.length() > Short.MAX_VALUE ? funRet.substring(0, Short.MAX_VALUE) : funRet;
    }

    private void setScript(String path) {
        File f;
        if (!(path = path.replace(" ", "_")).contains(File.separator)) {
            this.script = JScriptAppx.getAppxPath();
            this.script = String.valueOf(this.script) + File.separator + JScriptAppx.getAppVer();
            this.script = String.valueOf(this.script) + File.separator + "_Scripts";
            this.script = String.valueOf(this.script) + File.separator + JScriptAppx.getAppId();
            File d = new File(this.script);
            if (!d.exists()) {
                d.mkdirs();
            }
            this.script = String.valueOf(this.script) + File.separator + path;
        } else {
            this.script = path;
        }
        if (!path.toLowerCase().endsWith(SCRIPT_EXT.toLowerCase())) {
            this.script = String.valueOf(this.script) + SCRIPT_EXT;
        }
        if (!(f = new File(this.script)).exists()) {
            try {
                FileWriter fw;
                String template_path = String.valueOf(JScriptAppx.getAppxPath()) + File.separator + "template" + SCRIPT_EXT;
                StringBuilder template_body = new StringBuilder();
                f = new File(template_path);
                if (f.canRead()) {
                    BufferedReader br = new BufferedReader(new FileReader(template_path));
                    String line = "";
                    while ((line = br.readLine()) != null) {
                        template_body.append(line).append("\r\n");
                    }
                    br.close();
                } else {
                    template_body.append("// APPX - Generated Script Template" + LS + LS + "/* [ Examples ]" + LS + LS + "including script files:" + LS + "load(" + SCOPE_DIR + " + \"/../_lib" + SCRIPT_EXT + "\");" + LS + LS + "importing java libraries:" + LS + "importPackage(Packages.java.awt);" + LS + "importClass(Packages.javax.swing);" + LS + LS + "https://developer.mozilla.org/en/Rhino/Shell#Predefined_Properties" + LS + "*/" + LS + LS);
                    if (!f.exists()) {
                        fw = new FileWriter(template_path);
                        fw.write(template_body.toString());
                        fw.close();
                    }
                }
                fw = new FileWriter(this.script);
                fw.write(template_body.toString());
                fw.close();
            }
            catch (Exception ex) {
                AppxJScript.showError(ex);
            }
        }
    }

    public static void showError(Exception ex) {
        ex = ex == null ? new Exception() : ex;
        StackTraceElement[] st = ex.getStackTrace();
        String m = String.valueOf(ex.getMessage()) + "\n\n";
        int i = 0;
        while (i < 5) {
            m = String.valueOf(m) + st[i] + "\n";
            ++i;
        }
        final String msg = m;
        String ttl = "Error";
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, msg, "Error", 0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        this.onLoadHook.removeContainerListener(this);
        this.callFunctions(FUNCTION_ONUNLOAD);
        List<JScriptObject> list = this.jscriptObjects;
        synchronized (list) {
            for (JScriptObject po : this.jscriptObjects) {
                try {
                    po.scriptCleanup();
                    this.scope.delete(po.getScriptName());
                }
                catch (Exception ex) {
                    AppxJScript.showError(ex);
                }
            }
        }
        this.scope = null;
    }

    @Override
    public int getHandle() {
        return this.handle;
    }

    @Override
    public int getSelectedIndex() {
        return 0;
    }

    @Override
    public void setDocument(Document doc) {
        this.document = doc;
    }

    @Override
    public void setHandle(int hnd) {
        this.handle = hnd;
    }
}

