/*
 * Decompiled with CFR 0.152.
 */
package doc;

import comm.IOHandler;
import comm.msg.MToken;
import comm.msg.MTokenItem;
import doc.Globals;
import doc.TokenCache;
import doc.TokenCacheEntryEnumerator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class TokenCacheEntry {
    private String cacheId;
    private String cacheSig;
    private String ap;
    private String ver;
    private String[] elements;
    private int elementCount;
    private int group;
    private String language;
    private String cacheName = null;

    private String getCacheName() {
        if (this.cacheName == null) {
            this.cacheName = this.language != null ? (this.ap + this.ver + this.cacheId + "-" + this.language).toLowerCase() : (this.ap + this.ver + this.cacheId).toLowerCase();
        }
        return this.cacheName;
    }

    public int getElementCount() {
        return this.elementCount;
    }

    public Object[] getElementDataArray() {
        return this.elements;
    }

    public Object getElementData(int pos) {
        return this.elements[pos];
    }

    public int getGroup() {
        return this.group;
    }

    public Enumeration<Object> getTokenElements() {
        return new TokenCacheEntryEnumerator(this);
    }

    public TokenCacheEntry(int group, String appl, String version, String cacheIdent, String cacheSignature, TokenCache tCache, String lang) {
        this.ap = appl;
        this.ver = version;
        this.cacheId = cacheIdent;
        this.cacheSig = cacheSignature;
        this.group = group;
        this.language = lang;
    }

    public TokenCacheEntry(TokenCache tCache) {
    }

    public boolean loadFromCache() {
        int cCnt;
        BufferedReader br;
        block4: {
            br = null;
            br = new BufferedReader(new FileReader(String.valueOf(Globals.getOptionValueString("tokenCachePath")) + File.separatorChar + this.getCacheName()));
            String line = br.readLine();
            StringTokenizer lineTokens = new StringTokenizer(line, ",");
            lineTokens.nextElement();
            lineTokens.nextElement();
            lineTokens.nextElement();
            String cSig = (String)lineTokens.nextElement();
            cCnt = Integer.parseInt((String)lineTokens.nextElement());
            if (cSig.equals(this.cacheSig.toLowerCase())) break block4;
            br.close();
            return false;
        }
        try {
            this.elements = new String[cCnt];
            this.elementCount = cCnt;
            int i = 0;
            while (i < cCnt && (this.elements[i] = br.readLine().trim()) != null) {
                ++i;
            }
            br.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean loadFromServer(IOHandler io) {
        MToken token = io.getToken(this.group, 0, 0);
        if (token == null || this.group == 0) {
            return false;
        }
        Vector<MTokenItem> items = token.getTokenBlock();
        int count = token.getTokenCount();
        this.elements = new String[count];
        this.elementCount = 0;
        int i = 0;
        while (i < count) {
            MTokenItem item = items.elementAt(i);
            this.elements[i] = item.getVal();
            ++this.elementCount;
            ++i;
        }
        this.saveToCache();
        return true;
    }

    public void saveToCache() {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(String.valueOf(Globals.getOptionValueString("tokenCachePath")) + File.separatorChar + this.getCacheName()));
            bw.write((String.valueOf(this.ap) + "," + this.ver + "," + this.cacheId + "," + this.cacheSig + "," + this.elementCount).toLowerCase());
            bw.newLine();
            Enumeration<Object> tokens = this.getTokenElements();
            while (tokens.hasMoreElements()) {
                bw.write(tokens.nextElement().toString().trim());
                bw.newLine();
            }
            bw.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setGroup(int newGroup) {
        this.group = newGroup;
    }
}

