/*
 * Decompiled with CFR 0.152.
 */
package doc;

import comm.IOHandler;
import doc.Document;
import doc.TokenCacheEntry;
import java.util.Enumeration;
import java.util.Hashtable;

public class TokenCache {
    Hashtable<String, TokenCacheEntry> groups;
    Document document;
    IOHandler io;

    private TokenCacheEntry getTokenCacheEntry(String ap, String ver, String id, String sig, int group, String lang) {
        TokenCacheEntry token = null;
        String key = group + lang;
        if (!this.groups.containsKey(key)) {
            token = new TokenCacheEntry(group, ap, ver, id, sig, this, lang);
            if (!token.loadFromCache()) {
                token.loadFromServer(this.io);
            }
            this.groups.put(key, token);
        } else {
            token = this.groups.get(key);
        }
        return token;
    }

    public Object[] getTokenElementsArray(String ap, String ver, String id, String sig, int group, String lang) {
        TokenCacheEntry token = this.getTokenCacheEntry(ap, ver, id, sig, group, lang);
        if (token == null) {
            return null;
        }
        return token.getElementDataArray();
    }

    public Enumeration<Object> getTokenElements(String ap, String ver, String id, String sig, int group, String lang) {
        TokenCacheEntry token = this.getTokenCacheEntry(ap, ver, id, sig, group, lang);
        if (token == null) {
            return null;
        }
        return token.getTokenElements();
    }

    public TokenCache(IOHandler ioh, Document doc) {
        this.document = doc;
        this.io = ioh;
        this.groups = new Hashtable();
    }
}

