/*
 * Decompiled with CFR 0.152.
 */
package doc;

import comm.IOHandler;
import doc.Globals;
import doc.ResourceCache;
import java.awt.Image;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.ImageIcon;
import view.CharView;

public class ResourceCacheEntry {
    private String ap;
    private String cache;
    private String cacheId;
    private String stateStr;
    private int state;
    public static final int WDGT_STATE_PICTURE = 0;
    public static final int WDGT_STATE_ENABLED = 1;
    public static final int WDGT_STATE_DISABLED = 2;
    public static final int WDGT_STATE_SELECTED = 3;
    public static final int WDGT_STATE_ROLLOVER = 4;
    public static final int WDGT_STATE_ROLLOVER_SELECTED = 5;
    public static final int WDGT_STATE_PRESSED = 6;
    public static final int WDGT_STATE_WALLPAPER = 7;
    public static final int WDGT_STATE_FONT = 8;
    public static final int WDGT_STATE_RES_BUNDLE = 9;
    public static final int WDGT_STATE_EDITOR_CONFIG = 10;
    public static final int WDGT_STATE_MAX = 11;
    private String cacheName = null;
    private String cacheSig;
    private Hashtable<String, Object> data = new Hashtable();
    private String group;
    private String ver;

    public ResourceCacheEntry(String id, String sig, String group, ResourceCache rCache) {
        this.cacheId = id;
        this.cacheSig = sig;
        this.group = group;
        StringTokenizer tokens = new StringTokenizer(this.cacheId, ".");
        this.ap = (String)tokens.nextElement();
        this.ver = (String)tokens.nextElement();
        this.cache = (String)tokens.nextElement();
        this.stateStr = (String)tokens.nextElement();
        this.state = Integer.parseInt(this.stateStr, 16);
    }

    private final String getCacheName() {
        if (this.cacheName == null) {
            this.cacheName = (this.ap + this.ver + this.cache).toLowerCase();
        }
        return this.cacheName;
    }

    private final synchronized Image readImage(CharView v, String key) {
        ImageIcon imgIcon = null;
        String imgName = String.valueOf(Globals.getOptionValueString("resourceCachePath")) + File.separatorChar + this.getCacheName() + "-" + key + ".dat";
        try {
            ObjectInputStream ois = new ObjectInputStream(new GZIPInputStream(new FileInputStream(imgName)));
            imgIcon = (ImageIcon)ois.readObject();
            ois.close();
            return imgIcon.getImage();
        }
        catch (Exception e) {
            System.err.println("ResourceCacheEntry.readImage() key=" + key + ", Exception=" + e);
            return null;
        }
    }

    private final synchronized void saveImage(Image image) {
        ImageIcon imgIcon = new ImageIcon(image);
        String imgName = String.valueOf(Globals.getOptionValueString("resourceCachePath")) + File.separatorChar + this.getCacheName() + "-" + image.getWidth(null) + "x" + image.getHeight(null) + ".dat";
        try {
            ObjectOutputStream s = new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(imgName)));
            s.writeObject(imgIcon);
            s.close();
        }
        catch (Exception e) {
            System.err.println("ResourceCacheEntry.saveImage() name=" + imgName + ", Exception=" + e);
        }
    }

    public final String getData() {
        return (String)this.data.get("default");
    }

    public final Image getImageData(CharView v, float scaleWidth, float scaleHeight, char scaleType) {
        Object tmpImage;
        if (scaleType == ' ' || (double)scaleWidth == 1.0 && (double)scaleHeight == 1.0 && scaleType == '*') {
            if (Globals.getOptionValueBoolean("cacheImagesToMemory")) {
                Object tmp = this.data.get("default");
                if (!(tmp instanceof Image)) {
                    tmp = v.loadImage((String)this.data.get("default"));
                    this.data.remove("default");
                    this.data.put("default", tmp);
                }
                return (Image)tmp;
            }
            return v.loadImage((String)this.data.get("default"));
        }
        Object tmp = this.data.get("default");
        String def = null;
        Image image = null;
        if (tmp instanceof Image) {
            image = (Image)tmp;
        } else {
            def = (String)tmp;
        }
        int x = (int)scaleWidth;
        int y = (int)scaleHeight;
        if (scaleType == '*') {
            if (image == null) {
                image = v.loadImage(def);
            }
            if (image != null) {
                x = (int)(scaleWidth * (float)image.getWidth(null));
                y = (int)(scaleHeight * (float)image.getHeight(null));
            }
        }
        if (scaleType == '%') {
            if (image == null) {
                image = v.loadImage(def);
            }
            if (image != null) {
                y = (int)(scaleHeight * scaleWidth / 100.0f);
                x = (int)((float)y / (float)image.getHeight(null) * (float)image.getWidth(null));
            }
        }
        if (scaleType == '+') {
            if (image == null) {
                image = v.loadImage(def);
            }
            if (image != null) {
                float targetAspect = scaleWidth / scaleHeight;
                float sourceAspect = (float)image.getWidth(null) / (float)image.getHeight(null);
                if (targetAspect > sourceAspect) {
                    x = (int)(scaleHeight * sourceAspect);
                    y = (int)scaleHeight;
                } else if (targetAspect < sourceAspect) {
                    x = (int)scaleWidth;
                    y = (int)(scaleWidth / sourceAspect);
                } else {
                    x = (int)scaleWidth;
                    y = (int)scaleHeight;
                }
            }
        }
        if ((tmpImage = this.data.get(x + "x" + y)) != null) {
            if (tmpImage instanceof Image) {
                return (Image)tmpImage;
            }
            image = this.readImage(v, x + "x" + y);
            if (image != null) {
                this.data.remove(x + "x" + y);
                this.data.put(x + "x" + y, image);
                return image;
            }
        }
        if (image == null) {
            image = v.loadImage(def);
        }
        if (image != null) {
            if (image.getHeight(null) != y || image.getWidth(null) != x) {
                v.setStatusText("Scaling Image...");
                image = v.scaleImage(image, x, y);
            }
            if (def != null && def.startsWith(Globals.getOptionValueString("resourceCachePath"))) {
                this.saveImage(image);
                this.data.put(x + "x" + y, image);
                this.saveToCache();
            } else {
                this.data.put(x + "x" + y, image);
            }
        }
        v.setStatusText("");
        return image;
    }

    public String getCacheSig() {
        return this.cacheSig;
    }

    public void setCacheSig(String newCacheSig) {
        this.cacheSig = newCacheSig;
    }

    public final boolean loadFromCache() {
        String line;
        boolean current;
        BufferedReader br;
        String dPath;
        block7: {
            dPath = String.valueOf(Globals.getOptionValueString("resourceCachePath")) + File.separatorChar + this.getCacheName();
            br = null;
            current = true;
            this.data = new Hashtable();
            br = new BufferedReader(new FileReader(String.valueOf(Globals.getOptionValueString("resourceCachePath")) + File.separatorChar + this.getCacheName()));
            line = br.readLine();
            if (line != null) break block7;
            return false;
        }
        try {
            String dataLine;
            StringTokenizer lineTokens = new StringTokenizer(line, ",");
            lineTokens.nextElement();
            String cSig = (String)lineTokens.nextElement();
            if (!cSig.equals(this.cacheSig.toLowerCase())) {
                current = false;
            }
            while ((dataLine = br.readLine()) != null) {
                StringTokenizer dataTokens = new StringTokenizer(dataLine, ",");
                String key = (String)dataTokens.nextElement();
                String dat = (String)dataTokens.nextElement();
                if (key == null || dat == null) continue;
                if (current) {
                    this.data.put(key, dat);
                    continue;
                }
                if (!dat.startsWith(Globals.getOptionValueString("resourceCachePath"))) continue;
                Image image = CharView.view.getToolkit().getImage(dat);
                image.flush();
                new File(dat).delete();
            }
            br.close();
            if (!current) {
                Image image = CharView.view.getToolkit().getImage(dPath);
                image.flush();
                new File(dPath).delete();
                this.data = new Hashtable();
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public final boolean loadFromServer(IOHandler io, String serverGroup) {
        this.group = serverGroup;
        try {
            this.data.put("default", io.getResource(this.cacheId, this.group, String.valueOf(Globals.getOptionValueString("resourceCachePath")) + File.separatorChar));
        }
        catch (Exception e) {
            System.err.println("doc.ResourceCacheEntry.loadFromServer() exception=" + e);
            return false;
        }
        if (this.data.get("default") == null) {
            return false;
        }
        this.saveToCache();
        return true;
    }

    public final void saveToCache() {
        String dPath = String.valueOf(Globals.getOptionValueString("resourceCachePath")) + File.separatorChar + this.getCacheName();
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(String.valueOf(Globals.getOptionValueString("resourceCachePath")) + File.separatorChar + this.getCacheName()));
            bw.write((String.valueOf(this.cacheId) + "," + this.cacheSig).toLowerCase());
            bw.newLine();
            Enumeration<String> dataKeys = this.data.keys();
            while (dataKeys.hasMoreElements()) {
                Object dat;
                String key = dataKeys.nextElement();
                if (key == null || (dat = this.data.get(key)) == null) continue;
                if (key.equals("default")) {
                    bw.write(String.valueOf(key) + "," + (String)dat);
                } else {
                    bw.write(String.valueOf(key) + "," + dPath + "-" + key + ".dat");
                }
                bw.newLine();
            }
            bw.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

