/*
 * Decompiled with CFR 0.152.
 */
package doc;

import comm.IOHandler;
import doc.Document;
import doc.ResourceCacheEntry;
import java.awt.Image;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import view.CharView;

public class ResourceCache {
    private Hashtable<String, ResourceCacheEntry> groups;
    private IOHandler io;

    public ResourceCache(IOHandler ioh, Document doc) {
        this.io = ioh;
        this.groups = new Hashtable();
    }

    public final void flushMemoryCache() {
        Enumeration<ResourceCacheEntry> caches = this.groups.elements();
        while (caches.hasMoreElements()) {
            ResourceCacheEntry rc = caches.nextElement();
            if (rc == null) continue;
            rc.loadFromCache();
        }
    }

    public final Image getImageResource(CharView v, String raw, float scaleWidth, float scaleHeight, char scaleType) {
        StringTokenizer tokens = new StringTokenizer(raw, ",");
        return this.getImageResource(v, (String)tokens.nextElement(), (String)tokens.nextElement(), (String)tokens.nextElement(), scaleWidth, scaleHeight, scaleType);
    }

    public final Image getImageResource(CharView v, String id, String sig, String group, float scaleWidth, float scaleHeight, char scaleType) {
        ResourceCacheEntry resource = null;
        if (!this.groups.containsKey(id)) {
            resource = new ResourceCacheEntry(id, sig, group, this);
            if (!resource.loadFromCache()) {
                resource.loadFromServer(this.io, group);
            }
            this.groups.put(id, resource);
        } else {
            resource = this.groups.get(id);
            if (resource != null && !resource.getCacheSig().equals(sig)) {
                resource.setCacheSig(sig);
                if (!resource.loadFromCache()) {
                    resource.loadFromServer(this.io, group);
                }
            }
        }
        return resource.getImageData(v, scaleWidth, scaleHeight, scaleType);
    }

    public final String getResource(String raw) {
        StringTokenizer tokens = new StringTokenizer(raw, ",");
        return this.getResource((String)tokens.nextElement(), (String)tokens.nextElement(), (String)tokens.nextElement());
    }

    public final String getResource(String id, String sig, String group) {
        ResourceCacheEntry resource = null;
        if (!this.groups.containsKey(id)) {
            resource = new ResourceCacheEntry(id, sig, group, this);
            if (!resource.loadFromCache()) {
                resource.loadFromServer(this.io, group);
            }
            this.groups.put(id, resource);
        } else {
            resource = this.groups.get(id);
        }
        return resource.getData();
    }
}

