/*
 * Decompiled with CFR 0.152.
 */
package doc;

import debug.AppxDebug;
import doc.Globals;
import doc.JTableX;
import doc.RowEditorModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import view.CharView;

public class PropertySheet
extends JPanel {
    private static final long serialVersionUID = -6301628811455458424L;
    private String sectionName;
    private JTableX table;
    private DefaultTableModel model;
    private String[] col_names = new String[]{"Option", "Value", "Default Value", "Description"};
    private String[] boolean_values = new String[]{"true", "false"};
    JComboBox bool_b = new JComboBox<String>(this.boolean_values);
    JComboBox dbgLevel_b = new JComboBox<String>(AppxDebug.sevTxt);
    DefaultCellEditor bool_ed = new DefaultCellEditor(this.bool_b);
    DefaultCellEditor dbgLevel_ed = new DefaultCellEditor(this.dbgLevel_b);
    protected boolean saveChanges;

    private void createGUI() {
        this.setLayout(new BorderLayout());
        this.setBorder(null);
        int optionCount = Globals.getOptionCount(this.sectionName);
        final int[] optionMap = Globals.getOptionMapping(this.sectionName);
        this.model = new DefaultTableModel(this.col_names, optionCount){
            private static final long serialVersionUID = 5157470182917814563L;

            @Override
            public Object getValueAt(int row, int col) {
                String tag = Globals.getOptionTag(optionMap[row]);
                if (col == 0) {
                    return tag;
                }
                if (col == 1) {
                    if (Globals.getOptionDataList(optionMap[row]) != null) {
                        return Globals.getRawOptionValueListString(tag, true);
                    }
                    return Globals.getRawOptionValueString(tag, true);
                }
                if (col == 2) {
                    if (Globals.getOptionDataList(optionMap[row]) != null) {
                        return Globals.getOptionDefaultValueListString(optionMap[row]);
                    }
                    return Globals.getOptionDefaultValueString(optionMap[row]);
                }
                if (col == 3) {
                    return Globals.getOptionDescription(optionMap[row]);
                }
                if (col == 12) {
                    return Globals.getOptionDescription(optionMap[row]);
                }
                return "";
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                if (Globals.getOptionDataList(optionMap[row]) != null) {
                    Globals.setOptionListValue(Globals.getOptionTag(optionMap[row]), (String)aValue, true);
                } else {
                    Globals.setOptionValue(Globals.getOptionTag(optionMap[row]), (String)aValue, true);
                }
                this.fireTableChanged(new TableModelEvent(this, row, row, column));
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                if (((String)this.getValueAt(row, 0)).charAt(0) == '[') {
                    return false;
                }
                if (col == 1) {
                    return Globals.getOptionEditable(optionMap[row]);
                }
                return false;
            }
        };
        this.table = new JTableX(this.model);
        this.table.setRowSelectionAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        TableColumn column = null;
        int i = 0;
        while (i < 4) {
            column = this.table.getColumnModel().getColumn(i);
            if (i == 3) {
                column.setPreferredWidth(340);
            } else if (i == 0) {
                column.setPreferredWidth(200);
            } else {
                column.setPreferredWidth(100);
            }
            ++i;
        }
        RowEditorModel rm = new RowEditorModel();
        this.table.setRowEditorModel(rm);
        int i2 = 0;
        while (i2 < optionCount) {
            if (Globals.getOptionDataList(optionMap[i2]) != null) {
                rm.addEditorForRow(i2, new DefaultCellEditor(new JComboBox<String>((String[])Globals.getOptionDataList(optionMap[i2]))));
            } else if (Globals.getOptionDataType(optionMap[i2]) == Boolean.class) {
                rm.addEditorForRow(i2, this.bool_ed);
            }
            ++i2;
        }
        JScrollPane sp = new JScrollPane(this.table);
        this.add((Component)sp, "Center");
    }

    public PropertySheet(boolean save, String section) {
        this.sectionName = section;
        this.createGUI();
        JFrame f = new JFrame("Client Preferences: " + Globals.getIniFile());
        f.setSize(640, 640);
        f.getContentPane().add((Component)this, "Center");
        this.saveChanges = save;
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (PropertySheet.this.saveChanges) {
                    Globals.save(null, true);
                }
                if (CharView.view != null) {
                    CharView.view.kickScreen();
                }
                Globals.updateDebugMask();
            }
        });
        f.setVisible(true);
    }

    public static void main(String[] args) {
    }
}

