/*
 * Decompiled with CFR 0.152.
 */
package doc;

import debug.AppxDebug;
import doc.AppxToolkit;
import doc.Globals;
import doc.Native;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.Socket;
import java.util.Hashtable;
import view.CharView;

public class NativeWindows
implements Native {
    private static final String libraryName = "NativeWindows";
    private static final String libraryName64 = "NativeWindows64";
    private static final int minVersionRequired = 1;
    private static final int HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    private static final String[] hkeyList = new String[]{"HKEY_CLASSES_ROOT", "HKEY_CURRENT_USER", "HKEY_LOCAL_MACHINE", "HKEY_USERS", "HKEY_PERFORMANCE_DATA", "HKEY_CURRENT_CONFIG", "HKEY_DYN_DATA"};
    private static int winprintdllStatus = 0;
    protected static String lastConfigString;
    protected static String lastDisplayString;
    protected static String lastPrintCommand;
    protected static String lastPrintFilename;
    protected static String lastPrintString;
    protected static boolean lastRemove;

    protected static native int getver();

    protected static native String get_printer_name();

    protected static native String authsso(Socket var0, String var1);

    protected static native boolean launch_document(String var0, String var1);

    protected static native String read_registry_string(int var0, String var1, String var2);

    protected static native boolean shellexec(String[] var0);

    protected static native boolean winprint(String[] var0);

    protected static native boolean winprint_setup();

    private static final boolean executeCommand(String execString, boolean wait, boolean nativeApi) {
        if (nativeApi) {
            if (NativeWindows.loadWinprintdll()) {
                String[] args = new String[1];
                int idx = 0;
                if (wait) {
                    execString = "/W " + execString;
                }
                args[idx] = execString;
                NativeWindows.shellexec(args);
                return true;
            }
        } else {
            Runtime rt = Runtime.getRuntime();
            try {
                Process pr = rt.exec(execString);
                if (wait && pr != null) {
                    try {
                        pr.waitFor();
                    }
                    catch (Exception e1) {
                        System.err.println("");
                    }
                }
                Thread.sleep(5000L);
                return true;
            }
            catch (Exception e2) {
                System.err.println("");
            }
        }
        return false;
    }

    public static final String getWindowsCommandForExtension(String extension, String command) {
        String filetype = null;
        String filetype2 = null;
        String windowsCmd = null;
        String result = null;
        filetype = extension.charAt(0) == '.' ? NativeWindows.readRegistryString(Integer.MIN_VALUE, extension, "") : NativeWindows.readRegistryString(Integer.MIN_VALUE, "." + extension, "");
        if (filetype != null && (windowsCmd = (filetype2 = NativeWindows.readRegistryString(Integer.MIN_VALUE, filetype + "\\CurVer\\", "")) == null ? NativeWindows.readRegistryString(Integer.MIN_VALUE, filetype + "\\shell\\" + command + "\\command", "") : NativeWindows.readRegistryString(Integer.MIN_VALUE, filetype2 + "\\shell\\" + command + "\\command", "")) != null) {
            result = windowsCmd;
        }
        return result;
    }

    private static final String getWindowsPrinterName() {
        if (NativeWindows.loadWinprintdll()) {
            return NativeWindows.get_printer_name();
        }
        return null;
    }

    private static final Hashtable loadConfigFile(String configFile) {
        BufferedReader br;
        Hashtable<String, String> masterList = new Hashtable<String, String>();
        if (configFile == null) {
            return null;
        }
        String filename = Globals.stripQuotesFromString(configFile);
        try {
            br = new BufferedReader(new FileReader(filename));
        }
        catch (Exception e) {
            System.err.println("doc.LocalPrint.loadConfigFile(failed 1) exception=" + e);
            return null;
        }
        int equaloffset = 0;
        String line = null;
        do {
            try {
                line = br.readLine();
                if (line == null || line.length() <= 0 || (equaloffset = (line = line.trim()).indexOf("=")) <= 0) continue;
                masterList.put(line.substring(0, equaloffset).trim(), line.substring(equaloffset + 1).trim());
            }
            catch (Exception e) {
                line = null;
            }
        } while (line != null);
        try {
            br.close();
        }
        catch (Exception e) {
            System.err.println("LocalPrint.loadConfigFile() config file close() failed, exception=" + e);
        }
        return masterList;
    }

    private static final boolean loadWinprintdll() {
        if (winprintdllStatus == 0) {
            winprintdllStatus = 2;
            String libName = null;
            libName = System.getProperty("os.arch").indexOf("64") != -1 ? libraryName64 : libraryName;
            if (CharView.view != null && CharView.view.applet != null) {
                File dllFile = new File(String.valueOf(Globals.getOptionValueString("userClientRoot")) + File.separator + libName + ".dll");
                if (!dllFile.exists()) {
                    AppxToolkit.copyURL(CharView.view.applet.getClass().getResource("/" + libName + ".dll"), dllFile);
                }
                try {
                    System.err.println("load");
                    System.load(dllFile.getAbsolutePath());
                    winprintdllStatus = 1;
                }
                catch (Exception e) {
                    System.err.println("NativeWindows.loadWinprintdll(1) failed to load DLL. exception=" + e);
                }
            } else {
                try {
                    System.err.println("loadLibrary");
                    System.loadLibrary(libName);
                    System.err.println("NativeWindows(" + libName + ") Loaded! Minimum version required=" + 1 + ", found and loaded=" + NativeWindows.getver());
                    winprintdllStatus = 1;
                }
                catch (Exception e) {
                    System.err.println("NativeWindows.loadWinprintdll(" + libName + ") failed to load DLL. exception=" + e);
                }
            }
        }
        return winprintdllStatus == 1;
    }

    private static final String readRegistryString(int hkey, String section, String key) {
        String result = null;
        if (NativeWindows.loadWinprintdll() && (result = NativeWindows.read_registry_string(hkey, section, key)).startsWith("**ERROR**")) {
            String keyWork = key;
            if (keyWork == "") {
                keyWork = "(Default)";
            }
            System.err.println("doc.LocalPrint.readRegistryString(" + hkeyList[hkey - Integer.MIN_VALUE] + ", " + section + ", " + keyWork + ") " + result);
            result = null;
        }
        return result;
    }

    @Override
    public boolean displayFile(String displayStringIn, String viewer, boolean wait, boolean remove) {
        AppxDebug.log(0, "NativeWindows.displayFile() string=" + displayStringIn + ", wait=" + wait + ", remove=" + remove, 1);
        String displayString = displayStringIn;
        if (displayStringIn.toLowerCase().endsWith(".txt") || displayStringIn.toLowerCase().endsWith(".txt\"")) {
            displayString = displayStringIn.replaceFirst("[.]txt", ".doc");
            File oldFile = new File(Globals.stripQuotesFromString(displayStringIn));
            File newFile = new File(Globals.stripQuotesFromString(displayString));
            System.err.println("    Renamed =[" + displayString + "]");
            if (!oldFile.renameTo(newFile)) {
                displayString = displayStringIn;
            }
        }
        if (viewer != null) {
            String command = viewer.matches("[$%]1") ? viewer.replaceFirst("[%$]1", displayString) : String.valueOf(viewer) + " " + displayString;
            try {
                Runtime.getRuntime().exec(command);
                return true;
            }
            catch (Exception e) {
                System.err.println("LocalPrint.displayFile(" + displayString + ") failed. command=" + command + ", error=" + e);
                return false;
            }
        }
        if (NativeWindows.loadWinprintdll()) {
            lastDisplayString = displayString;
            lastRemove = remove;
            Thread initThread = new Thread(){

                @Override
                public void run() {
                    String displayString = lastDisplayString;
                    boolean remove = lastRemove;
                    try {
                        Runtime.getRuntime().exec("cmd.exe /c start \"\" " + displayString);
                    }
                    catch (Exception e) {
                        System.err.println("NativeWindows.displayFile(" + displayString + ") failed. command=" + displayString + ", error=" + e);
                    }
                    if (remove) {
                        String filename = Globals.parseFirstQuotedString(displayString);
                        try {
                            Thread.sleep(Globals.getOptionValueInteger("autoDeleteTimer") * 1000);
                        }
                        catch (Exception exc) {
                            System.err.println("NativeWindows.displayFile() exception waiting for delete, e=" + exc);
                        }
                        new File(Globals.stripQuotesFromString(filename)).delete();
                    }
                }
            };
            initThread.start();
            if (wait) {
                try {
                    initThread.join();
                }
                catch (Exception e) {
                    System.err.println("NativeWindows.displayFile() initThread exception=" + e);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean executeCommand(String execString, boolean wait) {
        AppxDebug.log(0, "NativeWindows.executeCommand() string=" + execString + ", wait=" + wait, 1);
        return NativeWindows.executeCommand(execString, wait, true);
    }

    @Override
    public String authenticateSSO(Socket sock, String login) {
        System.err.println("authenticateSSO() called");
        if (NativeWindows.loadWinprintdll()) {
            return NativeWindows.authsso(sock, login);
        }
        return "NativeWindows.dll not loaded";
    }

    @Override
    public boolean launchDocument(String verb, String launchString, boolean wait) {
        String workString = launchString;
        String pdfCommand = null;
        AppxDebug.log(0, "NativeWindows.launchDocument() verb=" + verb + ", string=" + launchString + ", wait=" + wait, 1);
        if (verb == null) {
            verb = "**NULL**";
        }
        if (System.getProperty("os.name").indexOf("NT") != -1) {
            workString = Globals.stripQuotesFromString(workString);
        }
        if (Globals.stripQuotesFromString(workString.toLowerCase()).indexOf(".pdf") >= 0) {
            pdfCommand = Globals.parseFirstQuotedString(NativeWindows.getWindowsCommandForExtension(".pdf", verb));
            if (pdfCommand.toLowerCase().indexOf("acro") < 0) {
                pdfCommand = null;
            } else {
                pdfCommand = Globals.parseFirstQuotedString(pdfCommand);
                pdfCommand = verb == "open" ? String.valueOf(pdfCommand) + " /n " : (verb == "print" ? String.valueOf(pdfCommand) + " /h /p " : (verb == "printto" ? String.valueOf(pdfCommand) + " /t " : null));
            }
        }
        if (pdfCommand == null) {
            if (wait) {
                workString = "/w " + workString;
            }
            AppxDebug.log(0, "NativeWindows.launchDocument() launch_document: verb=" + verb + ", launchString=" + launchString, 1);
            if (NativeWindows.loadWinprintdll()) {
                NativeWindows.launch_document(verb, launchString);
            }
        } else {
            AppxDebug.log(0, "NativeWindows.launchDocument() executeCommand: pdfCommand=" + pdfCommand + ", workString=" + workString, 1);
            NativeWindows.executeCommand(pdfCommand + " " + workString, wait, false);
        }
        return true;
    }

    @Override
    public boolean showPrintSetupDialog() {
        AppxDebug.log(0, "NativeWindows.showPrintSetupDialog()", 1);
        if (NativeWindows.loadWinprintdll()) {
            new Thread(){

                @Override
                public void run() {
                    NativeWindows.winprint_setup();
                }
            }.start();
            return true;
        }
        return false;
    }

    @Override
    public boolean submitPrintRequest(String submitString) {
        AppxDebug.log(0, "NativeWindows.submitPrintRequest() string=" + submitString, 1);
        if (NativeWindows.loadWinprintdll()) {
            String[] args = Globals.parseQuotedStrings("-disposition=scratch " + submitString);
            int idx = 0;
            int pdfIndex = -1;
            int cfgIndex = -1;
            while (idx < args.length && (pdfIndex == -1 || cfgIndex == -1)) {
                if (args[idx].toLowerCase().indexOf(".pdf") >= 0) {
                    pdfIndex = idx;
                }
                if (args[idx].toLowerCase().indexOf(".cfg") >= 0) {
                    cfgIndex = idx;
                }
                ++idx;
            }
            if (pdfIndex == -1) {
                NativeWindows.winprint(args);
            } else {
                lastPrintString = args[pdfIndex];
                lastPrintCommand = "print";
                lastConfigString = cfgIndex == -1 ? null : args[cfgIndex].substring(8);
                lastPrintFilename = lastPrintString;
                String winPrintCommand = NativeWindows.getWindowsCommandForExtension(".pdf", "printto");
                if (winPrintCommand != null && lastConfigString != null) {
                    Hashtable config = NativeWindows.loadConfigFile(lastConfigString);
                    if (config != null && config.get("-printer_id") != null && ((String)config.get("-printer_id")).length() > 0) {
                        lastPrintString = String.valueOf(lastPrintString) + " \"" + (String)config.get("-printer_id") + "\"";
                        lastPrintCommand = "printto";
                    } else {
                        String userPrinter = NativeWindows.getWindowsPrinterName();
                        if (userPrinter != null && userPrinter.length() > 0) {
                            lastPrintString = String.valueOf(lastPrintString) + " \"" + userPrinter + "\"";
                            lastPrintCommand = "printto";
                        }
                    }
                }
                try {
                    Thread.sleep(Globals.getOptionValueInteger("autoDeleteTimer") * 50);
                }
                catch (Exception exc) {
                    System.err.println("NativeWindows.submitPrintRequest(1) exception waiting for delete, e=" + exc);
                }
                if (lastConfigString != null) {
                    new File(Globals.stripQuotesFromString(lastConfigString)).delete();
                }
                Thread printThread = new Thread(){

                    @Override
                    public void run() {
                        String printString = lastPrintString;
                        String printCommand = lastPrintCommand;
                        String printFilename = lastPrintFilename;
                        NativeWindows.this.launchDocument(printCommand, printString, true);
                        try {
                            Thread.sleep(Globals.getOptionValueInteger("autoDeleteTimer") * 1000);
                        }
                        catch (Exception exc) {
                            System.err.println("NativeWindows.submitPrintRequest(2) exception waiting for delete, e=" + exc);
                        }
                        try {
                            new File(Globals.stripQuotesFromString(printFilename)).delete();
                        }
                        catch (Exception e) {
                            System.err.println("LocalPrint Delete or print file [" + printFilename + "] Failed! Exception=" + e);
                        }
                    }
                };
                printThread.start();
            }
            return true;
        }
        return false;
    }

    @Override
    public String getDefaultInputFontName() {
        return "DialogInput";
    }

    @Override
    public String getDefaultPrinterFontName() {
        return "DialogInput";
    }
}

