/*
 * Decompiled with CFR 0.152.
 */
package doc;

import debug.AppxDebug;
import doc.AppxToolkit;
import doc.Globals;
import doc.Native;
import doc.Secure;
import java.io.File;
import java.net.Socket;
import view.CharView;

public class NativeLinux
implements Native {
    @Override
    public String authenticateSSO(Socket sock, String login) {
        return new String("Not implemented for Linux");
    }

    @Override
    public boolean displayFile(String displayString, String viewer, boolean wait, boolean remove) {
        String[] runString;
        String path;
        String filename = Globals.stripQuotesFromString(Globals.parseFirstQuotedString(displayString));
        AppxDebug.log(0, "NativeLinux.displayFile() string=" + displayString + ", wait=" + wait + ", remove=" + remove, 1);
        if (viewer != null) {
            String command = viewer.matches("[$%]1") ? viewer.replaceFirst("[%$]1", filename) : String.valueOf(viewer) + " " + filename;
            try {
                AppxDebug.log(0, "NativeLinux.displayFile() running=" + command, 1);
                Runtime.getRuntime().exec(command);
                return true;
            }
            catch (Exception e) {
                System.err.println("LocalPrint.displayFile(" + displayString + ") failed. command=" + command + ", error=" + e);
                return false;
            }
        }
        if (CharView.view.applet == null && !CharView.view.webstartEnabled) {
            path = String.valueOf(System.getProperty("user.dir")) + File.separator;
        } else {
            path = String.valueOf(Globals.getOptionValueString("userClientRoot")) + File.separator;
            File dllFile = new File(String.valueOf(path) + "appx_display");
            if (!dllFile.exists()) {
                if (CharView.view.webstartEnabled) {
                    AppxToolkit.copyURL(CharView.view.getClass().getResource("/scripts/appx_display"), dllFile);
                } else {
                    AppxToolkit.copyURL(CharView.view.applet.getClass().getResource("/appx_display"), dllFile);
                }
                this.executeCommand("chmod 777 " + dllFile.getAbsolutePath(), true);
            }
        }
        if (remove) {
            runString = new String[]{String.valueOf(path) + "appx_display", "-delete", filename};
            return this.executeCommand(runString, wait);
        }
        runString = new String[]{String.valueOf(path) + "appx_display", filename};
        return this.executeCommand(runString, wait);
    }

    @Override
    public boolean executeCommand(String execString, boolean wait) {
        String[] args = Globals.parseQuotedStringsRemovingQuotes(execString);
        return this.executeCommand(args, wait);
    }

    public boolean executeCommand(String[] args, boolean wait) {
        Runtime rt = Runtime.getRuntime();
        int ii = 0;
        while (ii < args.length) {
            System.err.println("  arg[" + ii + "]=[" + args[ii] + "]");
            ++ii;
        }
        try {
            Process pr = rt.exec(args);
            if (wait && pr != null) {
                try {
                    pr.waitFor();
                }
                catch (Exception e1) {
                    System.err.println("doc.NativeLinux.executeCommand(1) failed, exception=" + e1);
                }
            }
            return true;
        }
        catch (Exception e2) {
            System.err.println("doc.NativeLinux.executeCommand(2) failed, exception=" + e2);
            return false;
        }
    }

    @Override
    public boolean launchDocument(String verb, String launchString, boolean wait) {
        if (verb == null) {
            verb = "open";
        }
        if (verb == "open") {
            return this.displayFile(launchString, null, wait, false);
        }
        return false;
    }

    @Override
    public boolean showPrintSetupDialog() {
        return false;
    }

    @Override
    public boolean submitPrintRequest(String submitString) {
        String path;
        if (CharView.view.applet == null && !CharView.view.webstartEnabled) {
            path = String.valueOf(System.getProperty("user.dir")) + File.separator;
            AppxDebug.log("Local path=[" + path + "]");
        } else {
            path = String.valueOf(Globals.getOptionValueString("userClientRoot")) + File.separator;
            File dllFile = new File(String.valueOf(path) + "appx_print");
            AppxDebug.log("WebStart path=[" + path + "]");
            if (!dllFile.exists()) {
                if (CharView.view.webstartEnabled) {
                    AppxToolkit.copyURL(CharView.view.getClass().getResource("/scripts/appx_print"), dllFile);
                } else {
                    AppxToolkit.copyURL(CharView.view.applet.getClass().getResource("/appx_print"), dllFile);
                }
                this.executeCommand("chmod 777 " + dllFile.getAbsolutePath(), true);
                Secure.createDirs(String.valueOf(path) + "filters");
                Secure.createDirs(String.valueOf(path) + "filters" + File.separator + "ASI");
                dllFile = new File(String.valueOf(path) + "filters" + File.separator + "ASI" + File.separator + "PCL");
                if (CharView.view.webstartEnabled) {
                    AppxToolkit.copyURL(CharView.view.getClass().getResource("/scripts/filters/ASI/PCL"), dllFile);
                } else {
                    AppxToolkit.copyURL(CharView.view.applet.getClass().getResource("/filters/ASI/PCL"), dllFile);
                }
                this.executeCommand("chmod 777 " + dllFile.getAbsolutePath(), true);
                dllFile = new File(String.valueOf(path) + "filters" + File.separator + "ASI" + File.separator + "MPAGE");
                if (CharView.view.webstartEnabled) {
                    AppxToolkit.copyURL(CharView.view.getClass().getResource("/scripts/filters/ASI/MPAGE"), dllFile);
                } else {
                    AppxToolkit.copyURL(CharView.view.applet.getClass().getResource("/filters/ASI/MPAGE"), dllFile);
                }
                this.executeCommand("chmod 777 " + dllFile.getAbsolutePath(), true);
                dllFile = new File(String.valueOf(path) + "filters" + File.separator + "ASI" + File.separator + "PDF");
                if (CharView.view.webstartEnabled) {
                    AppxToolkit.copyURL(CharView.view.getClass().getResource("/scripts/filters/ASI/PDF"), dllFile);
                } else {
                    AppxToolkit.copyURL(CharView.view.applet.getClass().getResource("/filters/ASI/PDF"), dllFile);
                }
                this.executeCommand("chmod 777 " + dllFile.getAbsolutePath(), true);
            }
        }
        return this.executeCommand(String.valueOf(path) + "appx_print " + Globals.stripAllQuotesFromString(submitString), true);
    }

    @Override
    public String getDefaultInputFontName() {
        return "DialogInput";
    }

    @Override
    public String getDefaultPrinterFontName() {
        return "DialogInput";
    }
}

