/*
 * Decompiled with CFR 0.152.
 */
package doc;

import doc.Globals;
import doc.Native;
import doc.NativeStub;
import java.net.Socket;

public class LocalPrint {
    private static Native nat = null;

    private static final Native getNative() {
        if (nat == null) {
            String className = null;
            try {
                className = "doc.Native" + Globals.parseFirstQuotedString(System.getProperty("os.name"));
                nat = (Native)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                System.err.println("CharView.allocWidget(" + className + ") Exception=" + e);
            }
            if (nat == null) {
                nat = new NativeStub();
            }
        }
        return nat;
    }

    public static final String authenticateSSO(Socket sock, String login) {
        return LocalPrint.getNative().authenticateSSO(sock, login);
    }

    public static final boolean displayFile(String displayStringIn) {
        String viewer = null;
        String displayStringTrimmed = displayStringIn.trim();
        String displayString = displayStringTrimmed;
        if (displayString.endsWith(".pdf") || displayString.endsWith(".pdf\"")) {
            viewer = Globals.getOptionValueString("pdfReportViewer");
        } else if (displayString.endsWith(".txt") || displayString.endsWith(".txt\"")) {
            viewer = Globals.getOptionValueString("txtReportViewer");
        }
        System.err.println("displayFile() Information");
        System.err.println("    StringIn=[" + displayStringIn + "]");
        System.err.println("    Trimmed =[" + displayString + "]");
        System.err.println("    Viewer  =[" + viewer + "]");
        return LocalPrint.getNative().displayFile(displayString, viewer, false, true);
    }

    public static final boolean execWindowsDocument(String verb, String execString) {
        boolean wait = false;
        String launchString = execString;
        if (execString.toLowerCase().startsWith("/w ")) {
            wait = true;
            launchString = execString.substring(3).trim();
        }
        return LocalPrint.getNative().launchDocument(verb, launchString, wait);
    }

    public static final boolean showPrintSetupDialog() {
        return LocalPrint.getNative().showPrintSetupDialog();
    }

    public static final boolean startWindowsDocument(String startString) {
        boolean wait = false;
        String launchString = startString;
        if (startString.toLowerCase().startsWith("/w ")) {
            wait = true;
            launchString = startString.substring(3).trim();
        }
        return LocalPrint.getNative().executeCommand(launchString, wait);
    }

    public static final boolean submitPrintRequest(String submitString) {
        return LocalPrint.getNative().submitPrintRequest(submitString);
    }

    public static String getDefaultInputFontName() {
        return LocalPrint.getNative().getDefaultInputFontName();
    }

    public static String getDefaultPrinterFontName() {
        return LocalPrint.getNative().getDefaultPrinterFontName();
    }
}

