/*
 * Decompiled with CFR 0.152.
 */
package doc;

import doc.Sorter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class INIFile {
    public static final int NO_LOAD = 0;
    public static final int AUTOLOAD = 1;
    public static final int MERGE = 0;
    public static final int CLEAR = 2;
    private static final String NULL_VALUE = "{default}";
    private Hashtable<String, String> masterList;
    private String iniFileName;

    public String getIniFileName() {
        return this.iniFileName;
    }

    public boolean setIniFileName(String iniFileName) {
        return this.setIniFileName(iniFileName, 1);
    }

    public boolean setIniFileName(String iniFileName, int options) {
        this.iniFileName = iniFileName;
        if ((options & 1) == 1) {
            return this.loadFromDisk();
        }
        this.masterList = new Hashtable();
        return false;
    }

    public boolean load() {
        return this.loadFromDisk();
    }

    public void save() {
        this.saveToDisk();
    }

    public Boolean getIniBoolean(String sectionname, String keyname, Boolean defaultvalue) {
        Boolean result = defaultvalue;
        String data = this.getProfileData(sectionname, keyname);
        if (data != null) {
            try {
                result = Boolean.valueOf(data);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public Integer getIniInteger(String sectionname, String keyname, Integer defaultvalue) {
        Integer result = defaultvalue;
        String data = this.getProfileData(sectionname, keyname);
        if (data != null) {
            try {
                result = new Integer(data);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public void removeKey(String sectionname, String keyname) {
        this.removeProfileData(sectionname, keyname);
    }

    public String getIniString(String sectionname, String keyname, String defaultvalue) {
        String result = defaultvalue;
        String data = this.getProfileData(sectionname, keyname);
        if (data != null) {
            result = data;
        }
        return result;
    }

    public void setIniBoolean(String sectionname, String keyname, Boolean value) {
        this.setProfileData(sectionname, keyname, value == null ? null : value.toString());
    }

    public void setIniInteger(String sectionname, String keyname, Integer value) {
        this.setProfileData(sectionname, keyname, value == null ? null : value.toString());
    }

    public void setIniString(String sectionname, String keyname, String value) {
        this.setProfileData(sectionname, keyname, value);
    }

    private String getProfileData(String sectionname, String keyname) {
        String result = this.masterList.get(String.valueOf(sectionname) + "." + keyname);
        if (result != null && result.equals(NULL_VALUE)) {
            result = null;
        }
        return result;
    }

    private void removeProfileData(String sectionname, String keyname) {
        this.masterList.remove(String.valueOf(sectionname) + "." + keyname);
    }

    private void setProfileData(String sectionname, String keyname, String value) {
        this.removeProfileData(sectionname, keyname);
        this.masterList.put(String.valueOf(sectionname) + "." + keyname, value == null ? NULL_VALUE : value);
    }

    private boolean loadFromDisk() {
        BufferedReader br;
        this.masterList = new Hashtable();
        if (this.iniFileName == null) {
            return false;
        }
        try {
            br = new BufferedReader(new FileReader(this.iniFileName));
        }
        catch (Exception e) {
            return false;
        }
        int brace = 0;
        int endbrace = 0;
        int equaloffset = 0;
        String sectionname = null;
        String line = null;
        do {
            try {
                line = br.readLine();
                if (line == null || line.length() <= 0) continue;
                line = line.trim();
                brace = line.indexOf("[");
                endbrace = line.indexOf("]");
                equaloffset = line.indexOf("=");
                if (brace >= 0 && endbrace >= 0 && endbrace > brace) {
                    sectionname = line.substring(brace + 1, endbrace).trim();
                    continue;
                }
                if (equaloffset <= 0) continue;
                this.masterList.put(String.valueOf(sectionname) + "." + line.substring(0, equaloffset).trim(), line.substring(equaloffset + 1).trim());
            }
            catch (Exception e) {
                line = null;
            }
        } while (line != null);
        return true;
    }

    private void saveToDisk() {
        int dot;
        BufferedWriter bw;
        if (this.iniFileName == null || this.masterList == null || this.masterList.isEmpty()) {
            return;
        }
        try {
            bw = new BufferedWriter(new FileWriter(this.iniFileName));
        }
        catch (Exception e) {
            return;
        }
        String sectionname = null;
        String sectionnamework = null;
        Object[] index = new String[this.masterList.size()];
        Object[] value = new String[this.masterList.size()];
        Enumeration<String> in = this.masterList.keys();
        int longestIndex = 0;
        int i = 0;
        while (i < this.masterList.size()) {
            index[i] = in.nextElement().trim();
            value[i] = this.masterList.get(index[i]).trim();
            dot = ((String)index[i]).indexOf(".");
            if (((String)index[i]).length() - dot > longestIndex) {
                longestIndex = ((String)index[i]).length() - dot;
            }
            ++i;
        }
        Sorter.sort(index, value);
        StringBuffer filler = new StringBuffer(longestIndex);
        filler.setLength(longestIndex);
        int i2 = 0;
        while (i2 < longestIndex) {
            filler.setCharAt(i2, ' ');
            ++i2;
        }
        try {
            i2 = 0;
            while (i2 < this.masterList.size()) {
                dot = ((String)index[i2]).indexOf(".");
                sectionnamework = ((String)index[i2]).substring(0, dot);
                if (sectionname == null || sectionname.compareTo(sectionnamework) != 0) {
                    if (sectionname != null) {
                        bw.write(System.getProperty("line.separator"));
                    }
                    sectionname = sectionnamework;
                    bw.write("[" + sectionname + "]" + System.getProperty("line.separator"));
                }
                bw.write(String.valueOf(((String)index[i2]).substring(dot + 1)) + filler.substring(((String)index[i2]).length() - dot) + " = " + (String)value[i2] + System.getProperty("line.separator"));
                ++i2;
            }
        }
        catch (Exception e) {
            System.err.println("exception=" + e);
        }
        try {
            bw.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

