/*
 * Decompiled with CFR 0.152.
 */
package doc;

import comm.IOHandler;
import comm.TCreateObject;
import comm.TDestroyObject;
import comm.TInvokeMethod;
import comm.TMenu;
import comm.TUpdateLangId;
import comm.msg.MApp;
import comm.msg.MBox;
import comm.msg.MBtn;
import comm.msg.MButton;
import comm.msg.MDisplay;
import comm.msg.MDisplayMessage;
import comm.msg.MField;
import comm.msg.MFile;
import comm.msg.MFld;
import comm.msg.MGuiEditCmd;
import comm.msg.MKeymap;
import comm.msg.MMenu;
import comm.msg.MMnu;
import comm.msg.MRCBlock;
import comm.msg.MToken;
import debug.AppxDebug;
import doc.AppxExtension;
import doc.AppxToolkit;
import doc.Globals;
import doc.ResourceCache;
import doc.Sorter;
import doc.TokenCache;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.SwingUtilities;
import view.AppxControl;
import view.CharView;
import view.Display;

public final class Document {
    public static final String what_str = "@(#)Appx $Header: /src/cvs/joe/doc/Document.java,v 1.1.2.49 2015/05/13 17:03:15 pete Exp $";
    public static final int OPT_BASE = 256;
    public static final int OPT_SCAN = 257;
    public static final int OPT_SLCT_KEY = 259;
    public static final int OPT_PREV_IMG = 260;
    public static final int OPT_NXT_REC = 261;
    public static final int OPT_REDISPLAY = 262;
    public static final int OPT_SPLIT = 263;
    public static final int OPT_END_PARAG = 264;
    public static final int OPT_ADD_MODE = 265;
    public static final int OPT_DEL_MODE = 266;
    public static final int OPT_INQ_MODE = 267;
    public static final int OPT_CHG_MODE = 268;
    public static final int OPT_REDSPL_TXT = 269;
    public static final int OPT_SET_ATR = 271;
    public static final int OPT_DIR_PROC_1 = 272;
    public static final int OPT_DIR_PROC_2 = 273;
    public static final int OPT_END = 274;
    public static final int OPT_HELP_ITM = 276;
    public static final int OPT_PRT_SCR = 277;
    public static final int OPT_CAN = 278;
    public static final int OPT_SHOW_MSG = 279;
    public static final int OPT_HELP_OPT = 280;
    public static final int OPT_ENTER = 304;
    public static final int OPT_ACK_DEL = 305;
    public static final int OPT_SCROLL_FIRST = 320;
    public static final int OPT_SCROLL_LAST = 321;
    public static final int OPT_SCROLL_PREV = 322;
    public static final int OPT_SCROLL_NXT = 323;
    public static final int OPT_SCROLL_UP = 324;
    public static final int OPT_SCROLL_DOWN = 325;
    public static final int OPT_JOIN = 329;
    public static final int OPT_TIMEOUT = 330;
    public static final int OPT_TAB_IN = 331;
    public static final int OPT_TAB_OUT = 332;
    public static final int OPT_VALUE_CHANGED = 333;
    public static final int OPT_CHANGED_TABOUT = 334;
    public static final int OPT_DROP = 335;
    public static final int OPT_DLU_ON_TABOUT = 336;
    public static final int OPT_DLU_AND_TABOUT = 337;
    public static final int OPT_DLU_CHG_TABOUT = 338;
    public static final int OPT_DLU_AND_VALCHG = 339;
    public static final int OPT_COMM_TIMEOUT = 340;
    public static final int OPT_PAN_BASE = 10000;
    public static final int OPT_PAN_TOP = 10000;
    public static final int OPT_PAN_BOT = 10001;
    public static final int OPT_PAN_L_MARGIN = 10002;
    public static final int OPT_PAN_R_MARGIN = 10003;
    public static final int OPT_PAN_UP_1 = 10004;
    public static final int OPT_PAN_UP_SCR = 10005;
    public static final int OPT_PAN_DOWN_1 = 10006;
    public static final int OPT_PAN_DOWN_SCR = 10007;
    public static final int OPT_PAN_L_1 = 10008;
    public static final int OPT_PAN_L_SCR = 10009;
    public static final int OPT_PAN_R_1 = 10010;
    public static final int OPT_PAN_R_SCR = 10011;
    public static final int OPT_FIND_PATTERN = 10012;
    public static final int OPT_PAN_MAX = 10012;
    public static final int OPT_SYS_BASE = 20000;
    public static final int OPT_TAB = 20000;
    public static final int OPT_BACK_TAB = 20001;
    public static final int OPT_UP = 20002;
    public static final int OPT_DOWN = 20003;
    public static final int OPT_L = 20004;
    public static final int OPT_R = 20005;
    public static final int OPT_INSERT = 20006;
    public static final int OPT_DEL_PREV_C = 20007;
    public static final int OPT_DEL_BEG_ITM = 20008;
    public static final int OPT_DEL_END_ITM = 20009;
    public static final int OPT_MOVE_BEG_ITM = 20010;
    public static final int OPT_MOVE_END_ITM = 20011;
    public static final int OPT_REDRAW_LINE = 20012;
    public static final int OPT_REDRAW_SCR = 20013;
    public static final int OPT_DEL_CUR_C = 20014;
    public static final int OPT_CUT = 20015;
    public static final int OPT_PASTE = 20016;
    public static final int OPT_GO_ADD = 20017;
    public static final int OPT_GO_INQ = 20018;
    public static final int OPT_GO_CHG = 20019;
    public static final int OPT_MACRO = 20020;
    public static final int OPT_HOME = 20025;
    public static final int OPT_NXT_LINE = 20026;
    public static final int OPT_COPY = 20027;
    public static final int OPT_SELECT = 20028;
    public static final int OPT_SELECT_ALL = 20029;
    public static final int OPT_PRINT_SETUP = 20030;
    public static final int OPT_ABOUT = 20031;
    public static final int OPT_SESSION_PROPS = 20032;
    public static final int OPT_WHATS_THIS = 20033;
    public static final int OPT_DELETE = 20034;
    public static final int OPT_ARROW_TOOL = 20040;
    public static final int OPT_BUTTON_TOOL = 20041;
    public static final int OPT_LABEL_TOOL = 20042;
    public static final int OPT_PICTURE_TOOL = 20043;
    public static final int OPT_BOX_TOOL = 20044;
    public static final int OPT_LINE_TOOL = 20045;
    public static final int OPT_TABLE_TOOL = 20046;
    public static final int OPT_SHOW_BOUNDS = 20060;
    public static final int OPT_DATA_PALETTE = 20061;
    public static final int OPT_OBJECT_PROPS = 20062;
    public static final int OPT_WINDOW_PROPS = 20063;
    public static final int OPT_ALIGN_TOP = 20064;
    public static final int OPT_ALIGN_BOTTOM = 20065;
    public static final int OPT_ALIGN_LEFT = 20066;
    public static final int OPT_ALIGN_RIGHT = 20067;
    public static final int OPT_SAME_SIZE_VERT = 20068;
    public static final int OPT_SAME_SIZE_HORIZ = 20069;
    public static final int OPT_NEW_GUIDE_VERT = 20070;
    public static final int OPT_NEW_GUIDE_HORIZ = 20071;
    public static final int OPT_SPREAD_HORIZ = 20072;
    public static final int OPT_SPREAD_VERT = 20073;
    public static final int OPT_GUI_INTERFACE = 20101;
    public static final int OPT_SHOW_OPT_NUMS = 20102;
    public static final int OPT_AUTO_TAB_OUT = 20103;
    public static final int OPT_AUTO_SELECT = 20104;
    public static final int OPT_DOCKING_SCROLLB = 20105;
    public static final int OPT_SHOW_GRIDLINES = 20106;
    public static final int OPT_GUI_BASE = 21000;
    public static final int OPT_DATE_CHOOSER = 21000;
    public static final int OPT_COLOR_CHOOSER = 21001;
    public static final int OPT_FILE_CHOOSER = 21002;
    public static final int OPT_KEY_ENTRY = 21003;
    public static final int OPT_PACK_DISPLAY = 21004;
    public static final int OPT_NEW_INSTANCE = 21005;
    public static final int OPT_NULL = 65535;
    public static final long CHR_NONE = 0L;
    public static final long CHR_ED = 1L;
    public static final long CHR_ED_BASE = 3L;
    public static final long CHR_TAB = 4L;
    public static final long CHR_TAB_BASE = 12L;
    public static final long CHR_INVIS = 16L;
    public static final long CHR_INVIS_BASE = 48L;
    public static final long CHR_BRIGHT = 64L;
    public static final long CHR_BOLD = 64L;
    public static final long CHR_REVERSE = 128L;
    public static final long CHR_ULINE = 256L;
    public static final long CHR_BLINK = 512L;
    public static final long CHR_UCS = 1024L;
    public static final long CHR_NUM = 2048L;
    public static final long CHR_PSEUDO = 4096L;
    public static final long CHR_PSEUDO_BASE = 12288L;
    public static final long CHR_XPND = 16384L;
    public static final long CHR_PRT_PSEUDO = 32768L;
    public static final long CHR_SCROLL = 65536L;
    public static final long CHR_SCROLL_REG = 131072L;
    public static final long CHR_SCROLL_ACT = 262144L;
    public static final long CHR_SCANNABLE = 524288L;
    public static final long CHR_PICTURE = 0x100000L;
    public static final long CHR_BORD_LINEDRAW = 0x200000L;
    public static final long CHR_BORD_BOX = 0x8000000L;
    public static final long CHR_BORD_OLINE = 0x10000000L;
    public static final long CHR_BORD_ULINE = 0x20000000L;
    public static final long CHR_BORD_OBS = 0x40000000L;
    public static final long CHR_BORD_AROUND = 0x80000000L;
    public static final long CHR_COLOR_FG = 0xF000000000L;
    public static final long CHR_COLOR_BG = 0xF00000000L;
    public static final long CHR_NULL_OK = 0x800000000000000L;
    public static final long CHR_NULL_OK_NO = 0L;
    public static final long CHR_NULL_OK_YES = 0x800000000000000L;
    public static final long CHR_ELEM_DEFINED = -1152921504606846976L;
    public static final long CHR_ELEM_NONE = 0L;
    public static final long CHR_ELEM_ALP_CONT = 0x1000000000000000L;
    public static final long CHR_ELEM_ALP_NCON = 0x2000000000000000L;
    public static final long CHR_ELEM_ALP_JDAT = 0x3000000000000000L;
    public static final long CHR_ELEM_ALP_GDAT = 0x4000000000000000L;
    public static final long CHR_ELEM_BIN = 0x5000000000000000L;
    public static final long CHR_ELEM_BIN_JDAT = 0x6000000000000000L;
    public static final long CHR_ELEM_BIN_GDAT = 0x7000000000000000L;
    public static final long CHR_ELEM_PD_FIXED = Long.MIN_VALUE;
    public static final long CHR_ELEM_PD_JDATE = -8070450532247928832L;
    public static final long CHR_ELEM_PD_GDATE = -6917529027641081856L;
    public static final long CHR_ELEM_LOG = -5764607523034234880L;
    public static final long CHR_ELEM_PD_VAR = -4611686018427387904L;
    public static final long CHR_ELEM_ALP_SUBS = -3458764513820540928L;
    public static final long CHR_ELEM_ALP_COMP = -2305843009213693952L;
    public static final long CHR_ELEM_UNV_DATE = -1152921504606846976L;
    public static final long TABABLE = 12L;
    public static final long EDITABLE = 3L;
    public static final long PSEUDO = 12288L;
    public static final long INVISABLE = 48L;
    public static final long CHR_LINE_LOWERED = 0x200000L;
    public static final long CHR_LINE_RAISED = 0x200040L;
    public static final long CHR_LINE_TYPE_LINE = 0x200000L;
    public static final long CHR_LINE_TYPE_ETCH = 0x200080L;
    public static final long CHR_LINE_TYPE_BEVEL = 0x204000L;
    public static final long CHR_LINE_TYPE_SOFTBEVEL = 2113664L;
    public static final int BORDER_STYLE_NONE = 5;
    public static final int BORDER_STYLE_SIMPLE_LINE = 10;
    public static final int BORDER_STYLE_SIMPLE_LINE_WIDER = 20;
    public static final int BORDER_STYLE_ETCHED_SUNKEN = 30;
    public static final int BORDER_STYLE_ETCHED_RAISED = 40;
    public static final int BORDER_STYLE_BEVEL_SUNKEN = 50;
    public static final int BORDER_STYLE_BEVEL_RAISED = 60;
    public static final int BORDER_STYLE_SOFT_BEVEL_SUNKEN = 70;
    public static final int BORDER_STYLE_SOFT_BEVEL_RAISED = 80;
    public static final int BORDER_STYLE_IMAGE_EDITOR = 90;
    public static final int BORDER_STYLE_MAX = 90;
    public static final int CLIPTYPE_UNKNOWN = 0;
    public static final int CLIPTYPE_TEXT = 1;
    public static final int PROCESS_TYPE_NULL = -1;
    public static final int PROCESS_TYPE_MENU = 1;
    public static final int PROCESS_TYPE_INPUT = 2;
    public static final int PROCESS_TYPE_OUTPUT = 3;
    public static final int PROCESS_TYPE_ACTION = 4;
    public static final int PROCESS_TYPE_QUERY = 5;
    public static final int PROCESS_TYPE_SUBROUTINE = 6;
    public static final int PROCESS_TYPE_UPDATE = 7;
    public static final int PROCESS_TYPE_JOB = 8;
    public static final int PROCESS_TYPE_INQUIRY = 9;
    public static final int PROCESS_TYPE_STATUS = 10;
    public static final int PROCESS_TYPE_DISPOSITION = 11;
    public static final int PROCESS_TYPE_FILE = 12;
    public static final int FRAME_CLASS_NULL = -1;
    public static final int FRAME_CLASS_RECORD = 0;
    public static final int FRAME_CLASS_RANGE_BEGIN = 1;
    public static final int FRAME_CLASS_RANGE_END = 2;
    public static final int FRAME_CLASS_PAGE_BEGIN = 3;
    public static final int FRAME_CLASS_PAGE_END = 4;
    public static final int FRAME_CLASS_REPORT_BEGIN = 5;
    public static final int FRAME_CLASS_REPORT_END = 6;
    public static final int FRAME_CLASS_SORT = 7;
    public static final int FRAME_CLASS_SELECT_DISPLAY = 8;
    public static final int FRAME_CLASS_SELECT_HIDE = 9;
    public static final int FRAME_CLASS_GENERATED_PAGE_HEADING = 10;
    public static final int FRAME_CLASS_GENERATED_COLUMN_HEADING = 11;
    public static final int FRAME_CLASS_GENERATED_REPORT_HEADING = 13;
    public static final int FRAME_CLASS_KEY_ENTRY = 14;
    private boolean serverInterrupt = false;
    private static Document currentDocument;
    public TUpdateLangId langId;
    public String userId;
    public String dataBase;
    public String applId;
    public String currMode;
    public String statusMessage;
    public byte[][] screen;
    public byte[][] cache;
    public byte[][] Schanges;
    public byte[][] boxmap;
    public long[][] attributes;
    public static Dimension sizMax;
    public static Dimension sizMin;
    public static Dimension siz;
    public MDisplay display;
    public MButton button;
    public boolean finish = false;
    public Hashtable<String, MKeymap> keymap;
    private static boolean locked;
    public Vector<Object> userObjects = new Vector();
    public static final Object syncLock;
    private IOHandler io;
    private CharView view;
    private String procId;
    private Vector<MFld> fields = new Vector();
    private int userIdP = 0;
    private int dataBaseP = 0;
    private int applIdP = 0;
    private int currModeP = 0;
    private AppxExtension objectWithFocus;
    private Vector<MBox> boxList = new Vector();
    private Vector<MBtn> btnList = new Vector();
    private Vector<TMenu> menuList = new Vector();
    private Hashtable<Integer, TMenu> menuListSave = new Hashtable();
    private TokenCache tokenCache;
    private ResourceCache resourceCache;
    private int forceFeatureMask = 0;
    private static boolean processingClipboard;
    private Hashtable<Integer, String> pcbList = null;
    private static boolean gotTimeout;
    Object return_data;

    static {
        locked = false;
        syncLock = "syncLock";
        processingClipboard = false;
        gotTimeout = false;
    }

    public boolean isServerInterrupt() {
        return this.serverInterrupt;
    }

    public void setServerInterrupt(boolean serverInterrupt) {
        this.serverInterrupt = serverInterrupt;
    }

    public final void dumpScreen() {
        int row = 0;
        while (row < Document.siz.height) {
            String s = new String(this.screen[row]);
            System.err.println(s);
            ++row;
        }
    }

    public static final void setGotTimeout(boolean state) {
        gotTimeout = state;
    }

    public static final boolean isGotTimeout() {
        return gotTimeout;
    }

    public static final void setLocked(boolean state) {
        if (Globals.getOptionValueBoolean("showTypeaheadLog")) {
            AppxDebug.log("Document.setLocked() new value=" + state);
        }
        if (CharView.view != null && locked != state) {
            if (state) {
                CharView.view.setStatusState(2);
            } else if (currentDocument != null && Document.currentDocument.currMode != null && Document.currentDocument.currMode.indexOf(42) > 0) {
                CharView.view.setStatusState(1);
            } else {
                CharView.view.setStatusState(0);
            }
        }
        locked = state;
    }

    public static final boolean isLocked() {
        return locked;
    }

    public void addField(Vector<MFld> fldList) {
        this.fields = fldList;
    }

    public void addForceFeature(int featureMask) {
        this.forceFeatureMask |= featureMask;
    }

    public void addImageItem(String ap, String fld, int r, int c) {
        this.io.addImageItem(ap, fld, r, c);
    }

    public void addLongData(int row, int col, byte[] value) {
        this.io.addLongData(row, col, value);
    }

    public void addLongData(int row, int col, String value) {
        this.io.addLongData(row, col, value);
    }

    public void addMenu(TMenu menu) {
        Object m;
        MMnu mnu;
        if (menu == null) {
            return;
        }
        Integer menuType = new Integer(menu.getMenuType());
        if (menu.getMenuUse()) {
            menu = this.menuListSave.get(menuType);
            if (menu == null) {
                return;
            }
        } else {
            this.menuListSave.remove(menuType);
            this.menuListSave.put(menuType, menu);
        }
        TMenu workMenu = menu.duplicate();
        if (Globals.getOptionValueBoolean("newPulldownMenus")) {
            this.adjustMenuLabelsAndGroupNames(workMenu);
        }
        Hashtable<String, TMenu> newMenus = new Hashtable<String, TMenu>();
        Enumeration<MMnu> menuItems = workMenu.getMenuItems();
        while (menuItems != null && menuItems.hasMoreElements()) {
            mnu = menuItems.nextElement();
            if (mnu == null || mnu.widgetData == null || mnu.widgetData.wGroupName == null) continue;
            TMenu newMenu = (TMenu)newMenus.get(mnu.widgetData.wGroupName.toLowerCase().trim());
            if (newMenu == null) {
                newMenu = new TMenu();
                newMenu.menu = new MMenu();
                newMenu.menu.mnuBlock = new Vector();
                newMenu.menu.menuLabel = mnu.widgetData.wGroupName;
                newMenus.put(mnu.widgetData.wGroupName.toLowerCase().trim(), newMenu);
                if (menu.menu.getMenuCommand() == null) {
                    newMenu.menu.setMenuCommand("0" + mnu.widgetData.wCommand);
                } else {
                    newMenu.menu.setMenuCommand(menu.menu.getMenuCommand());
                }
            }
            mnu.parent = newMenu;
        }
        menuItems = workMenu.getMenuItems();
        while (menuItems != null && menuItems.hasMoreElements()) {
            int offset;
            mnu = menuItems.nextElement();
            m = mnu.widgetData.wLabel == null ? (TMenu[])newMenus.get("") : (TMenu)newMenus.get(mnu.widgetData.wLabel.toLowerCase().trim());
            if (m != null) {
                m.tmenuMnu = mnu;
                mnu.definesTMenu = m;
            }
            if (mnu != null && mnu.parent != null && mnu.parent.menu != null) {
                mnu.parent.menu.mnuBlock.addElement(mnu);
            }
            if (!Globals.getOptionValueBoolean("newPulldownMenus")) continue;
            if (mnu.widgetData != null && mnu.widgetData.wLabel != null && mnu.widgetData.wLabel.indexOf(58) >= 0 && (offset = mnu.widgetData.wLabel.indexOf(58)) < 6) {
                mnu.widgetData.wLabel = mnu.widgetData.wLabel.substring(offset + 1);
            }
            if (mnu.widgetData == null || mnu.widgetData.wGroupName == null || mnu.widgetData.wGroupName.indexOf(58) < 0 || (offset = mnu.widgetData.wGroupName.indexOf(58)) >= 6) continue;
            mnu.widgetData.wGroupName = mnu.widgetData.wGroupName.substring(offset + 1);
        }
        Enumeration newMenuList = newMenus.elements();
        while (newMenuList != null && newMenuList.hasMoreElements()) {
            TMenu newMenuElement = (TMenu)newMenuList.nextElement();
            if (newMenuElement.tmenuMnu != null) {
                workMenu.menu.mnuBlock.removeElement(newMenuElement.tmenuMnu);
            }
            menuItems = newMenuElement.getMenuItems();
            while (menuItems != null && menuItems.hasMoreElements()) {
                MMnu mnu2 = menuItems.nextElement();
                if (mnu2 == null) continue;
                workMenu.menu.mnuBlock.removeElement(mnu2);
            }
        }
        if (workMenu.menu.mnuBlock.size() > 0) {
            this.menuList.addElement(workMenu);
        }
        newMenuList = newMenus.elements();
        m = new TMenu[newMenus.size()];
        int off = 0;
        while (newMenuList != null && newMenuList.hasMoreElements()) {
            TMenu tm = (TMenu)newMenuList.nextElement();
            try {
                Integer.parseInt(tm.getMenuCommand());
                m[off++] = tm;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Sorter.sort(m, 0, off - 1, true, new Sorter.Comparer(){

            @Override
            public int compare(Object a, Object b) {
                try {
                    return Integer.parseInt(((TMenu)a).getMenuCommand()) - Integer.parseInt(((TMenu)b).getMenuCommand());
                }
                catch (Exception exception) {
                    return 0;
                }
            }
        });
        int i = 0;
        while (i < off) {
            this.menuList.addElement((TMenu)m[i]);
            ++i;
        }
    }

    private void adjustMenuLabelsAndGroupNames(TMenu workMenu) {
        Integer workInt;
        int indexFnd;
        int indexCur;
        int indexMax;
        LinkedList workList;
        Integer workCommand;
        String workMenuName;
        MMnu mnu;
        Hashtable<String, LinkedList> workNames = new Hashtable<String, LinkedList>();
        Enumeration<MMnu> menuItems = workMenu.getMenuItems();
        while (menuItems != null && menuItems.hasMoreElements()) {
            mnu = menuItems.nextElement();
            if (mnu == null || mnu.widgetData == null || mnu.widgetData.wGroupName == null) continue;
            workMenuName = mnu.widgetData.wGroupName;
            workMenuName.intern();
            workCommand = mnu.widgetData.wCommand == null ? new Integer(0) : new Integer(mnu.widgetData.wCommand);
            workList = (LinkedList)workNames.get(workMenuName);
            if (workList != null) continue;
            workList = new LinkedList();
            workNames.put(workMenuName, workList);
        }
        menuItems = workMenu.getMenuItems();
        while (menuItems != null && menuItems.hasMoreElements()) {
            mnu = menuItems.nextElement();
            if (mnu == null || mnu.widgetData == null || mnu.widgetData.wLabel == null) continue;
            workMenuName = mnu.widgetData.wLabel;
            workMenuName.intern();
            workCommand = new Integer(mnu.widgetData.wCommand == null ? "0" : mnu.widgetData.wCommand);
            workList = (LinkedList)workNames.get(workMenuName);
            if (workList == null) continue;
            indexMax = workList.size();
            indexCur = 0;
            indexFnd = -1;
            while (indexCur < indexMax && indexFnd < 0) {
                workInt = (Integer)workList.get(indexCur);
                if (workInt.intValue() == workCommand.intValue()) {
                    indexFnd = indexCur;
                    continue;
                }
                if (workInt > workCommand) {
                    workList.add(indexCur, workCommand);
                    indexFnd = indexCur;
                    continue;
                }
                ++indexCur;
            }
            if (indexFnd < 0) {
                workList.add(workCommand);
                indexFnd = indexMax;
            }
            mnu.widgetData.wLabel = workCommand + ":" + workMenuName;
            workCommand = null;
        }
        menuItems = workMenu.getMenuItems();
        while (menuItems != null && menuItems.hasMoreElements()) {
            mnu = menuItems.nextElement();
            if (mnu == null || mnu.widgetData == null || mnu.widgetData.wGroupName == null) continue;
            workMenuName = mnu.widgetData.wGroupName;
            workMenuName.intern();
            workCommand = new Integer(mnu.widgetData.wCommand == null ? "0" : mnu.widgetData.wCommand);
            workList = (LinkedList)workNames.get(workMenuName);
            if (workList == null) continue;
            indexMax = workList.size();
            indexCur = 0;
            indexFnd = -1;
            while (indexCur < indexMax) {
                workInt = (Integer)workList.get(indexCur);
                if (workInt <= workCommand) {
                    indexFnd = indexCur;
                }
                ++indexCur;
            }
            if (indexFnd < 0 && workList.size() > 0) {
                indexFnd = 0;
            }
            if (indexFnd < 0) continue;
            workInt = (Integer)workList.get(indexFnd);
            mnu.widgetData.wGroupName = workInt + ":" + workMenuName;
        }
    }

    private int cacheUserObject(Object obj) {
        int index = -1;
        int i = 0;
        while (i < this.userObjects.size()) {
            Object tmpObj = this.userObjects.elementAt(i);
            if (tmpObj == null) {
                index = i + 1;
                this.userObjects.setElementAt(obj, i);
            }
            ++i;
        }
        if (index == -1) {
            this.userObjects.addElement(obj);
            index = this.userObjects.size();
        }
        return index;
    }

    private void calcFooterPointer() {
        int c = 0;
        while (c < Document.sizMax.width) {
            if (this.screen[Document.sizMax.height - 3][c] == 58) {
                if (this.dataBaseP == 0) {
                    this.dataBaseP = c + 2;
                } else if (this.applIdP == 0) {
                    this.applIdP = c + 2;
                } else if (this.userIdP == 0) {
                    this.userIdP = c + 2;
                }
            }
            ++c;
        }
        this.currModeP = Document.sizMax.width - 9;
    }

    public boolean checkForFeature(int featureMask) {
        if ((featureMask & this.forceFeatureMask) == featureMask) {
            return true;
        }
        if (this.io == null) {
            return (featureMask & 0xFFFFFFFB) == featureMask;
        }
        return this.io.checkForFeature(featureMask);
    }

    public void createLocalObject(TCreateObject obj) {
        int argCount = obj.getArgCount();
        Class[] argsClass = new Class[argCount];
        Object[] args = new Object[argCount];
        int i = 0;
        while (i < argCount) {
            argsClass[i] = obj.getClass(i);
            args[i] = obj.getArgument(i);
            ++i;
        }
        try {
            String className = obj.getClassName();
            Class<?> objectDefinition = Class.forName(className);
            Constructor<Object> argsConstructor = objectDefinition.getConstructor(argsClass);
            Object object = Document.createObject(argsConstructor, args);
            int handle = this.cacheUserObject(object);
            obj.setReturnHandle(handle);
            ((AppxExtension)object).setHandle(handle);
            ((AppxExtension)object).setDocument(this);
        }
        catch (ClassNotFoundException e) {
            obj.setReturnError(3);
            System.out.println(e);
        }
        catch (NoSuchMethodException e) {
            obj.setReturnError(4);
            System.out.println(e);
        }
    }

    public static Object createObject(Constructor<Object> constructor, Object[] arguments) {
        Object object = null;
        try {
            object = constructor.newInstance(arguments);
            return object;
        }
        catch (InstantiationException e) {
            System.out.println(e);
        }
        catch (IllegalAccessException e) {
            System.out.println(e);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e);
        }
        catch (InvocationTargetException e) {
            System.out.println(e);
        }
        return object;
    }

    private static String decodeBit(long bits, long bitMask, String desc) {
        if ((bits & bitMask) == bitMask) {
            return String.valueOf(desc) + " ";
        }
        return "    ";
    }

    public static String decodeChrBitsBoxes(long bits) {
        String result = "";
        result = String.valueOf(result) + Document.decodeBit(bits, 65536L, "SCR");
        result = String.valueOf(result) + Document.decodeBit(bits, 131072L, "REG");
        result = String.valueOf(result) + Document.decodeBit(bits, 262144L, "ACT");
        result = String.valueOf(result) + Document.decodeBit(bits, 0x200000L, "DRW");
        result = String.valueOf(result) + Document.decodeBit(bits, 0x8000000L, "BOX");
        result = String.valueOf(result) + Document.decodeBit(bits, 0x10000000L, "BOL");
        result = String.valueOf(result) + Document.decodeBit(bits, 0x20000000L, "BUL");
        result = String.valueOf(result) + Document.decodeBit(bits, 0x40000000L, "OBS");
        result = String.valueOf(result) + Document.decodeBit(bits, 0x80000000L, "ARN");
        return result;
    }

    public static String decodeChrBitsFull(long bits) {
        String result = "";
        result = String.valueOf(result) + Document.decodeBit(bits, 2L, "E_B");
        result = String.valueOf(result) + Document.decodeBit(bits, 4L, "TAB");
        result = String.valueOf(result) + Document.decodeBit(bits, 8L, "T_B");
        result = String.valueOf(result) + Document.decodeBit(bits, 16L, "INV");
        result = String.valueOf(result) + Document.decodeBit(bits, 32L, "I_B");
        result = String.valueOf(result) + Document.decodeBit(bits, 64L, "BLD");
        result = String.valueOf(result) + Document.decodeBit(bits, 128L, "REV");
        result = String.valueOf(result) + Document.decodeBit(bits, 256L, "ULN");
        result = String.valueOf(result) + Document.decodeBit(bits, 512L, "BLN");
        result = String.valueOf(result) + Document.decodeBit(bits, 1024L, "UCS");
        result = String.valueOf(result) + Document.decodeBit(bits, 2048L, "NUM");
        result = String.valueOf(result) + Document.decodeBit(bits, 4096L, "PSB");
        result = String.valueOf(result) + Document.decodeBit(bits, 8192L, "P_B");
        result = String.valueOf(result) + Document.decodeBit(bits, 16384L, "XPN");
        result = String.valueOf(result) + Document.decodeBit(bits, 32768L, "PRT");
        result = String.valueOf(result) + Document.decodeBit(bits, 65536L, "SCR");
        result = String.valueOf(result) + Document.decodeBit(bits, 131072L, "REG");
        result = String.valueOf(result) + Document.decodeBit(bits, 262144L, "ACT");
        result = String.valueOf(result) + Document.decodeBit(bits, 524288L, "SCN");
        result = String.valueOf(result) + Document.decodeBit(bits, 0x100000L, "PIC");
        result = String.valueOf(result) + Document.decodeBit(bits, 0x200000L, "DRW");
        result = String.valueOf(result) + Document.decodeBit(bits, 0x8000000L, "BOX");
        result = String.valueOf(result) + Document.decodeBit(bits, 0x10000000L, "BOL");
        result = String.valueOf(result) + Document.decodeBit(bits, 0x20000000L, "BUL");
        result = String.valueOf(result) + Document.decodeBit(bits, 0x40000000L, "OBS");
        result = String.valueOf(result) + Document.decodeBit(bits, 0x80000000L, "ARN");
        result = String.valueOf(result) + Document.decodeBit(bits, 0x800000000000000L, "NOK");
        result = String.valueOf(result) + Document.decodeBit(bits, -1152921504606846976L, "EDF");
        return result;
    }

    public void deferEdit(int row, int col, int height, int width, int op) {
        this.io.deferEdit(row, col, height, width, op);
    }

    public void delForceFeature(int featureMask) {
        this.forceFeatureMask ^= featureMask;
    }

    public void destroyLocalObject(TDestroyObject obj) {
        Object object = this.getUserObject(obj.getHandle());
        ((AppxExtension)object).cleanup();
        this.uncacheUserObject(obj.getHandle());
        object = null;
    }

    public void event(short opt, int lostFocusCmd, int valueChangedCmd, AppxControl lostFocusCtl) {
        if (opt != 340) {
            this.display.status = 1;
            this.display.option = opt;
            this.display.optionAlt = 0;
            this.display.cursorAlt.row = -1;
            this.display.cursorAlt.column = -1;
            if (IOHandler.currentHandler.checkForFeature(0x40000000) && lostFocusCmd != 65535) {
                this.display.optionAlt = opt != 332 ? this.display.option : 0;
                this.display.cursorAlt.row = this.display.cursor.row;
                this.display.cursorAlt.column = this.display.cursor.column;
                this.display.option = lostFocusCmd;
                if ((this.display.option == 332 || this.display.option == 336 || this.display.option == 337) && lostFocusCtl != null && valueChangedCmd != 65535 && lostFocusCtl.isTouched()) {
                    switch (this.display.option) {
                        case 332: {
                            this.display.option = 334;
                            break;
                        }
                        case 336: {
                            this.display.option = 339;
                            break;
                        }
                        case 337: {
                            this.display.option = 338;
                        }
                    }
                }
                if (lostFocusCtl != null) {
                    this.display.cursor.row = lostFocusCtl.getCellBounds().y + CharView.topBox.getCellBounds().y;
                    this.display.cursor.column = lostFocusCtl.getCellBounds().x + CharView.topBox.getCellBounds().x;
                }
            }
            this.io.sendShow();
        }
        if (Globals.getOptionValueBoolean("newTypeaheadCode")) {
            this.io.serverLoop();
        }
    }

    public void event() {
        if (!this.view.readyForInput) {
            return;
        }
        this.io.sendShow();
    }

    private void filterBoxes() {
        MBox last = null;
        this.syncButtonsToBoxes();
        this.boxList.removeAllElements();
        this.btnList.removeAllElements();
        int i = this.display.boxBlock.size();
        while (i > 0) {
            MBox box = this.display.boxBlock.elementAt(i - 1);
            if (last != null && box.begin.equals(last.begin) && box.end.equals(last.end)) {
                if (last.widgetData.wWidgetType != null && last.widgetData.wWidgetType == 200) {
                    last.widgetData.wWidgetType = null;
                }
            } else {
                last = box;
                this.boxList.insertElementAt(box, 0);
                if (box.widgetData != null && box.widgetData.wWidgetType != null && box.widgetData.wWidgetType == 200) {
                    this.display.mode = (byte)(this.display.mode | 0x10);
                }
                if (this.button != null && this.button.btnBlock != null) {
                    Enumeration<MBtn> buttons = this.button.btnBlock.elements();
                    while (buttons.hasMoreElements()) {
                        MBtn btn = buttons.nextElement();
                        if (btn.box != box.boxId || btn.widgetData == null) continue;
                        this.btnList.addElement(btn);
                    }
                }
            }
            --i;
        }
    }

    public void fireObjectEvent(int handle, int return_code) {
        if (this.objectWithFocus != null) {
            this.io.fireObjectEvent(handle, return_code);
            this.objectWithFocus = null;
        }
    }

    public void fireObjectEvent() {
        if (this.objectWithFocus != null) {
            this.io.fireObjectEvent(this.objectWithFocus.getHandle(), this.objectWithFocus.getSelectedIndex());
            this.objectWithFocus = null;
        }
    }

    public void flushMemoryCache() {
        if (this.resourceCache != null) {
            this.resourceCache.flushMemoryCache();
        }
    }

    public void formatDate(int row, int col, byte[] rawDate) {
        this.io.formatDate(row, col, rawDate);
    }

    public void getAppList() {
        this.io.getAppList();
    }

    public long[] getAttributes(int l, int begin, int end) {
        if (l < 0) {
            l = 0;
        }
        if (l >= Document.sizMax.height) {
            l = Document.sizMax.height - 1;
        }
        if (begin < 0) {
            begin = 0;
        }
        if (begin >= Document.sizMax.width) {
            begin = Document.sizMax.width - 1;
        }
        if (end < 0) {
            end = 0;
        }
        if (end >= Document.sizMax.width) {
            end = Document.sizMax.width - 1;
        }
        if (end < begin) {
            int tmp = end;
            end = begin;
            begin = tmp;
        }
        long[] tmp = new long[end - begin + 1];
        System.arraycopy(this.attributes[l], begin, tmp, 0, end - begin + 1);
        return tmp;
    }

    public long[] getAttributes(int l, int begin) {
        return this.getAttributes(l, begin, Document.sizMax.width - 1);
    }

    public long[] getAttributes(int l) {
        return this.attributes[l];
    }

    public int getBoxCol(int idx) {
        int i = this.display.boxBlock.size();
        while (i > 0) {
            MBox box = this.display.boxBlock.elementAt(i - 1);
            if (box.boxId == idx) {
                return box.begin.column;
            }
            --i;
        }
        System.err.println("Document.getBoxCol(" + idx + ") Box Not Found in List");
        return 0;
    }

    public Enumeration<MBox> getBoxes() {
        return this.boxList.elements();
    }

    public int getBoxRow(int idx) {
        int i = this.display.boxBlock.size();
        while (i > 0) {
            MBox box = this.display.boxBlock.elementAt(i - 1);
            if (box.boxId == idx) {
                return box.begin.row;
            }
            --i;
        }
        System.err.println("Document.getBoxRow(" + idx + ") Box Not Found in List");
        return 0;
    }

    public Enumeration<MBtn> getButtons() {
        return this.btnList.elements();
    }

    public MRCBlock getCursorPos() {
        return this.display.cursor;
    }

    public void getFieldList(String app, String file) {
        this.io.getFieldList(app, file);
    }

    public Vector<MFld> getFields() {
        return this.fields;
    }

    public void getFileList(String app) {
        this.io.getFileList(app);
    }

    public void getFileList() {
        this.io.getAppList();
    }

    public Image getImageResource(String rawKey, float scaleWidth, float scaleHeight, char scaleType) {
        return this.resourceCache.getImageResource(this.view, rawKey, scaleWidth, scaleHeight, scaleType);
    }

    public IOHandler getIOHandler() {
        return this.io;
    }

    public byte[] getLine(int l) {
        return this.screen[l];
    }

    public byte[] getLine(int l, int begin) {
        return this.getLine(l, begin, Document.sizMax.width - 1);
    }

    public byte[] getLine(int l, int begin, int end) {
        if (l < 0) {
            l = 0;
        }
        if (l >= Document.sizMax.height) {
            l = Document.sizMax.height - 1;
        }
        if (begin < 0) {
            begin = 0;
        }
        if (begin >= Document.sizMax.width) {
            begin = Document.sizMax.width - 1;
        }
        if (end < 0) {
            end = 0;
        }
        if (end >= Document.sizMax.width) {
            end = Document.sizMax.width - 1;
        }
        if (end < begin) {
            int tmp = end;
            end = begin;
            begin = tmp;
        }
        byte[] tmp = new byte[end - begin + 1];
        System.arraycopy(this.screen[l], begin, tmp, 0, end - begin + 1);
        return tmp;
    }

    public Enumeration<TMenu> getMenus() {
        return this.menuList.elements();
    }

    public byte getMode() {
        return this.display.mode;
    }

    public String getProcId() {
        return this.procId;
    }

    public String getResource(String rawKey) {
        return this.resourceCache.getResource(rawKey);
    }

    public int getTimeout() {
        if (this.display.timeout < 0 || this.display.timeout > 60000) {
            return 0;
        }
        return this.display.timeout;
    }

    public int getTimeoutOption() {
        if (this.display.timeout_opt == 0) {
            return 272;
        }
        return this.display.timeout_opt;
    }

    public Object[] getTokenElementsArray(String ap, String ver, String id, String sig, int group) {
        return this.tokenCache.getTokenElementsArray(ap, ver, id, sig, group, this.langId.langId);
    }

    public Enumeration<Object> getTokenElements(String ap, String ver, String id, String sig, int group) {
        return this.tokenCache.getTokenElements(ap, ver, id, sig, group, this.langId.langId);
    }

    private Object getUserObject(int index) {
        return this.userObjects.elementAt(index - 1);
    }

    public Document(int width, int height) {
        this.localInit(width, height + 3);
        this.langId = new TUpdateLangId("   ", 'Y', 'y', 'N', 'n');
    }

    public void invokeLocalMethod(TInvokeMethod obj) {
        int argCount = obj.getArgCount();
        Class[] argsClass = new Class[argCount];
        final Object[] args = new Object[argCount];
        int i = 0;
        while (i < argCount) {
            argsClass[i] = obj.getClass(i);
            args[i] = obj.getArgument(i);
            ++i;
        }
        try {
            String methodName = obj.getMethodName();
            final Object objectDefinition = this.getUserObject(obj.getHandle());
            Class<?> classDefinition = objectDefinition.getClass();
            final Method methodDefinition = classDefinition.getMethod(methodName, argsClass);
            try {
                boolean isDocLocked = Document.isLocked();
                Document.setLocked(false);
                if (Globals.getOptionValueBoolean("newTypeaheadCode")) {
                    try {
                        this.return_data = methodDefinition.invoke(objectDefinition, args);
                    }
                    catch (Exception ex) {
                        System.err.println("Exception1=" + ex);
                    }
                } else {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Document.this.return_data = methodDefinition.invoke(objectDefinition, args);
                            }
                            catch (Exception ex) {
                                System.err.println("Exception1=" + ex);
                            }
                        }
                    });
                }
                Document.setLocked(isDocLocked);
            }
            catch (Exception exp) {
                System.err.println("Exception2=" + exp);
            }
            obj.setReturnError(0);
            if (this.return_data != null) {
                obj.setReturnArg(this.return_data);
            }
        }
        catch (NoSuchMethodException e) {
            obj.setReturnError(3);
            System.out.println(e);
        }
        catch (IllegalArgumentException e) {
            obj.setReturnError(3);
            System.out.println(e);
        }
    }

    public boolean isConnected() {
        if (this.io == null) {
            return false;
        }
        return this.io.connected();
    }

    public Document() {
        this.localInit(80, 24);
    }

    public void loadAppList(Vector<MApp> list) {
        this.view.loadAppList(list);
    }

    public void loadFieldList(Vector<MField> list) {
        this.view.loadFieldList(list);
    }

    public void loadDisplayMessages(Vector<MDisplayMessage> msgs) {
        this.view.loadDisplayMessages(msgs);
    }

    public void loadFileList(Vector<MFile> list) {
        this.view.loadFileList(list);
    }

    public void loadToken(MToken mToken) {
    }

    public void loadUrl(String url) {
        this.view.loadUrl(url);
    }

    private void localInit(int width, int height) {
        currentDocument = this;
        this.userObjects.removeAllElements();
        this.boxmap = new byte[height][width];
        this.screen = new byte[height][width];
        this.cache = new byte[height][width];
        this.Schanges = new byte[height][width];
        this.attributes = new long[height][width];
        sizMax = new Dimension(width, height);
        sizMin = new Dimension(width, height);
        siz = new Dimension(width, height);
        int c = 0;
        while (c < Document.sizMax.width) {
            int r = 0;
            while (r < Document.sizMax.height) {
                this.screen[r][c] = 32;
                ++r;
            }
            ++c;
        }
    }

    public Point lookupCursorPosition() {
        return new Point(this.display.cursor.column, this.display.cursor.row);
    }

    public Display lookupDisplay(int row, int col) {
        return this.view.lookupDisplay(row, col);
    }

    public Display lookupDisplay(Point p) {
        return this.view.lookupDisplay(p.y, p.x);
    }

    public Rectangle lookupFieldExtents(int row, int col) {
        Rectangle rect = null;
        Display disp = this.lookupDisplay(row, col);
        if (disp != null) {
            rect = disp.lookupFieldExtents(row, col);
        }
        return rect;
    }

    public Rectangle lookupFieldExtents(Point p) {
        Rectangle rect = null;
        Display disp = this.lookupDisplay(p.y, p.x);
        if (disp != null) {
            rect = disp.lookupFieldExtents(p.y, p.x);
        }
        return rect;
    }

    public Point lookupScanCursor() {
        return this.view.getScanCursor();
    }

    public Rectangle lookupScanField() {
        return this.view.getScanField();
    }

    public String lookupScreenText(int row, int col, int len) {
        return AppxToolkit.byteToString(this.getLine(row - 1, col - 1, col - 1 + len - 1), 2);
    }

    public void moveImageItem(int oldRow, int oldCol, int newRow, int newCol) {
        this.io.moveImageItem(oldRow, oldCol, newRow, newCol);
    }

    public void newMethod(MToken token) {
    }

    public void registerCharView(CharView cview) {
        this.view = cview;
    }

    public void registerIOHandler(IOHandler ioh) {
        this.io = ioh;
        this.tokenCache = new TokenCache(this.io, this);
        this.resourceCache = new ResourceCache(this.io, this);
    }

    public void resetMenus() {
        this.menuList.removeAllElements();
    }

    public void resizeImageItem(int oldRow, int oldCol, int newRow, int newCol, int newRows, int newCols) {
        this.io.resizeImageItem(oldRow, oldCol, newRow, newCol, newRows, newCols);
    }

    public void sendGuiEditCmd(MGuiEditCmd cmd) {
        this.io.sendGuiEditCmd(cmd);
    }

    public void sendShow() {
        this.io.sendShow();
    }

    public void setCharacter(int l, int c, byte ch) {
        this.setCursorPos(l, c);
        this.screen[l][c] = ch;
    }

    public void setCharacter(int l, int c, int ch) {
        this.setCharacter(l, c, (byte)ch);
    }

    public void setCursorPos(int l, int c) {
        this.display.cursor.row = l;
        this.display.cursor.column = c;
    }

    public void setField(int row, int col, String value) {
        this.view.setField(row, col, value);
    }

    public void setForceFeature(int featureMask) {
        this.forceFeatureMask = featureMask;
    }

    public void setProcId(String newValue) {
        this.procId = newValue;
        System.err.println("Server Process ID = " + this.procId);
        System.err.println("================================================================================");
    }

    public void setStatusText(String text) {
        this.view.setStatusText(text);
    }

    public void setUserObjectHasFocus(AppxExtension aex, boolean hasFocus) {
        this.objectWithFocus = aex;
        this.view.setUserObjectHasFocus(hasFocus);
    }

    public void setUserObjectHasFocus(boolean hasFocus) {
        this.objectWithFocus = null;
        this.view.setUserObjectHasFocus(hasFocus);
    }

    public Dimension size() {
        return sizMax;
    }

    private void syncButtonsToBoxes() {
        if (this.button != null && this.button.btnBlock != null) {
            Enumeration<MBtn> buttons = this.button.btnBlock.elements();
            while (buttons != null && buttons.hasMoreElements()) {
                int lastGoodIndex;
                MBtn b = buttons.nextElement();
                boolean notFound = true;
                int i = lastGoodIndex = this.display.boxBlock.size();
                while (i >= 0 && notFound) {
                    if (i < this.display.boxBlock.size()) {
                        MBox dBox = this.display.boxBlock.elementAt(i);
                        if (dBox.boxId <= b.box) {
                            b.box = dBox.boxId;
                            notFound = false;
                            lastGoodIndex = i;
                        }
                    }
                    --i;
                }
                if (!notFound) continue;
                b.box = (short)-1;
            }
        }
    }

    private void uncacheUserObject(int index) {
        this.userObjects.setElementAt(null, index - 1);
    }

    public void updateLangId(TUpdateLangId lang) {
        this.langId = lang;
    }

    public void update() {
        String msgStr;
        int beg = 0;
        int end = Document.sizMax.width - 1;
        int rowOffset = 2;
        if (this.currModeP == 0) {
            this.calcFooterPointer();
        } else if (this.screen[Document.sizMax.height - 1][0] == 75) {
            this.currMode = AppxToolkit.byteToString(this.screen[Document.sizMax.height - 1], this.currModeP, 7, 2);
        } else {
            this.currMode = "EM Cmpl";
            rowOffset = 1;
        }
        this.userId = AppxToolkit.byteToString(this.screen[Document.sizMax.height - 3], this.userIdP, 3, 2);
        this.dataBase = AppxToolkit.byteToString(this.screen[Document.sizMax.height - 3], this.dataBaseP, 3, 2);
        this.applId = AppxToolkit.byteToString(this.screen[Document.sizMax.height - 3], this.applIdP, 6, 2);
        this.statusMessage = CharView.stat_msg_fld == null ? ((msgStr = AppxToolkit.byteToString(this.screen[Document.sizMax.height - rowOffset], beg, end - beg + 1, 2).trim()) != null && msgStr.length() > 0 ? msgStr : null) : (CharView.stat_msg_fld.getDataLen() > 0 ? CharView.stat_msg_fld.getData().trim() : ((msgStr = AppxToolkit.byteToString(this.screen[Document.sizMax.height - rowOffset], beg, end - beg + 1, 2).trim()) != null && msgStr.length() > 0 ? msgStr : null));
        if ((this.attributes[0][0] & 0x3000L) == 12288L && (this.attributes[0][0] & 3L) != 3L || (this.attributes[0][0] & 0x3000L) != 12288L && (this.attributes[0][0] & 3L) == 3L) {
            this.display.mode = (byte)(this.display.mode | 0x10);
        }
        this.filterBoxes();
        this.view.updater();
    }

    public boolean isImageEditorEditable() {
        return true;
    }

    public static boolean isProcessingClipboard() {
        return processingClipboard;
    }

    public static void setProcessingClipboard(boolean b) {
        processingClipboard = b;
    }

    public void serverLoop() {
        this.io.serverLoop();
    }

    public void setPcbList(Hashtable<Integer, String> list) {
        this.pcbList = list;
    }

    public boolean isPcbInStack(int pcb) {
        if (this.pcbList == null) {
            return false;
        }
        return this.pcbList.containsKey(pcb);
    }

    public void fireServerInterrupt() {
        this.setServerInterrupt(true);
        this.io.fireServerInterrupt();
    }
}

