/*
 * Decompiled with CFR 0.152.
 */
package doc;

import doc.Document;
import doc.Globals;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import javax.swing.SwingUtilities;
import sun.awt.AppContext;
import view.CharView;

public class ClipboardHandler {
    static ClipboardHandler currentHandler;
    private static ClipboardOwner defaultClipboardOwner;
    private static Object SandboxClipboardKey;
    private boolean canAccessSystemClipboard = true;
    static String tmpData;

    static {
        defaultClipboardOwner = new ClipboardObserver();
        SandboxClipboardKey = new Object();
    }

    public ClipboardHandler() {
        this.canAccessSystemClipboard();
    }

    private boolean canAccessSystemClipboard() {
        if (this.canAccessSystemClipboard) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                try {
                    sm.checkSystemClipboardAccess();
                    return true;
                }
                catch (SecurityException se) {
                    this.canAccessSystemClipboard = false;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private Clipboard getClipboard() {
        if (this.canAccessSystemClipboard()) {
            return this.getToolkit().getSystemClipboard();
        }
        Clipboard clipboard = (Clipboard)AppContext.getAppContext().get(SandboxClipboardKey);
        if (clipboard == null) {
            clipboard = new Clipboard("Sandboxed Text Component Clipboard");
            AppContext.getAppContext().put(SandboxClipboardKey, clipboard);
        }
        return clipboard;
    }

    private String getContents() {
        String dstData = null;
        Clipboard clipboard = this.getClipboard();
        if (clipboard != null) {
            try {
                Transferable content = clipboard.getContents(this);
                if (content != null) {
                    dstData = (String)content.getTransferData(DataFlavor.stringFlavor);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dstData;
    }

    private Toolkit getToolkit() {
        return CharView.view.getToolkit();
    }

    void setContents(String srcData) {
        Clipboard clipboard;
        if (srcData != null && (clipboard = this.getClipboard()) != null) {
            StringSelection contents = new StringSelection(srcData);
            clipboard.setContents(contents, defaultClipboardOwner);
        }
    }

    public static ClipboardHandler getCurrentClipboardHandler() {
        if (currentHandler == null) {
            currentHandler = new ClipboardHandler();
        }
        return currentHandler;
    }

    public static final void setClipboardContents(String data) {
        tmpData = data;
        if (!Globals.getOptionValueBoolean("newTypeaheadCode")) {
            Document.setLocked(false);
        }
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String d = tmpData;
                    ClipboardHandler.getCurrentClipboardHandler();
                    currentHandler.setContents(d);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final String getClipboardContents() {
        Document.setProcessingClipboard(true);
        ClipboardHandler.getCurrentClipboardHandler();
        tmpData = currentHandler.getContents();
        Document.setProcessingClipboard(false);
        return tmpData;
    }

    static class ClipboardObserver
    implements ClipboardOwner {
        ClipboardObserver() {
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    }
}

