/*
 * Decompiled with CFR 0.152.
 */
package doc;

import debug.AppxDebug;
import doc.AppxMetalCheckBoxIcon;
import doc.AppxResource;
import doc.AppxWindowsCheckBoxIcon;
import doc.Globals;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.IconUIResource;

public final class AppxToolkit {
    public static final boolean setLook(String newLook, Component root) {
        ColorUIResource uiColor;
        String lookString;
        boolean result = true;
        if (newLook == null) {
            newLook = new String("appx");
        }
        Globals.setOptionValue("guiLook", newLook.toLowerCase());
        if (newLook == "native") {
            lookString = null;
        } else if (newLook.equals("appx")) {
            System.setProperty("swing.noxp", "true");
            lookString = new String("view.AppxLookAndFeel");
        } else if (newLook.equals("java")) {
            lookString = new String("javax.swing.plaf.metal.MetalLookAndFeel");
        } else if (newLook.equals("aqua")) {
            lookString = new String("com.apple.mrj.swing.MacLookAndFeel");
        } else if (newLook.equals("web")) {
            lookString = new String("javax.swing.plaf.metal.MetalLookAndFeel");
        } else if (newLook.equals("native")) {
            if (Globals.getOptionValueBoolean("allowXpTheme")) {
                System.clearProperty("swing.noxp");
            }
            lookString = UIManager.getSystemLookAndFeelClassName();
        } else if (newLook.equals("windows")) {
            if (Globals.getOptionValueBoolean("allowXpTheme")) {
                System.clearProperty("swing.noxp");
            }
            lookString = new String("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        } else {
            lookString = new String("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        if (UIManager.getLookAndFeel() != null) {
            UIManager.getLookAndFeel().initialize();
        }
        if (lookString != null) {
            String osVer = null;
            if ((newLook.equals("windows") || newLook.equals("appx")) && !Globals.isWindowsOS()) {
                osVer = System.getProperty("os.version");
                System.setProperty("os.version", "4");
            }
            try {
                UIManager.setLookAndFeel(lookString);
                UIManager.getLookAndFeel().initialize();
                SwingUtilities.updateComponentTreeUI(root);
            }
            catch (Exception e) {
                result = false;
                System.err.println("LookAndFeel load error: " + e);
                e.printStackTrace();
            }
            if (osVer != null) {
                System.setProperty("os.version", osVer);
            }
        }
        if (!newLook.equals("skin") && (uiColor = new ColorUIResource(0, 0, 0)) != null) {
            AppxToolkit.setDefault("TextField.inactiveForeground", uiColor);
            AppxToolkit.setDefault("TextPane.inactiveForeground", uiColor);
            AppxToolkit.setDefault("TextArea.inactiveForeground", uiColor);
            AppxToolkit.setDefault("PasswordField.inactiveForeground", uiColor);
            AppxToolkit.setDefault("EditorPane.inactiveForeground", uiColor);
            AppxToolkit.setDefault("textInactiveText", uiColor);
            AppxToolkit.setDefault("ComboBox.disabledForeground", uiColor);
        }
        if (newLook.equals("windows")) {
            AppxToolkit.setDefault("CheckBox.icon", new AppxWindowsCheckBoxIcon());
        } else if (!newLook.equals("skin") && !newLook.equals("aqua")) {
            AppxToolkit.setDefault("CheckBox.icon", new AppxMetalCheckBoxIcon());
        }
        if (UIManager.getDefaults().get("OptionPane.errorIcon") == null) {
            AppxToolkit.setDefault("OptionPane.errorIcon", new IconUIResource(AppxResource.Gfx.ERROR_ICON.icon()));
        }
        if (UIManager.getDefaults().get("OptionPane.warningIcon") == null) {
            AppxToolkit.setDefault("OptionPane.warningIcon", new IconUIResource(AppxResource.Gfx.WARNING_ICON.icon()));
        }
        if (UIManager.getDefaults().get("OptionPane.informationIcon") == null) {
            AppxToolkit.setDefault("OptionPane.informationIcon", new IconUIResource(AppxResource.Gfx.INFO_ICON.icon()));
        }
        if (UIManager.getDefaults().get("OptionPane.questionIcon") == null) {
            AppxToolkit.setDefault("OptionPane.questionIcon", new IconUIResource(AppxResource.Gfx.QUESTION_ICON.icon()));
        }
        if (root instanceof Window) {
            ((Window)root).pack();
        }
        root.repaint();
        return result;
    }

    private static final void setDefault(Object key, Object value) {
        UIManager.getDefaults().remove(key);
        UIManager.getDefaults().put(key, value);
    }

    public static final boolean isAppxLook() {
        return Globals.getOptionValueString("guiLook").equals("appx");
    }

    public static final boolean isJavaLook() {
        return Globals.getOptionValueString("guiLook").equals("java");
    }

    public static final boolean isNativeLook() {
        return Globals.getOptionValueString("guiLook").equals("native");
    }

    public static final boolean isAquaLook() {
        return Globals.getOptionValueString("guiLook").equals("aqua");
    }

    public static final boolean isWebLook() {
        return Globals.getOptionValueString("guiLook").equals("web");
    }

    public static final boolean isWindowsLook() {
        return Globals.getOptionValueString("guiLook").equals("windows");
    }

    public static final int adjBounds(int value, int low, int high) {
        return Math.min(Math.max(low, value), high);
    }

    public static final Image iconToImage(Icon i) {
        if (i == null) {
            return null;
        }
        if (i instanceof ImageIcon) {
            return ((ImageIcon)i).getImage();
        }
        BufferedImage returnImage = new BufferedImage(i.getIconWidth(), i.getIconHeight(), 2);
        Graphics g = returnImage.getGraphics();
        JLabel dummyLabel = new JLabel();
        i.paintIcon(dummyLabel, g, 0, 0);
        g.dispose();
        return returnImage;
    }

    public static void copyURL(URL url, File localfile) {
        if (url == null || localfile == null) {
            System.err.println("usage: copyURL( URL=[" + url + "] File=[" + localfile + "])");
            return;
        }
        try {
            int len;
            url.openConnection();
            InputStream is = url.openStream();
            System.out.flush();
            FileOutputStream fos = null;
            fos = new FileOutputStream(localfile);
            AppxDebug.log("copyURL outputStream=[" + fos.toString() + "]");
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) > 0) {
                fos.write(buf, 0, len);
            }
            is.close();
            fos.close();
        }
        catch (MalformedURLException e) {
            System.err.println(e.toString());
        }
        catch (IOException e) {
            System.err.println(e.toString());
        }
    }

    public static void removeFiles(String directory) {
        File rootDir = new File(directory);
        AppxToolkit.removeFiles(rootDir);
    }

    public static void removeFiles(String directory, boolean recursive) {
        File rootDir = new File(directory);
        AppxToolkit.removeFiles(rootDir, recursive);
    }

    public static void removeFiles(String directory, boolean recursive, boolean removeDirs) {
        File rootDir = new File(directory);
        AppxToolkit.removeFiles(rootDir, recursive, removeDirs);
    }

    public static void removeFiles(File rootDir) {
        AppxToolkit.removeFiles(rootDir, false, false);
    }

    public static void removeFiles(File rootDir, boolean recursive) {
        AppxToolkit.removeFiles(rootDir, recursive, recursive);
    }

    public static void removeFiles(File rootDir, boolean recursive, boolean removeDir) {
        if (!rootDir.exists()) {
            return;
        }
        File[] nodes = rootDir.listFiles();
        if (nodes == null || nodes.length < 1) {
            return;
        }
        File[] fileArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            File fi = fileArray[n2];
            if (fi.isFile()) {
                fi.delete();
            } else if (fi.isDirectory() && recursive) {
                AppxToolkit.removeFiles(fi, recursive, removeDir);
            }
            ++n2;
        }
        if (removeDir) {
            rootDir.delete();
        }
    }

    public static final String byteToString(byte[] bytes, int start, int len, int encodingType) {
        try {
            return new String(bytes, start, len, Globals.getEncodingFor(encodingType));
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("doc.AppxToolkit.byteToString() failed.  Exception=" + e);
            e.printStackTrace();
            return new String(bytes, start, len);
        }
    }

    public static final String byteToString(byte[] bytes, int encodingType) {
        try {
            return new String(bytes, Globals.getEncodingFor(encodingType));
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("doc.AppxToolkit.byteToString() failed.  Exception=" + e);
            e.printStackTrace();
            return new String(bytes);
        }
    }

    public static final char byteToChar(byte bytes, int encodingType) {
        byte[] a = new byte[]{bytes};
        try {
            return new String(a, Globals.getEncodingFor(encodingType)).charAt(0);
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("doc.AppxToolkit.byteToString() failed.  Exception=" + e);
            e.printStackTrace();
            return new String(a).charAt(0);
        }
    }

    public static final void stringToByteCopy(String src, byte[] dst, byte pad) throws IndexOutOfBoundsException {
        AppxToolkit.stringToByteCopy(src, 0, dst, pad);
    }

    public static final void stringToByteCopy(String src, int dstOffset, byte[] dst, byte pad, int encodingType) throws IndexOutOfBoundsException {
        byte[] workBytes = AppxToolkit.stringToBytes(src, dst.length, false, encodingType);
        Arrays.fill(dst, pad);
        System.arraycopy(workBytes, 0, dst, dstOffset, workBytes.length);
    }

    public static final void stringToByteCopy(String src, int dstOffset, byte[] dst, int maxlen, byte pad, int encodingType) throws IndexOutOfBoundsException {
        byte[] workBytes = AppxToolkit.stringToBytes(src, maxlen, false, encodingType);
        Arrays.fill(dst, dstOffset, dstOffset + maxlen - 1, pad);
        System.arraycopy(workBytes, 0, dst, dstOffset, workBytes.length);
    }

    public static final void stringToByteCopy(String src, byte[] dst, int encodingType) throws IndexOutOfBoundsException {
        AppxToolkit.stringToByteCopy(src, 0, dst, encodingType);
    }

    public static final void stringToByteCopy(String src, int dstOffset, byte[] dst, int encodingType) throws IndexOutOfBoundsException {
        byte[] workBytes = AppxToolkit.stringToBytes(src, dst.length, false, encodingType);
        System.arraycopy(workBytes, 0, dst, dstOffset, workBytes.length);
    }

    public static final void stringToByteCopy(String src, int dstOffset, byte[] dst, int maxlen, int encodingType) throws IndexOutOfBoundsException {
        byte[] workBytes = AppxToolkit.stringToBytes(src, maxlen, false, encodingType);
        System.arraycopy(workBytes, 0, dst, dstOffset, workBytes.length);
    }

    public static final byte[] stringToBytes(String str, int encodingType) {
        try {
            return AppxToolkit.stringToBytes(str, 0, false, encodingType);
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("exception=" + e);
            return null;
        }
    }

    public static final byte[] stringToBytes(String str, int maxlen, boolean pad, int encodingType) throws IndexOutOfBoundsException {
        byte[] result = null;
        try {
            result = str.getBytes(Globals.getEncodingFor(encodingType));
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("doc.AppxToolkit.stringToBytes() failed.  Exception=" + e);
            e.printStackTrace();
            result = str.getBytes();
        }
        if (maxlen > 0 && result != null && result.length > maxlen) {
            throw new IndexOutOfBoundsException("Converting string [" + str + "] to bytes resulted in " + result.length + " bytes which exceeds the callers stated max length of " + maxlen + " bytes.");
        }
        if (pad) {
            byte[] paddedResult = new byte[maxlen];
            Arrays.fill(paddedResult, (byte)32);
            System.arraycopy(result, 0, paddedResult, 0, result.length);
            result = paddedResult;
        }
        return result;
    }

    public static final byte charToByte(char str, int encodingType) {
        try {
            return ("" + str).getBytes(Globals.getEncodingFor(encodingType))[0];
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("doc.AppxToolkit.stringToBytes() failed.  Exception=" + e);
            e.printStackTrace();
            return ("" + str).getBytes()[0];
        }
    }

    public static void extractFolder(String zipFile, String newPath) throws ZipException, IOException {
        System.out.println(zipFile);
        int BUFFER = 2048;
        File file = new File(zipFile);
        ZipFile zip = new ZipFile(file);
        new File(newPath).mkdir();
        Enumeration<? extends ZipEntry> zipFileEntries = zip.entries();
        while (zipFileEntries.hasMoreElements()) {
            int currentByte;
            ZipEntry entry = zipFileEntries.nextElement();
            String currentEntry = entry.getName();
            File destFile = new File(newPath, currentEntry);
            File destinationParent = destFile.getParentFile();
            destinationParent.mkdirs();
            if (entry.isDirectory()) continue;
            BufferedInputStream is = new BufferedInputStream(zip.getInputStream(entry));
            byte[] data = new byte[BUFFER];
            FileOutputStream fos = new FileOutputStream(destFile);
            BufferedOutputStream dest = new BufferedOutputStream(fos, BUFFER);
            while ((currentByte = is.read(data, 0, BUFFER)) != -1) {
                dest.write(data, 0, currentByte);
            }
            dest.flush();
            dest.close();
            is.close();
        }
    }
}

