/*
 * Decompiled with CFR 0.152.
 */
package doc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

public final class AppxMetalCheckBoxIcon
implements Icon,
UIResource,
Serializable {
    private static final long serialVersionUID = -89328885482951392L;

    protected int getControlSize() {
        return 13;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        JCheckBox cb = (JCheckBox)c;
        ButtonModel model = cb.getModel();
        int controlSize = this.getControlSize();
        if (model.isEnabled()) {
            if (model.isPressed() && model.isArmed()) {
                g.setColor(Color.white);
                g.fillRect(x, y, controlSize - 1, controlSize - 1);
                this.drawPressed3DBorder(g, x, y, controlSize, controlSize);
            } else {
                this.drawFlush3DBorder(g, x, y, controlSize, controlSize);
            }
            g.setColor(Color.black);
        } else {
            g.setColor((Color)UIManager.get("ComboBox.disabledBackground"));
            g.fillRect(x, y, controlSize - 1, controlSize - 1);
            g.setColor(MetalLookAndFeel.getControlShadow());
            g.drawRect(x, y, controlSize - 1, controlSize - 1);
            g.setColor(Color.black);
        }
        if (model.isSelected()) {
            this.drawCheck(c, g, x, y);
        }
    }

    protected void drawCheck(Component c, Graphics g, int x, int y) {
        int controlSize = this.getControlSize();
        g.fillRect(x + 3, y + 5, 2, controlSize - 8);
        g.drawLine(x + (controlSize - 4), y + 3, x + 5, y + (controlSize - 6));
        g.drawLine(x + (controlSize - 4), y + 4, x + 5, y + (controlSize - 5));
    }

    @Override
    public int getIconWidth() {
        return this.getControlSize();
    }

    @Override
    public int getIconHeight() {
        return this.getControlSize();
    }

    private void drawPressed3DBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        this.drawFlush3DBorder(g, 0, 0, w, h);
        g.setColor(MetalLookAndFeel.getControlShadow());
        g.drawLine(1, 1, 1, h - 2);
        g.drawLine(1, 1, w - 2, 1);
        g.translate(-x, -y);
    }

    private void drawFlush3DBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        g.setColor(MetalLookAndFeel.getControlDarkShadow());
        g.drawRect(0, 0, w - 2, h - 2);
        g.setColor(MetalLookAndFeel.getControlHighlight());
        g.drawRect(1, 1, w - 2, h - 2);
        g.setColor(MetalLookAndFeel.getControl());
        g.drawLine(0, h - 1, 1, h - 2);
        g.drawLine(w - 1, 0, w - 2, 1);
        g.translate(-x, -y);
    }
}

