/*
 * Decompiled with CFR 0.152.
 */
package debug;

import debug.AppxDebug;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

class SaveOutput
extends PrintStream {
    static OutputStream logfile;
    static PrintStream oldStdout;
    static PrintStream oldStderr;

    SaveOutput(PrintStream ps) {
        super(ps);
    }

    public static void start(String f) throws IOException {
        oldStdout = System.out;
        oldStderr = System.err;
        logfile = new PrintStream(new BufferedOutputStream(new FileOutputStream(f)));
        System.setOut(new SaveOutput(System.out));
        System.setErr(new SaveOutput(System.err));
    }

    public static void stop() {
        System.setOut(oldStdout);
        System.setErr(oldStderr);
        try {
            if (logfile != null) {
                logfile.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        try {
            logfile.write(buf, off, len);
            logfile.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setError();
        }
        if ((AppxDebug.debugMask & 0x400) != 0) {
            super.write(buf, off, len);
            super.flush();
        }
    }

    @Override
    public void write(int b) {
        try {
            logfile.write(b);
            logfile.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setError();
        }
        if ((AppxDebug.debugMask & 0x400) != 0) {
            super.write(b);
            super.flush();
        }
    }
}

