/*
 * Decompiled with CFR 0.152.
 */
package debug;

import debug.SaveOutput;
import doc.CompileDate;
import doc.Globals;
import java.awt.Toolkit;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import view.CharView;

public abstract class AppxDebug {
    public static final String what_str = "@(#)Appx $Header: /src/cvs/joe/debug/AppxDebug.java,v 1.3.2.29 2013/08/17 16:36:45 pete Exp $";
    public static final int TYPE_NONE = 0;
    public static final int TYPE_T_CLASS_CREATION = 1;
    public static final int TYPE_SERVER_REQUEST = 2;
    public static final int TYPE_FIRE_OBJECT_EVENT = 4;
    public static final int TYPE_TOKEN_SCAN_LIST = 8;
    public static final int TYPE_GET_FILE_LIST = 16;
    public static final int TYPE_GET_FIELD_LIST = 32;
    public static final int TYPE_BITS_SEND = 64;
    public static final int TYPE_BITS_RECV = 128;
    public static final int TYPE_KEYBOARD_EVENTS = 256;
    public static final int TYPE_TOPBOX_TITLE = 512;
    public static final int TYPE_CONSOLE_LOGGING = 1024;
    public static final int TYPE_KEYBOARD_EVENTS_STACK = 2048;
    public static final int TYPE_RAW_WIDGET_DATA = 4096;
    public static final int TYPE_RAW_EVENT_DATA = 8192;
    public static final int TYPE_FILE_TRANSFER = 16384;
    public static final int SEVERITY_ALL = 0;
    public static final int SEVERITY_FYI = 1;
    public static final int SEVERITY_LOW = 2;
    public static final int SEVERITY_MEDIUM = 3;
    public static final int SEVERITY_HIGH = 4;
    public static final int SEVERITY_CRITICAL = 5;
    public static final int SEVERITY_NONE = 6;
    public static final int DEFAULT_NOTIFY_LEVEL = 6;
    public static final int DEFAULT_LOG_LEVEL = 0;
    public static final String[] sevTxt = new String[]{"ALL", "FYI", "LOW", "MEDIUM", "HIGH", "CRITIAL", "NONE"};
    static final int[] severityType;
    public static final boolean hexdumpBytes = false;
    public static final boolean debugBytes = false;
    public static final boolean debugEnabled = false;
    private static boolean loggingEnabled;
    public static int debugMask;
    public static int bytesRead;
    public static int bytesWritten;
    public static int subbytesRead;
    public static int subbytesWritten;
    public static int subbytesCount;
    public static boolean debugCaptureSystem;
    public static boolean debugCountBytes;
    public static int totalBytesRead;
    public static int totalBytesWritten;
    private static boolean reading;
    private static boolean writing;
    private static int totalBytes;
    private static int bytePtr;
    private static int offset;
    private static byte[] bytes;
    static int tmpSeverity;
    static String tmpText;

    static {
        int[] nArray = new int[7];
        nArray[0] = -1;
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 2;
        severityType = nArray;
        loggingEnabled = false;
        debugMask = 1024;
        bytesRead = 0;
        bytesWritten = 0;
        subbytesRead = 0;
        subbytesWritten = 0;
        subbytesCount = 0;
        debugCaptureSystem = true;
        debugCountBytes = false;
        totalBytesRead = 0;
        totalBytesWritten = 0;
        reading = false;
        writing = false;
        totalBytes = 0;
        bytePtr = 0;
        offset = 0;
        bytes = new byte[16];
    }

    public static final void resetSubByteFields() {
        subbytesRead = 0;
        subbytesWritten = 0;
        subbytesCount = 1;
    }

    public static final void flushSubByteFields(int cnt, String msg) {
        if (cnt >= 0) {
            subbytesCount = cnt;
        }
        AppxDebug.flushBytes();
        System.err.println("Byte Totals for '" + msg + "' Read=" + subbytesRead + ", Bytes Written=" + subbytesWritten + ", Object Count=" + subbytesCount);
        System.err.println("");
        subbytesRead = 0;
        subbytesWritten = 0;
        subbytesCount = 1;
    }

    private static void flushBytes() {
        if (bytePtr > 0) {
            AppxDebug.printLine();
        }
        if (reading) {
            subbytesRead += totalBytes;
        } else if (writing) {
            subbytesWritten += totalBytes;
        }
        totalBytes = 0;
        offset = 0;
    }

    public static void log(String text, int severity) {
        AppxDebug.log(0, text, severity);
    }

    public static void log(String text) {
        AppxDebug.log(0, text, 0);
    }

    public static void log(int type, String text, int severity) {
        if (reading || writing) {
            AppxDebug.flushBytes();
        }
        reading = false;
        writing = false;
        if ((type & debugMask) == type) {
            if (Globals.getOptionValueInteger("debugLogLevel") <= severity) {
                AppxDebug.println(Thread.currentThread() + ": " + sevTxt[severity] + " - " + text);
            }
            if (Globals.getOptionValueInteger("debugNotifyLevel") <= severity) {
                try {
                    tmpSeverity = severity;
                    tmpText = text;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int severity = tmpSeverity;
                            String text = tmpText;
                            JOptionPane.showMessageDialog(CharView.view, text, "Debug - " + sevTxt[severity], severityType[severity]);
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void log(int type, String text) {
        AppxDebug.log(type, text, 0);
    }

    public static void logByte(byte b) {
        if (reading) {
            AppxDebug.flushBytes();
            reading = false;
        }
        if (!writing) {
            AppxDebug.println("***** Logging Bytes >>>>>");
            writing = true;
        }
        AppxDebug.printByte(b);
    }

    public static void logBytes(byte[] b) {
        AppxDebug.logBytes(b, b.length);
    }

    public static void logBytes(byte[] b, int len) {
        int i = 0;
        while (i < len) {
            AppxDebug.logByte(b[i]);
            ++i;
        }
    }

    public static void logInByte(byte b) {
        if (writing) {
            AppxDebug.flushBytes();
            writing = false;
        }
        if (!reading) {
            reading = true;
        }
        AppxDebug.printByte(b);
        ++bytesRead;
        ++totalBytesRead;
    }

    public static void logInBytes(byte[] b) {
        AppxDebug.logInBytes(b, b.length);
    }

    public static void logInBytes(byte[] b, int len) {
        int i = 0;
        while (i < len) {
            AppxDebug.logInByte(b[i]);
            ++i;
        }
    }

    public static void logInInt(int b) {
        if (writing) {
            AppxDebug.flushBytes();
            writing = false;
        }
        if (!reading) {
            reading = true;
        }
        AppxDebug.printInt(b);
        bytesRead += 4;
        totalBytesRead += 4;
    }

    public static void logOutByte(byte b) {
        if (reading) {
            AppxDebug.flushBytes();
            reading = false;
        }
        if (!writing) {
            writing = true;
        }
        AppxDebug.printByte(b);
        ++bytesWritten;
        ++totalBytesWritten;
    }

    public static void logOutBytes(byte[] b) {
        AppxDebug.logOutBytes(b, b.length);
    }

    public static void logOutBytes(byte[] b, int len) {
        int i = 0;
        while (i < len) {
            AppxDebug.logOutByte(b[i]);
            ++i;
        }
    }

    public static void logOutInt(int b) {
        if (reading) {
            AppxDebug.flushBytes();
            reading = false;
        }
        if (!writing) {
            writing = true;
        }
        AppxDebug.printInt(b);
        bytesWritten += 4;
        totalBytesWritten += 4;
    }

    private static void print(String str) {
        System.err.print(str);
    }

    private static void printByte(byte b) {
    }

    private static void printInt(int b) {
        AppxDebug.printByte((byte)(b >> 24));
        AppxDebug.printByte((byte)(b >> 16));
        AppxDebug.printByte((byte)(b >> 8));
        AppxDebug.printByte((byte)b);
    }

    private static void printLine() {
        bytePtr = 0;
        offset += 16;
    }

    private static void println(String str) {
        System.err.println(str);
    }

    public static void stack(int type) {
        if (reading || writing) {
            AppxDebug.flushBytes();
        }
        reading = false;
        writing = false;
        if ((type & debugMask) == type) {
            Thread.dumpStack();
        }
    }

    public static void startSystemLog() {
        if (AppxDebug.isLoggingEnabled()) {
            Properties prop;
            if (debugCaptureSystem) {
                try {
                    SaveOutput.start(String.valueOf(Globals.getClientUserHome()) + "/appxlog.txt");
                }
                catch (Exception e) {
                    System.err.println("exception=" + e);
                }
            }
            System.err.println("================================================================================");
            System.err.println("Java Client Session Log");
            System.err.println("--------------------------------------------------------------------------------");
            System.err.println(" Client Version  = 5.4.2");
            System.err.println(" Client Compiled = " + CompileDate.getCompileDate());
            System.err.println("Session Started  = " + new Date());
            System.err.println("================================================================================");
            System.err.println("================================================================================");
            System.err.println("Dump of Client Environment Properties");
            System.err.println("================================================================================");
            Properties h = prop = System.getProperties();
            String filler = "                                                                                ";
            Enumeration e = ((Hashtable)h).keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String val = (String)((Hashtable)h).get(key);
                if (key.length() < 35) {
                    key = String.valueOf(key) + filler.substring(0, 35 - key.length());
                }
                System.err.println(String.valueOf(key) + " = " + val);
            }
            System.err.println("================================================================================");
            System.err.println("Client Workstation Specifications");
            System.err.println("================================================================================");
            Toolkit tk = Toolkit.getDefaultToolkit();
            System.err.println("Screen Geometry   = " + Globals.getGraphicsConfiguration().getBounds());
            System.err.println("Screen Resolution = " + tk.getScreenResolution());
            System.err.println("Cursor Size       = " + tk.getBestCursorSize(50, 50));
            System.err.println("Cursor Colors     = " + tk.getMaximumCursorColors());
        }
    }

    public static void stopSystemLog() {
        if (debugCaptureSystem) {
            SaveOutput.stop();
        }
    }

    public static void trap(String s) {
        AppxDebug.log(s);
    }

    public static final boolean isLoggingEnabled() {
        return loggingEnabled;
    }

    public static final void setLoggingEnabled(boolean le) {
        loggingEnabled = le;
    }
}

