/*
 * Decompiled with CFR 0.152.
 */
package comm.msg;

import comm.msg.Message;
import java.awt.Dimension;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MRCBlock
extends Message {
    public static final String what_str = "@(#)Appx $Header: /src/cvs/joe/comm/msg/MRCBlock.java,v 1.1.2.1 2005/09/23 13:07:28 pete Exp $";
    public static final byte type = 40;
    public int row;
    public int column;

    public boolean equals(MRCBlock tmpBlock) {
        return this.row == tmpBlock.row && this.column == tmpBlock.column;
    }

    public MRCBlock(int row, int column) {
        this.row = row;
        this.column = column;
    }

    @Override
    public int length() {
        return 8;
    }

    public MRCBlock(Dimension size) {
        this.row = size.height;
        this.column = size.width;
    }

    public void read(DataInputStream in) throws IOException {
        this.row = in.readInt() - 1;
        this.column = in.readInt() - 1;
    }

    public String toString() {
        String result = "[";
        if (this.row < 10) {
            result = String.valueOf(result) + " ";
        }
        result = String.valueOf(result) + this.row + ",";
        if (this.column < 10) {
            result = String.valueOf(result) + "  ";
        } else if (this.column < 100) {
            result = String.valueOf(result) + " ";
        }
        result = String.valueOf(result) + this.column + "]";
        return result;
    }

    public MRCBlock() {
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.row + 1);
        out.writeInt(this.column + 1);
    }
}

