/*
 * Decompiled with CFR 0.152.
 */
package comm.msg;

import comm.msg.Message;
import doc.AppxToolkit;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;

public class MObjBlock
extends Message {
    public static final String what_str = "@(#)Appx $Header: /src/cvs/joe/comm/msg/MObjBlock.java,v 1.1.2.3 2011/12/10 19:29:55 pete Exp $";
    public static final byte type = 44;
    private short protoLen;
    private byte argCount;
    private byte handle;
    private byte[] proto;

    public int getArgCount() {
        return this.argCount;
    }

    public String getClassName() {
        if (this.proto == null) {
            return null;
        }
        int length = Array.getLength(this.proto);
        int len = 0;
        len = 0;
        while (len < length && this.proto[len] != 40) {
            ++len;
        }
        return AppxToolkit.byteToString(this.proto, 0, len, 1);
    }

    public int getHandle() {
        return this.handle;
    }

    public String getMethodName() {
        if (this.proto == null) {
            return null;
        }
        int length = Array.getLength(this.proto);
        int start = 0;
        int end = 0;
        start = 0;
        while (start < length && this.proto[start] != 32) {
            ++start;
        }
        end = 0;
        while (end < length && this.proto[end] != 40) {
            ++end;
        }
        return AppxToolkit.byteToString(this.proto, start + 1, end - start - 1, 1);
    }

    public String getReturnClassName() {
        if (this.proto == null) {
            return null;
        }
        int length = Array.getLength(this.proto);
        int len = 0;
        len = 0;
        while (len < length && this.proto[len] != 32) {
            ++len;
        }
        return AppxToolkit.byteToString(this.proto, 0, len, 1);
    }

    public MObjBlock(int index) {
        this.handle = (byte)index;
        this.protoLen = 0;
        this.argCount = 0;
    }

    @Override
    public int length() {
        return 4 + this.protoLen;
    }

    public void read(DataInputStream in) throws IOException {
        this.protoLen = in.readShort();
        this.argCount = in.readByte();
        this.handle = in.readByte();
        this.proto = new byte[this.protoLen];
        in.readFully(this.proto);
    }

    public String toString() {
        return new String("MObjBlock protoLen=" + this.protoLen + ", Prototype=" + AppxToolkit.byteToString(this.proto, 1) + ", argCount=" + this.argCount + ", handle=" + this.handle);
    }

    public MObjBlock() {
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeShort(this.protoLen);
        out.writeByte(this.argCount);
        out.writeByte(this.handle);
        if (this.protoLen > 0) {
            out.write(this.proto);
        }
    }
}

