/*
 * Decompiled with CFR 0.152.
 */
package comm.msg;

import comm.msg.MMnu;
import comm.msg.Message;
import doc.AppxToolkit;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class MMenu
extends Message {
    public static final String what_str = "@(#)Appx $Header: /src/cvs/joe/comm/msg/MMenu.java,v 1.1.2.5 2011/12/10 19:29:55 pete Exp $";
    public static final byte type = 81;
    public byte menuType = (byte)-1;
    public int mnuCount;
    public int dataLen;
    public byte[] data;
    public Vector<MMnu> mnuBlock;
    public String menuLabel;
    public char menuShortcut;
    public int menuNo;
    public boolean menuUse;
    private String menuCommand;

    public MMenu duplicate() {
        MMenu newMenu = new MMenu();
        newMenu.menuType = this.menuType;
        newMenu.mnuCount = this.mnuCount;
        newMenu.dataLen = this.dataLen;
        newMenu.data = this.data;
        newMenu.mnuBlock = (Vector)this.mnuBlock.clone();
        newMenu.menuLabel = this.menuLabel;
        newMenu.menuShortcut = this.menuShortcut;
        newMenu.menuNo = this.menuNo;
        newMenu.menuUse = this.menuUse;
        newMenu.menuCommand = this.menuCommand;
        return newMenu;
    }

    public String getMenuCommand() {
        return this.menuCommand;
    }

    @Override
    public int length() {
        return 4;
    }

    private void parseData() {
        this.menuLabel = null;
        this.menuShortcut = (char)32;
        this.menuNo = -1;
        this.menuUse = false;
        this.menuCommand = null;
        if (this.dataLen > 0) {
            StringTokenizer st = new StringTokenizer(AppxToolkit.byteToString(this.data, 4), "@");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.startsWith("ST=")) {
                    this.menuLabel = new String(token.substring(3));
                    continue;
                }
                if (token.startsWith("SMN=")) {
                    this.menuShortcut = token.charAt(4);
                    continue;
                }
                if (token.startsWith("SMT=")) {
                    this.menuNo = Integer.parseInt(token.substring(4));
                    continue;
                }
                if (token.startsWith("USE=")) {
                    if (token.charAt(4) != 'T') continue;
                    this.menuUse = true;
                    continue;
                }
                if (!token.startsWith("SAC=")) continue;
                this.menuCommand = token.substring(4);
            }
        }
    }

    public void read(DataInputStream in) throws IOException {
        this.menuType = in.readByte();
        in.readByte();
        this.mnuCount = in.readShort();
        this.dataLen = in.readShort();
        if (this.dataLen > 0) {
            this.data = new byte[this.dataLen];
            in.readFully(this.data);
        } else {
            this.data = new byte[0];
        }
        MMnu mnu = null;
        this.mnuBlock = new Vector(this.mnuCount);
        int i = 0;
        while (i < this.mnuCount) {
            mnu = new MMnu();
            mnu.read(in);
            this.mnuBlock.addElement(mnu);
            ++i;
        }
        this.parseData();
    }

    public void setMenuCommand(String s) {
        this.menuCommand = s;
    }

    public String toString() {
        if (this.data == null || this.data.length == 0) {
            return super.toString();
        }
        return AppxToolkit.byteToString(this.data, 4);
    }

    public void write(DataOutputStream out) {
    }
}

