/*
 * Decompiled with CFR 0.152.
 */
package comm.msg;

import comm.IOHandler;
import comm.msg.Message;
import doc.AppxToolkit;
import doc.Globals;
import doc.LocalPrint;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.JOptionPane;
import view.CharView;

public class MLogin
extends Message {
    public static final byte type = 2;
    public static final String what_str = "@(#)Appx $Header: /src/cvs/joe/comm/msg/MLogin.java,v 1.1.2.7 2013/08/12 15:42:25 pete Exp $";
    private byte[] host = new byte[31];
    private byte[] password = new byte[21];
    private byte remap;
    private byte[] startup = new byte[246];
    private byte[] user = new byte[21];
    private byte version;
    private int reconnectid;

    public MLogin(String loginUser, String loginPassword, String startupAP, String startupDB, String startupTY, String startupPR, boolean remap, int vers) {
        this(loginUser, loginPassword, startupAP, startupDB, startupTY, startupPR, remap, vers, -1);
    }

    public MLogin(String loginUser, String loginPassword, String startupAP, String startupDB, String startupTY, String startupPR, boolean remap, int vers, int reconnectid) {
        AppxToolkit.stringToByteCopy(loginUser, this.user, (byte)0);
        AppxToolkit.stringToByteCopy(loginPassword, this.password, (byte)0);
        this.reconnectid = reconnectid;
        Arrays.fill(this.startup, (byte)0);
        if (startupAP != null) {
            AppxToolkit.stringToByteCopy(startupAP, 0, this.startup, 3);
        }
        if (startupDB != null) {
            AppxToolkit.stringToByteCopy(startupDB, 3, this.startup, 3);
        }
        if (startupTY != null) {
            AppxToolkit.stringToByteCopy(startupTY, 6, this.startup, 10);
        }
        if (startupPR != null) {
            AppxToolkit.stringToByteCopy(startupPR, 16, this.startup, 30);
        }
        this.remap = (byte)(remap ? 1 : 0);
        this.version = (byte)vers;
    }

    @Override
    public int length() {
        return 331;
    }

    public void write(DataOutputStream out) throws IOException {
        byte[] recon = new byte[10];
        String recon_str = "" + this.reconnectid;
        byte[] recon_bytes = recon_str.getBytes();
        int i = 0;
        while (i < 10) {
            recon[i] = this.reconnectid != 0 && i < recon_bytes.length ? recon_bytes[i] : (byte)0;
            ++i;
        }
        if (this.version > 4) {
            out.write(this.version);
        }
        out.write(this.user);
        out.write(this.password);
        out.write(this.host);
        out.write(this.remap);
        out.write(this.startup);
        out.write(recon);
        out.write(this.version);
        if (Globals.getOptionValueBoolean("useSSO")) {
            out.flush();
            System.err.println("MLogin.write() calling authenticateSSO()");
            String ssoResult = LocalPrint.authenticateSSO(IOHandler.currentHandler.getSocket(), new String(this.user));
            System.err.println("MLogin.write() authenticateSSO() returned " + ssoResult);
            if (ssoResult != null && ssoResult.length() > 0) {
                JOptionPane.showMessageDialog(CharView.view, ssoResult, "Single Sign-On Error", 0);
                System.exit(0);
            }
        }
    }
}

