/*
 * Decompiled with CFR 0.152.
 */
package comm.msg;

import comm.msg.MWidget;
import comm.msg.Message;
import debug.AppxDebug;
import doc.AppxToolkit;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.JComponent;

public class MFld
extends Message {
    public static final String what_str = "@(#)Appx $Header: /src/cvs/joe/comm/msg/MFld.java,v 1.2.2.14 2015/04/07 14:38:45 pete Exp $";
    public static final int ELEM_NONE = 0;
    public static final int ELEM_ALP_CONTIG = 1;
    public static final int ELEM_ALP_NON_CONTIG = 2;
    public static final int ELEM_ALP_JUL_DATE = 3;
    public static final int ELEM_ALP_GREG_DATE = 4;
    public static final int ELEM_BIN = 5;
    public static final int ELEM_BIN_JUL_DATE = 6;
    public static final int ELEM_BIN_GREG_DATE = 7;
    public static final int ELEM_PD_FIX = 8;
    public static final int ELEM_PD_JUL_DATE = 9;
    public static final int ELEM_PD_GREG_DATE = 10;
    public static final int ELEM_LOG = 11;
    public static final int ELEM_PD_VAR = 12;
    public static final int ELEM_ALP_SUBSTR = 13;
    public static final int ELEM_ALP_CMPRS = 14;
    public static final int ELEM_UNIVERSAL_DATE = 15;
    public static final byte FLD_OPTS_NULL = 0;
    public static final byte FLD_OPTS_NULL_OK = 1;
    public static final byte FLD_OPTS_UCS = 2;
    public static final byte FLD_OPTS_MASK = 4;
    public static final byte FLD_OPTS_SCAN = 8;
    public static final byte FLD_SPEC_NONE = 0;
    public static final byte FLD_SPEC_PICTURE = 1;
    public static final byte FLD_SPEC_TOKEN = 2;
    public static final byte FLD_SPEC_REQ_VAL = 4;
    public static final byte FLD_SPEC_STAT_MSG = 8;
    public static final byte FLD_SPEC_ENCODING = 48;
    public static final byte FLD_SPEC_DLU_TABOUT = 64;
    public static final byte FLD_SPEC_ENCODING_RAW = 16;
    public static final byte FLD_SPEC_ENCODING_NATIONAL = 32;
    public static final byte FLD_SPEC_ENCODING_UCODE32 = 48;
    public static final int FIELD_TYPE_NONE = 0;
    public static final int FIELD_TYPE_ALPHA = 10;
    public static final int FIELD_TYPE_DATE = 20;
    public static final int FIELD_TYPE_NUMERIC = 30;
    public static final int FIELD_TYPE_LOGIC = 40;
    public static final int FIELD_TYPE_TEXT = 60;
    public static final int FIELD_TYPE_TOKEN = 70;
    public static final int AFMT_JUST_NOT = 1;
    public static final int AFMT_JUST_L = 2;
    public static final int AFMT_JUST_RAGGED_L = 4;
    public static final int AFMT_JUST_R = 8;
    public static final int AFMT_JUST_CENTER = 16;
    public static final int AFMT_JUST_WRAP = 128;
    private int fieldType = 0;
    private int row;
    private int col;
    private int rows;
    private int cols;
    private byte type;
    private byte just;
    private byte hi;
    private byte lo;
    private byte options;
    private byte special;
    private short dataLen;
    private byte[] data;
    private JComponent guiField;
    private long attr;
    private MWidget widgetData = null;
    private byte[] rawDate;
    private short maxLen = 0;
    private boolean req_val = true;
    private int encoding = 0;
    private byte[] cacheId = new byte[8];
    private byte[] cacheSig = new byte[8];
    private short group = 0;
    private byte[] ap = new byte[3];
    private byte[] ver = new byte[2];
    private boolean readFldWidgets = false;
    private int originalRow = 0;
    public int originalCol = 0;

    public String getAp() {
        return AppxToolkit.byteToString(this.ap, 1);
    }

    public long getAttributes() {
        return this.attr;
    }

    public String getCacheName() {
        if (this.group == 0) {
            return null;
        }
        byte[] name = new byte[13];
        System.arraycopy(this.ap, 0, name, 0, 3);
        System.arraycopy(this.ver, 0, name, 3, 2);
        System.arraycopy(this.cacheId, 0, name, 5, 8);
        return AppxToolkit.byteToString(name, 1);
    }

    public Rectangle getCellBounds() {
        return new Rectangle(this.col, this.row, this.cols, this.rows);
    }

    public int getCol() {
        return this.col;
    }

    public int getCols() {
        return this.cols;
    }

    public int getDataLen() {
        return this.dataLen;
    }

    public String getData() {
        String dataString = null;
        if (this.dataLen > 0) {
            try {
                dataString = AppxToolkit.byteToString(this.data, 4);
            }
            catch (Exception e) {
                System.err.println("MFld.getData() exception=" + e);
                dataString = AppxToolkit.byteToString(this.data, 4);
            }
        }
        return dataString;
    }

    public int getDateHi() {
        return this.hi;
    }

    public int getDateLow() {
        return this.lo;
    }

    public int getFieldType() {
        return this.fieldType;
    }

    public int getGroup() {
        return this.group;
    }

    public JComponent getGuiField() {
        return this.guiField;
    }

    public String getId() {
        return AppxToolkit.byteToString(this.cacheId, 1);
    }

    public int getJustification() {
        return this.just;
    }

    public int getMaxLen() {
        if (this.maxLen == 0) {
            return this.rows * this.cols;
        }
        return this.maxLen;
    }

    public int getOriginalCol() {
        return this.originalCol;
    }

    public int getOriginalRow() {
        return this.originalRow;
    }

    public byte[] getRawDate() {
        return this.rawDate;
    }

    public int getRow() {
        return this.row;
    }

    public int getRows() {
        return this.rows;
    }

    public String getSig() {
        return AppxToolkit.byteToString(this.cacheSig, 1);
    }

    public int getSpecial() {
        return this.special;
    }

    public int getType() {
        return this.type;
    }

    public String getVer() {
        return AppxToolkit.byteToString(this.ver, 1);
    }

    public MWidget getWidgetData() {
        return this.widgetData;
    }

    public int getWidgetType() {
        if (this.widgetData == null || this.widgetData.wWidgetType == null) {
            return 0;
        }
        return this.widgetData.wWidgetType;
    }

    public boolean isNullOk() {
        return (this.options & 1) != 0;
    }

    public boolean isScannable() {
        return (this.attr & 0x80000L) == 524288L;
    }

    public boolean isTableValueRequired() {
        return this.req_val;
    }

    @Override
    public int length() {
        return 8;
    }

    public void read(DataInputStream in) throws IOException {
        this.row = in.readUnsignedByte();
        this.col = in.readUnsignedByte();
        this.rows = in.readUnsignedByte();
        this.cols = in.readUnsignedByte();
        this.just = in.readByte();
        if (this.just < 0) {
            this.just = 0;
        }
        this.hi = in.readByte();
        this.lo = in.readByte();
        this.options = in.readByte();
        this.type = in.readByte();
        this.special = in.readByte();
        this.dataLen = in.readShort();
        this.setOriginalRow(this.row);
        this.setOriginalCol(this.col);
        if (this.dataLen > 0) {
            this.data = new byte[this.dataLen];
            in.readFully(this.data);
        }
        if ((this.special & 2) == 2) {
            in.readFully(this.cacheId);
            in.readFully(this.cacheSig);
            this.group = in.readShort();
            in.readFully(this.ap);
            in.readFully(this.ver);
            in.readByte();
        }
        if (this.readFldWidgets) {
            this.widgetData = new MWidget();
            this.widgetData.read(in);
            if (this.widgetData.widgetLen == 0) {
                this.widgetData = null;
            }
        }
        switch (this.type) {
            case 1: 
            case 2: 
            case 13: 
            case 14: {
                if ((this.special & 4) != 0) {
                    this.req_val = false;
                }
                this.fieldType = (this.special & 2) != 0 ? 70 : (this.rows > 1 ? 60 : 10);
                int loInt = this.lo;
                int hiInt = this.hi;
                if (loInt < 0) {
                    loInt += 256;
                }
                if (hiInt < 0) {
                    hiInt += 256;
                }
                this.maxLen = (short)(hiInt * 256 + loInt);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 15: {
                this.fieldType = 20;
                if (this.dataLen == 16) {
                    this.rawDate = new byte[16];
                    System.arraycopy(this.data, 0, this.rawDate, 0, 16);
                }
                this.dataLen = 0;
                this.data = null;
                break;
            }
            case 5: 
            case 8: 
            case 12: {
                this.fieldType = 30;
                break;
            }
            case 11: {
                this.fieldType = 40;
            }
        }
        switch (this.special & 0x30) {
            case 16: {
                this.encoding = 1;
                break;
            }
            case 32: {
                this.encoding = 2;
                break;
            }
            case 48: {
                this.encoding = 3;
                break;
            }
            default: {
                this.encoding = 0;
            }
        }
    }

    public void setAp(byte[] newAp) {
        this.ap = newAp;
    }

    public void setAttributes(long att) {
        this.attr = att;
    }

    public void setCol(int c) {
        this.col = c;
    }

    public void setCols(int c) {
        this.cols = c;
    }

    public void setData(byte[][] charArray) {
        String workData;
        if (this.row < 0 || this.col < 0) {
            AppxDebug.log("MFld.setData(byte[][]) Field position out of range: row=" + this.row + ", col=" + this.col, 4);
            return;
        }
        switch (this.fieldType) {
            case 30: 
            case 40: 
            case 70: {
                workData = AppxToolkit.byteToString(charArray[this.row], this.col, this.cols, 2);
                break;
            }
            default: {
                workData = AppxToolkit.byteToString(charArray[this.row], this.col, this.cols, 2);
                int workRow = 1;
                while (workRow < this.rows) {
                    workData = String.valueOf(workData) + AppxToolkit.byteToString(charArray[this.row + workRow], this.col, this.cols, 2);
                    ++workRow;
                }
                break block0;
            }
        }
        this.setData(workData);
    }

    public void setData(String str) {
        this.data = AppxToolkit.stringToBytes(str, 4);
        this.dataLen = (short)this.data.length;
    }

    public void setGroup(short newGroup) {
        this.group = newGroup;
    }

    public void setGuiField(JComponent field) {
        this.guiField = field;
    }

    public void setMaxLen(int len) {
        this.maxLen = (short)len;
    }

    public void setOriginalCol(int newOriginalCol) {
        this.originalCol = newOriginalCol > 0 ? newOriginalCol : 1;
    }

    public void setOriginalRow(int newOriginalRow) {
        this.originalRow = newOriginalRow;
    }

    public void setRow(int r) {
        this.row = r;
    }

    public void setRows(int r) {
        this.rows = (byte)r;
    }

    public void setSpecial(byte newSpecial) {
        this.special = newSpecial;
        if (this.fieldType == 70 && (this.special & 2) == 0) {
            this.fieldType = 10;
            this.maxLen = 0;
        } else if (this.fieldType == 10 && (this.special & 2) != 0) {
            this.fieldType = 70;
        }
    }

    public void setSpecial(int newSpecial) {
        this.setSpecial((byte)newSpecial);
    }

    public void setVer(byte[] newVer) {
        this.ver = newVer;
    }

    public String toString() {
        return "MFld[pos/size=" + this.row + "," + this.col + "/" + this.rows + "," + this.cols + ", type=" + this.type + ", just=" + this.just + ", hi/lo=" + this.hi + "/" + this.lo + ", option=" + "0x" + Integer.toHexString(this.options) + ", special=" + "0x" + Integer.toHexString(this.special) + ", dataLen=" + this.dataLen + ", data=" + this.getData() + ", wdgt=" + this.widgetData + "]";
    }

    public void write(DataOutputStream out) {
    }

    public MFld(boolean fldWidgets) {
        this.readFldWidgets = fldWidgets;
    }

    public int getEncodingType() {
        return this.encoding;
    }
}

