/*
 * Decompiled with CFR 0.152.
 */
package comm.msg;

import comm.msg.Message;
import doc.AppxToolkit;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class MDragAndDrop
extends Message {
    public static final byte type = 92;
    private int row;
    private int col;
    private int parentType;
    private String path;
    private String name;
    private String ext;
    private String mtype;
    private int size;
    private static final int PATH_MAX = 512;
    private static final int NAME_MAX = 256;
    private static final int EXT_MAX = 16;
    private static final int TYPE_MAX = 64;
    private static final int PROP_KEY_LEN = 32;
    private static final int PROP_VAL_LEN = 256;
    private HashMap<String, String> props = new HashMap();

    public MDragAndDrop(int row, int col, int prntType, String path, String name, String ext, String mtype, int size, HashMap<String, String> props) {
        this.row = row;
        this.col = col;
        this.path = path;
        this.name = name;
        this.ext = ext;
        this.mtype = mtype;
        this.size = size;
        this.props = props;
        this.parentType = prntType;
    }

    @Override
    public int length() {
        return 8;
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.row + 1);
        out.writeInt(this.col + 1);
        out.writeInt(this.parentType);
        this.streamBytes(out, this.path, 512);
        this.streamBytes(out, this.name, 256);
        this.streamBytes(out, this.ext, 16);
        this.streamBytes(out, this.mtype, 64);
        out.writeInt(this.size);
        if (this.props != null) {
            out.writeShort((short)this.props.size());
            for (Map.Entry<String, String> me : this.props.entrySet()) {
                this.streamBytes(out, me.getKey().toString(), 32);
                this.streamBytes(out, me.getValue().toString(), 256);
            }
        } else {
            out.writeShort(0);
        }
    }

    private void streamBytes(DataOutputStream out, String value, int max) throws IOException {
        value = value.substring(0, Math.min(value.length(), max));
        byte[] bytes = AppxToolkit.stringToBytes(value, 4);
        out.writeShort((short)bytes.length);
        if (value.length() > 0) {
            out.write(bytes);
        }
    }
}

