/*
 * Decompiled with CFR 0.152.
 */
package comm.msg;

import comm.IOHandler;
import comm.msg.MBox;
import comm.msg.MBtn;
import comm.msg.MButton;
import comm.msg.MRCBlock;
import comm.msg.Message;
import doc.Document;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public class MDisplay
extends Message {
    public static final String what_str = "@(#)Appx $Header: /src/cvs/joe/comm/msg/MDisplay.java,v 1.1.2.11 2013/06/20 00:14:58 pete Exp $";
    public static final byte type = 36;
    public byte[] terminal = new byte[4];
    public byte mode;
    public byte[] keymap = new byte[4];
    public MRCBlock cursor;
    public MRCBlock cursorAlt;
    public int timeout;
    public int timeout_opt;
    public byte[] charId = new byte[4];
    public int option;
    public int optionAlt;
    public int status;
    public int boxCount;
    public byte[] boxPtr = new byte[4];
    public int[] boxAdjRow;
    public int[] boxAdjCol;
    public Vector<MBox> boxBlock;
    private MButton button = null;
    private boolean readBoxWidgets = false;
    private boolean foundIlfDebugger = false;

    @Override
    public int length() {
        return 44 + this.boxCount * 20;
    }

    public void read(DataInputStream in) throws IOException {
        int boxId = 0;
        MBox box = null;
        MBox boxLast = null;
        MBox scrollBox = null;
        MBox lastGuiBox = null;
        this.cursorAlt = new MRCBlock(-1, -1);
        this.optionAlt = 0;
        in.readFully(this.terminal);
        this.mode = in.readByte();
        in.read();
        in.read();
        in.read();
        in.readFully(this.keymap);
        this.cursor = new MRCBlock();
        this.cursor.read(in);
        this.timeout = in.readInt();
        in.readFully(this.charId);
        this.option = in.readInt();
        this.status = in.readInt();
        this.boxCount = in.readInt();
        in.readFully(this.boxPtr);
        this.timeout_opt = this.timeout == 0 ? 0 : this.option;
        this.boxAdjRow = new int[this.boxCount];
        this.boxAdjCol = new int[this.boxCount];
        this.boxBlock = new Vector(this.boxCount);
        int i = 0;
        while (i < this.boxCount) {
            boxLast = box;
            box = new MBox(this.readBoxWidgets);
            int n = boxId;
            boxId = (short)(n + 1);
            box.boxId = (short)n;
            box.read(in);
            if (((long)box.mask & 0x8000000L) == 0x8000000L) {
                lastGuiBox = box;
            } else if (((long)box.mask & 0x40000L) == 262144L && lastGuiBox != null && ((long)lastGuiBox.mask & 0x40000L) != 262144L) {
                lastGuiBox.mask = (int)((long)lastGuiBox.mask | 0x40000L);
            }
            if (this.button != null && this.button.crazyBlocks != null && this.button.crazyBlocks.size() > 0) {
                int idx = this.button.crazyBlocks.size() - 1;
                while (idx >= 0) {
                    MBtn btn = this.button.crazyBlocks.elementAt(idx);
                    if (btn.box == box.boxId) {
                        box.widgetData = btn.widgetData;
                        this.button.crazyBlocks.removeElementAt(idx);
                    }
                    --idx;
                }
            }
            this.boxAdjRow[i] = box.begin.row;
            this.boxAdjCol[i] = box.begin.column;
            if (box.begin.row <= Document.sizMax.height - 4) {
                if (box.end.column > Document.sizMax.width - 1) {
                    box.end.column = Document.sizMax.width - 1;
                }
                if (box.end.row > Document.sizMax.height - 4) {
                    box.end.row = Document.sizMax.height - 4;
                }
                boxLast = this.boxBlock.size() > 0 ? this.boxBlock.lastElement() : null;
                if ((box.mask & 0x20000) == 131072 && boxLast != null) {
                    boxLast.addRegion(box);
                } else if (boxLast != null && box.begin.equals(boxLast.begin) && box.end.equals(boxLast.end) && !box.isBorderBox()) {
                    boxLast.mergeMask(box.mask);
                    if (box.widgetData != null) {
                        if (boxLast.widgetData == null) {
                            boxLast.widgetData = box.widgetData;
                        } else if (boxLast.boxId + 1 < box.boxId) {
                            boxLast.widgetData = box.widgetData;
                        } else {
                            boxLast.widgetData.merge(box.widgetData);
                            if (boxLast.widgetData.wWidgetType != null && boxLast.widgetData.wWidgetType == 200) {
                                boxLast.widgetData.wWidgetType = null;
                            }
                        }
                    }
                } else {
                    this.boxBlock.addElement(box);
                    if (this.foundIlfDebugger) {
                        if (this.boxBlock.size() == 4) {
                            MBox ilfMainBox = this.boxBlock.elementAt(0);
                            MBox ilfDataBox = this.boxBlock.elementAt(2);
                            MBox ilfFootBox = box;
                            if (ilfMainBox.begin.row == 0 && ilfMainBox.begin.column == 0 && ilfMainBox.end.row == ilfDataBox.end.row && ilfFootBox.end.row - ilfDataBox.end.row == 2) {
                                ilfMainBox.end.row = ilfFootBox.end.row;
                                ilfFootBox.removeMask(0x40000000L);
                            }
                        }
                        this.foundIlfDebugger = false;
                    }
                    if (this.boxBlock.size() > 1 && (box.mask & 0x10000) != 0) {
                        MBox lastBox = this.boxBlock.elementAt(this.boxBlock.size() - 2);
                        if (box.begin.column == lastBox.begin.column && box.end.column == lastBox.end.column) {
                            MBox workBox;
                            if (lastBox.begin.row <= box.begin.row && lastBox.end.row >= box.end.row) {
                                lastBox.mergeMask(-2013265920);
                                if ((box.mask & 0x8000000) != 0) {
                                    box.mergeMask(1);
                                }
                                box.removeMask(-2013265920);
                            } else if (this.boxBlock.size() > 2) {
                                workBox = this.boxBlock.elementAt(this.boxBlock.size() - 3);
                                if (workBox.begin.column == box.begin.column && workBox.end.column == box.end.column) {
                                    workBox.begin.row = Math.min(workBox.begin.row, lastBox.begin.row);
                                    workBox.end.row = Math.max(workBox.end.row, Math.max(box.end.row, lastBox.end.row));
                                    workBox.mergeMask(-2013265920);
                                    lastBox.removeMask(-2013265920);
                                    lastBox.mergeMask(1);
                                    box.removeMask(-2013265920);
                                    box.mergeMask(1);
                                    if ((lastBox.mask & 0x10000) != 0) {
                                        box.removeMask(65536);
                                        box.removeMask(0x40000000L);
                                        this.foundIlfDebugger = true;
                                    }
                                }
                            } else if (this.boxBlock.size() > 1) {
                                workBox = lastBox;
                                if (workBox.begin.column == box.begin.column && workBox.end.column == box.end.column) {
                                    workBox.begin.row = Math.min(workBox.begin.row, box.begin.row);
                                    workBox.end.row = Math.max(workBox.end.row, box.end.row);
                                    workBox.mergeMask(-2013265920);
                                    box.removeMask(-2013265920);
                                    box.mergeMask(1);
                                }
                            }
                        }
                    }
                    if ((box.mask & 0x8000000) != 0) {
                        scrollBox = null;
                    }
                    if ((box.mask & 0x10000) != 0) {
                        scrollBox = box;
                    } else if (scrollBox != null && box.begin.row <= scrollBox.begin.row && box.begin.column <= scrollBox.begin.column && box.end.row >= scrollBox.end.row && box.end.column >= scrollBox.end.column) {
                        scrollBox.removeMask(65536);
                        scrollBox = null;
                    } else if (this.boxBlock.size() > 2 && scrollBox != null && box.begin.row - 1 == scrollBox.end.row && box.begin.column == scrollBox.begin.column && box.end.row == Document.sizMax.height - 4 && box.end.column == scrollBox.end.column) {
                        MBox workBox = this.boxBlock.elementAt(this.boxBlock.size() - 3);
                        workBox.begin.row = Math.min(workBox.begin.row, box.begin.row);
                        workBox.end.row = Math.max(workBox.end.row, box.end.row);
                        workBox.mergeMask(-2013265920);
                        box.removeMask(-2013265920);
                        box.mergeMask(1);
                    }
                }
            }
            ++i;
        }
    }

    public void write(DataOutputStream out) throws IOException {
        if (this.cursor.row < 0) {
            this.cursor.row = 0;
        }
        if (this.cursor.column < 0) {
            this.cursor.column = 0;
        }
        out.write(this.terminal);
        out.write(this.mode);
        out.write(0);
        out.write(0);
        out.write(0);
        out.write(this.keymap);
        this.cursor.write(out);
        out.writeInt(this.timeout);
        out.write(this.charId);
        out.writeInt(this.option);
        out.writeInt(this.status);
        out.writeInt(this.boxCount);
        out.write(this.boxPtr);
        if (IOHandler.currentHandler.checkForFeature(0x40000000)) {
            if (this.cursorAlt.row < -1) {
                this.cursorAlt.row = -1;
            }
            if (this.cursorAlt.column < -1) {
                this.cursorAlt.column = -1;
            }
            this.cursorAlt.write(out);
            out.writeInt(this.optionAlt);
        }
    }

    public MDisplay(boolean boxWidgets, MButton btn) {
        this.readBoxWidgets = boxWidgets;
        this.button = btn;
    }
}

