/*
 * Decompiled with CFR 0.152.
 */
package comm.msg;

import comm.msg.Compressor;
import comm.msg.Message;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MDataBlock
extends Message {
    public static final String what_str = "@(#)Appx $Header: /src/cvs/joe/comm/msg/MDataBlock.java,v 1.1.2.2 2006/07/21 17:05:36 pete Exp $";
    private byte[] byteData;
    private short[] shortData;
    private int[] intData;
    private int compressedLength;
    private boolean isAlreadyCompressed;

    public MDataBlock(byte[] data) {
        this.isAlreadyCompressed = false;
        this.byteData = data;
    }

    public MDataBlock(byte[] data, boolean alreadyCompressed) {
        this.isAlreadyCompressed = alreadyCompressed;
        this.byteData = data;
    }

    public MDataBlock(int[] data) {
        this.isAlreadyCompressed = false;
        this.intData = data;
    }

    @Override
    public int length() {
        return this.compressedLength;
    }

    public byte[] readBytes(DataInputStream in) throws IOException {
        this.compressedLength = in.readShort();
        byte[] data = new byte[this.compressedLength];
        in.readFully(data);
        return Compressor.uncompress(data);
    }

    public int[] readInts(DataInputStream in) throws IOException {
        this.compressedLength = in.readShort();
        int[] data = new int[this.compressedLength / 4];
        int i = 0;
        while (i < this.compressedLength / 4) {
            data[i] = in.readInt();
            ++i;
        }
        return Compressor.uncompress(data);
    }

    public short[] readShorts(DataInputStream in) throws IOException {
        this.compressedLength = in.readShort();
        short[] data = new short[this.compressedLength / 2];
        int i = 0;
        while (i < this.compressedLength / 2) {
            data[i] = in.readShort();
            ++i;
        }
        return Compressor.uncompress(data);
    }

    public int[] readShortsToInts(DataInputStream in) throws IOException {
        this.compressedLength = in.readShort();
        int[] data = new int[this.compressedLength / 2];
        int i = 0;
        while (i < this.compressedLength / 2) {
            data[i] = in.readShort();
            ++i;
        }
        return Compressor.uncompress(data);
    }

    public MDataBlock(short[] data) {
        this.isAlreadyCompressed = false;
        this.shortData = data;
    }

    public MDataBlock() {
        this.isAlreadyCompressed = false;
    }

    public void write(DataOutputStream out) throws IOException {
        if (this.byteData != null) {
            byte[] tmp = this.isAlreadyCompressed ? this.byteData : Compressor.compress(this.byteData);
            this.compressedLength = tmp.length;
            out.writeShort(this.compressedLength);
            out.write(tmp);
        } else if (this.shortData != null) {
            short[] tmp = Compressor.compress(this.shortData);
            out.writeShort(this.shortData.length * 2);
            int i = 0;
            while (i < this.shortData.length) {
                out.writeShort(tmp[i]);
                ++i;
            }
        } else if (this.intData != null) {
            int[] tmp = Compressor.compress(this.intData);
            out.writeShort(this.shortData.length * 4);
            int i = 0;
            while (i < this.intData.length) {
                out.writeInt(tmp[i]);
                ++i;
            }
        } else {
            out.writeShort(0);
        }
    }
}

