/*
 * Decompiled with CFR 0.152.
 */
package comm.msg;

import comm.msg.MRCBlock;
import comm.msg.MWidget;
import comm.msg.Message;
import doc.Document;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public class MBox
extends Message {
    public static final String what_str = "@(#)Appx $Header: /src/cvs/joe/comm/msg/MBox.java,v 1.1.2.6 2010/07/21 13:35:05 pete Exp $";
    public static final int BORD_REMOVED = 1;
    public static final int SCROLL = 65536;
    public static final int SCROLL_REG = 131072;
    public static final int SCROLL_ACT = 262144;
    public static final int SCAN = 524288;
    public static final int BORDER = 0x8000000;
    public static final int AROUND = Integer.MIN_VALUE;
    public static final long OBSCURE = 0x40000000L;
    public MRCBlock begin;
    public MRCBlock end;
    public int mask;
    public int regionCount;
    public int currentRegion;
    public long attr;
    public String label;
    public short boxId;
    public MWidget widgetData = null;
    public Vector<MBox> regions = new Vector();
    private boolean readBoxWidgets = false;

    public void addRegion(MBox region) {
        this.regions.addElement(region);
    }

    public long getAttributes() {
        return this.attr;
    }

    public MBox(int beginR, int beginC, int endR, int endC, int mask, int regionCount, int currentRegion) {
        this.begin = new MRCBlock(beginR, beginC);
        this.end = new MRCBlock(endR, endC);
        this.mask = mask;
        this.regionCount = regionCount;
        this.currentRegion = currentRegion;
    }

    public boolean isBorderBox() {
        return (this.mask & 0x8000000) == 0x8000000;
    }

    @Override
    public int length() {
        return this.begin.length() + this.end.length() + 4;
    }

    public void mergeMask(int newMask) {
        this.mask |= newMask;
    }

    public void read(DataInputStream in) throws IOException {
        this.begin = new MRCBlock();
        this.begin.read(in);
        this.end = new MRCBlock();
        this.end.read(in);
        this.mask = in.readInt();
        this.regionCount = 0;
        this.currentRegion = 0;
        if (this.readBoxWidgets) {
            this.widgetData = new MWidget();
            this.widgetData.read(in);
            if (this.widgetData.widgetLen == 0) {
                this.widgetData = null;
            } else {
                if (this.widgetData.wBoxNumber != null) {
                    this.boxId = this.widgetData.wBoxNumber.shortValue();
                }
                if (this.widgetData != null && this.widgetData.widgetData.indexOf("SBN=") != 1) {
                    this.mask |= 0x8000000;
                    this.mask |= Integer.MIN_VALUE;
                }
            }
        }
    }

    public void removeMask(int newMask) {
        int filter = ~newMask;
        this.mask &= filter;
    }

    public void removeMask(long newMask) {
        long filter = newMask ^ 0xFFFFFFFFFFFFFFFFL;
        this.mask = (int)((long)this.mask & filter);
    }

    public void setAttributes(long att) {
        this.attr = att;
    }

    public String toString() {
        String result = "MBox(";
        if (this.boxId < 10) {
            result = String.valueOf(result) + " ";
        }
        result = String.valueOf(result) + this.boxId + ")[b=" + this.begin + ",e=" + this.end + ";" + Integer.toHexString(this.mask) + ", " + Document.decodeChrBitsBoxes(this.mask) + ", widgetData=" + this.widgetData + "]";
        return result;
    }

    public void write(DataOutputStream out) throws IOException {
        this.begin.write(out);
        this.end.write(out);
        out.writeInt(this.mask);
    }

    public MBox(boolean boxWidgets) {
        this.readBoxWidgets = boxWidgets;
    }
}

