/*
 * Decompiled with CFR 0.152.
 */
package comm.msg;

import comm.msg.Message;
import doc.AppxToolkit;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MArgBlock
extends Message {
    public static final String what_str = "@(#)Appx $Header: /src/cvs/joe/comm/msg/MArgBlock.java,v 1.1.2.3 2011/12/10 19:29:55 pete Exp $";
    private int dataType;
    private int dataLength;
    private Object dataObject;
    public static final int BOOLEAN = 1;
    public static final int BYTE = 2;
    public static final int CHAR = 3;
    public static final int DOUBLE = 4;
    public static final int FLOAT = 5;
    public static final int INT = 6;
    public static final int LONG = 7;
    public static final int SHORT = 8;
    public static final int UNSIGNED_BYTE = 9;
    public static final int UNSIGNED_SHORT = 10;
    public static final int STRING = 11;
    public static final int DATE = 12;

    public int getDataLength() {
        return this.dataLength;
    }

    public Object getDataObject() {
        return this.dataObject;
    }

    public int getDataType() {
        return this.dataType;
    }

    @Override
    public int length() {
        return 33;
    }

    public void read(DataInputStream in) throws IOException {
        this.dataType = in.readInt();
        this.dataLength = in.readInt();
        switch (this.dataType) {
            case 1: {
                this.dataObject = new Boolean(in.readBoolean());
                break;
            }
            case 2: {
                this.dataObject = new Byte(in.readByte());
                break;
            }
            case 3: {
                this.dataObject = new Character(in.readChar());
                break;
            }
            case 4: {
                this.dataObject = new Double(in.readDouble());
                break;
            }
            case 5: {
                this.dataObject = new Float(in.readFloat());
                break;
            }
            case 6: {
                this.dataObject = new Integer(in.readInt());
                break;
            }
            case 7: {
                this.dataObject = new Long(in.readLong());
                break;
            }
            case 8: {
                this.dataObject = new Short(in.readShort());
                break;
            }
            case 9: {
                this.dataObject = new Integer(in.readUnsignedByte());
                break;
            }
            case 10: {
                this.dataObject = new Integer(in.readUnsignedShort());
                break;
            }
            case 11: {
                byte[] tmp = new byte[this.dataLength];
                in.readFully(tmp);
                int i = this.dataLength;
                while (i > 0 && tmp[i - 1] == 32) {
                    --i;
                }
                this.dataObject = AppxToolkit.byteToString(tmp, 0, i, 1);
                break;
            }
            case 12: {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmssSS");
                byte[] tmpDate = new byte[this.dataLength];
                in.readFully(tmpDate);
                this.dataObject = formatter.parse(AppxToolkit.byteToString(tmpDate, 1), null);
            }
        }
    }

    public void setDataLength(int len) {
        this.dataLength = len;
    }

    public void setDataObject(Object obj) {
        this.dataObject = obj;
        this.dataType = 11;
        this.dataLength = ((String)obj).length();
    }

    public void setDataType(int type) {
        this.dataType = type;
    }

    public String toString() {
        return "MApp[" + this.getDataType() + "," + this.getDataType() + "," + this.getDataObject() + "]";
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.dataType);
        out.writeInt(this.dataLength);
        switch (this.dataType) {
            case 1: {
                out.writeBoolean((Boolean)this.dataObject);
                break;
            }
            case 2: {
                out.writeByte(((Byte)this.dataObject).byteValue());
                break;
            }
            case 3: {
                out.writeChar(((Character)this.dataObject).charValue());
                break;
            }
            case 4: {
                out.writeDouble((Double)this.dataObject);
                break;
            }
            case 5: {
                out.writeFloat(((Float)this.dataObject).floatValue());
                break;
            }
            case 6: {
                out.writeInt((Integer)this.dataObject);
                break;
            }
            case 7: {
                out.writeLong((Long)this.dataObject);
                break;
            }
            case 8: {
                out.writeShort(((Short)this.dataObject).shortValue());
                break;
            }
            case 9: {
                out.writeInt((Integer)this.dataObject);
                break;
            }
            case 10: {
                out.writeInt((Integer)this.dataObject);
                break;
            }
            case 11: {
                out.writeBytes((String)this.dataObject);
                break;
            }
            case 12: {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmssSS");
                String tmpString = formatter.format((Date)this.dataObject);
                byte[] tmpDate = new byte[16];
                try {
                    AppxToolkit.stringToByteCopy(tmpString, tmpDate, (byte)32);
                }
                catch (IndexOutOfBoundsException e) {
                    System.err.println("date string too long, exception=" + e);
                }
                out.write(tmpDate);
            }
        }
    }
}

