/*
 * Decompiled with CFR 0.152.
 */
package comm.msg;

import comm.msg.MRCBlock;
import comm.msg.Message;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Box
extends Message {
    public static final String what_str = "@(#)Appx $Header: /src/cvs/joe/comm/msg/Box.java,v 1.1.2.1 2003/02/21 18:43:53 pete Exp $";
    public static final int SCROLL = 65536;
    public static final int SCROLL_REG = 131072;
    public static final int SCROLL_ACT = 262144;
    public static final int SCAN = 524288;
    public static final int BORDER = 0x8000000;
    public static final int AROUND = Integer.MIN_VALUE;
    public MRCBlock begin;
    public MRCBlock end;
    public int mask;
    public int regionCount;
    public int currentRegion;

    public Box(int beginR, int beginC, int endR, int endC, int mask, int regionCount, int currentRegion) {
        this.begin = new MRCBlock(beginR, beginC);
        this.end = new MRCBlock(endR, endC);
        this.mask = mask;
        this.regionCount = regionCount;
        this.currentRegion = currentRegion;
    }

    @Override
    public int length() {
        return this.begin.length() + this.end.length() + 4;
    }

    public void read(DataInputStream in) throws IOException {
        this.begin = new MRCBlock();
        this.begin.read(in);
        this.end = new MRCBlock();
        this.end.read(in);
        this.mask = in.readInt();
        this.regionCount = 0;
        this.currentRegion = 0;
    }

    public String toString() {
        return "Box[" + this.begin + "," + this.end + ";" + this.mask + "," + this.regionCount + "," + this.currentRegion + "]";
    }

    public Box() {
    }

    public void write(DataOutputStream out) throws IOException {
        this.begin.write(out);
        this.end.write(out);
        out.writeInt(this.mask);
    }
}

