/*
 * Decompiled with CFR 0.152.
 */
package comm;

import comm.Transaction;
import comm.msg.MStatus;
import debug.AppxDebug;
import doc.AppxToolkit;
import doc.Globals;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.Timer;

public class TSendFile
extends Transaction {
    public static final byte type = 71;
    public static final String what_str = "@(#)Appx $Header: /src/cvs/joe/comm/TSendFile.java,v 1.1.2.14 2011/12/10 19:29:55 pete Exp $";
    int bytesRead = 0;
    String dst;
    int fileSize = 0;
    int pctComplete = 0;
    String sizeString;
    private Timer updateTimer;

    @Override
    public void start() throws IOException {
        AppxDebug.log(16384, "TSendFile.start() Server request to Send a file to the Client", 1);
        byte[] buf = new byte[2048];
        this.fileSize = this.in.readInt();
        this.sizeString = this.fileSize > 1000000 ? new String(String.valueOf(Integer.toString(this.fileSize / 1000000)) + "M") : (this.fileSize > 1000 ? new String(String.valueOf(Integer.toString(this.fileSize / 1000)) + "K") : new String(Integer.toString(this.fileSize)));
        int dstLen = this.in.readInt();
        byte[] dstBuf = new byte[dstLen];
        this.in.readFully(dstBuf);
        this.dst = AppxToolkit.byteToString(dstBuf, 1);
        AppxDebug.log(16384, "TSendFile.start() dst=" + this.dst, 1);
        if (dstLen == 0) {
            JFileChooser chooser = new JFileChooser();
            chooser.rescanCurrentDirectory();
            int retVal = chooser.showDialog(view, "Save");
            if (retVal == 0) {
                File newfile = chooser.getSelectedFile();
                this.dst = newfile.toString();
            }
        } else {
            this.dst = Globals.expandAppxString(this.dst, true);
        }
        AppxDebug.log(16384, "TSendFile.start() expanded dst=" + this.dst, 1);
        try {
            FileOutputStream fo = new FileOutputStream(this.dst);
            MStatus stat = new MStatus(3, true);
            stat.write(this.out);
            int work32 = this.in.readInt();
            AppxDebug.log(16384, "recv: " + this.dst + ", 0% of " + this.sizeString + " bytes read", 1);
            view.setStatusText("recv: " + this.dst + ", 0% of " + this.sizeString + " bytes read", 0);
            view.paintNow();
            this.updateTimer = new Timer(750, new TSendFileTimer());
            this.updateTimer.start();
            int loops = 0;
            int steps = this.fileSize / 20;
            int blocks = 0;
            while (work32 != 0) {
                this.in.readFully(buf, 0, work32);
                this.bytesRead += work32;
                fo.write(buf, 0, work32);
                work32 = this.in.readInt();
                if ((loops += work32) <= steps && ++blocks <= 500) continue;
                try {
                    this.pctComplete = (int)((float)this.bytesRead / (float)this.fileSize * 100.0f);
                    AppxDebug.log(16384, "recv: " + this.dst + ", " + this.pctComplete + "% of " + this.sizeString + " bytes read", 1);
                    view.setStatusText("recv: " + this.dst + ", " + this.pctComplete + "% of " + this.sizeString + " bytes read", this.pctComplete);
                    view.paintNow();
                }
                catch (Exception e) {
                    System.err.println("e=" + e);
                }
                loops = 0;
                blocks = 0;
            }
            this.updateTimer.stop();
            AppxDebug.log(16384, "recv: " + this.dst + ", 100% of " + this.sizeString + " bytes read", 1);
            view.setStatusText("recv: " + this.dst + ", 100% of " + this.sizeString + " bytes read", 100);
            fo.close();
            this.out.writeInt(this.dst.length());
            this.out.writeBytes(this.dst);
            stat = new MStatus(3, true);
            stat.write(this.out);
        }
        catch (Exception e) {
            System.err.println("TSendFile.start() Exception=" + e);
            MStatus stat = new MStatus(3, false);
            stat.write(this.out);
        }
    }

    class TSendFileTimer
    implements ActionListener {
        TSendFileTimer() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                TSendFile.this.pctComplete = (int)((float)TSendFile.this.bytesRead / (float)TSendFile.this.fileSize * 100.0f);
                view.setStatusText("recv: " + TSendFile.this.dst + ", " + TSendFile.this.pctComplete + "% of " + TSendFile.this.sizeString + " bytes read", TSendFile.this.pctComplete);
                view.repaint();
            }
            catch (Exception e) {
                System.err.println("e=" + e);
            }
        }
    }
}

