/*
 * Decompiled with CFR 0.152.
 */
package comm;

import comm.Transaction;
import doc.AppxToolkit;
import java.io.FileOutputStream;
import java.util.StringTokenizer;

public class TResource
extends Transaction {
    public static final String what_str = "@(#)Appx $Header: /src/cvs/joe/comm/TResource.java,v 1.1.2.6 2011/12/10 19:29:55 pete Exp $";
    public static final byte type = 83;
    public static final byte RES_LOC_CLI_URL = 1;
    public static final byte RES_LOC_CLI_FI = 2;
    public static final byte RES_LOC_DIRECT = 3;
    public static final byte RES_LOC_SRV_URL = 4;
    public static final byte RES_LOC_SRV_FI = 5;
    public static final byte RES_LOC_DSGN = 6;
    public static final byte RES_EXT_JPG = 1;
    public static final byte RES_EXT_GIF = 2;
    String sig;
    String path;
    byte[] ap = new byte[3];
    byte[] ver = new byte[2];
    byte[] cacheId = new byte[8];
    byte state;
    int ctx;
    short id;
    byte res_type;
    byte loc_type;
    byte ext;
    int len;
    String data;
    String cacheName;

    private void fillBytes(byte[] dst, String src) {
        int dstLen = dst.length;
        int srcLen = src.length();
        int i = 0;
        while (i < dstLen) {
            dst[i] = i < srcLen ? (int)src.charAt(i) : 32;
            ++i;
        }
    }

    public String getResource() {
        return this.data;
    }

    public TResource(String cacheSig, String group, String cachePath) {
        this.sig = cacheSig;
        StringTokenizer tokens = new StringTokenizer(cacheSig, ".");
        this.fillBytes(this.ap, (String)tokens.nextElement());
        this.fillBytes(this.ver, (String)tokens.nextElement());
        this.cacheName = (String)tokens.nextElement();
        this.fillBytes(this.cacheId, this.cacheName);
        this.state = Byte.decode("0x" + (String)tokens.nextElement());
        tokens = new StringTokenizer(group, ".");
        this.ctx = Integer.decode("0x" + (String)tokens.nextElement());
        this.id = Short.decode("0x" + (String)tokens.nextElement());
        this.res_type = Byte.decode("0x" + (String)tokens.nextElement());
        this.path = cachePath;
    }

    private void read() {
        try {
            this.in.readFully(this.ap);
            this.in.readFully(this.ver);
            this.in.readFully(this.cacheId);
            this.state = this.in.readByte();
            this.loc_type = this.in.readByte();
            this.ext = this.in.readByte();
            this.len = this.in.readInt();
            switch (this.loc_type) {
                case 1: 
                case 2: {
                    byte[] buf = new byte[this.len];
                    this.in.readFully(buf);
                    this.data = AppxToolkit.byteToString(buf, 1);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    this.data = String.valueOf(this.path) + (String.valueOf(AppxToolkit.byteToString(this.ap, 1)) + AppxToolkit.byteToString(this.ver, 1) + this.cacheName).toLowerCase();
                    switch (this.ext) {
                        case 1: {
                            this.data = String.valueOf(this.data) + ".dat";
                            break;
                        }
                        case 2: {
                            this.data = String.valueOf(this.data) + ".dat";
                            break;
                        }
                        default: {
                            this.data = String.valueOf(this.data) + ".dat";
                        }
                    }
                    byte[] buf = new byte[2048];
                    FileOutputStream fo = new FileOutputStream(this.data);
                    int worklen = this.len;
                    int block = 2048;
                    while (worklen != 0) {
                        block = worklen >= 2048 ? 2048 : worklen;
                        this.in.readFully(buf, 0, block);
                        fo.write(buf, 0, block);
                        worklen -= block;
                    }
                    fo.close();
                    break;
                }
                default: {
                    int work32 = this.len;
                    while (work32 != 0) {
                        this.in.readByte();
                        --work32;
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println("TResource.read Error, e=" + e);
        }
    }

    @Override
    public void start() {
        this.write();
        this.read();
    }

    private void write() {
        try {
            int filler = 32;
            this.out.write(this.ap);
            this.out.write(this.ver);
            this.out.write(this.cacheId);
            this.out.write(this.state);
            this.out.writeShort(this.id);
            this.out.writeInt(this.ctx);
            this.out.write(this.res_type);
            this.out.write(filler);
            this.out.write(filler);
            this.out.write(filler);
        }
        catch (Exception e) {
            System.err.println("TResource.write Error, e=" + e);
        }
    }
}

