/*
 * Decompiled with CFR 0.152.
 */
package comm;

import comm.Transaction;
import comm.msg.MStatus;
import debug.AppxDebug;
import doc.AppxToolkit;
import doc.Document;
import doc.Globals;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.Timer;

public class TRecvFile
extends Transaction {
    public static final byte type = 73;
    public static final String what_str = "@(#)Appx $Header: /src/cvs/joe/comm/TRecvFile.java,v 1.1.2.13 2011/12/10 19:29:55 pete Exp $";
    protected int bytesRead = 0;
    int fileSize = 0;
    int pctComplete = 0;
    String sizeString;
    String src;
    private Timer updateTimer;

    @Override
    public void start() throws IOException {
        AppxDebug.log(16384, "TRecvFile.start() Server request to Receive a file from the Client", 1);
        byte[] buf = new byte[2048];
        int work32 = this.in.readInt();
        if (work32 == 0) {
            JFileChooser chooser = new JFileChooser();
            chooser.rescanCurrentDirectory();
            Document.setLocked(false);
            int retVal = chooser.showDialog(view, "Open");
            Document.setLocked(true);
            if (retVal == 0) {
                File newfile = chooser.getSelectedFile();
                this.src = newfile.toString();
            }
        } else {
            byte[] srcBuf = new byte[work32];
            this.in.readFully(srcBuf);
            this.src = AppxToolkit.byteToString(srcBuf, 4);
            AppxDebug.log(16384, "TRecvFile.start() src=" + this.src, 1);
            this.src = Globals.expandAppxString(this.src, true);
        }
        AppxDebug.log(16384, "TRecvFile.start() expanded src=" + this.src, 1);
        try {
            File srcFile = new File(this.src);
            this.fileSize = new Long(srcFile.length()).intValue();
            this.sizeString = this.fileSize > 1000000 ? new String(String.valueOf(Integer.toString(this.fileSize / 1000000)) + "M") : (this.fileSize > 1000 ? new String(String.valueOf(Integer.toString(this.fileSize / 1000)) + "K") : new String(Integer.toString(this.fileSize)));
            FileInputStream fi = new FileInputStream(this.src);
            MStatus stat = new MStatus(3, true);
            stat.write(this.out);
            this.out.writeInt(this.fileSize);
            AppxDebug.log(16384, "send: " + this.src + ", 0% of " + this.sizeString + " bytes sent", 1);
            view.setStatusText("send: " + this.src + ", 0% of " + this.sizeString + " bytes sent", 0);
            view.paintNow();
            work32 = fi.read(buf);
            this.updateTimer = new Timer(750, new TRecvFileTimer());
            this.updateTimer.start();
            int loops = 0;
            int steps = this.fileSize / 20;
            int blocks = 0;
            while (work32 > 0) {
                this.out.writeInt(work32);
                this.out.write(buf, 0, work32);
                this.bytesRead += work32;
                work32 = fi.read(buf);
                if ((loops += work32) <= steps && blocks <= 500) continue;
                try {
                    this.out.flush();
                    this.pctComplete = (int)((float)this.bytesRead / (float)this.fileSize * 100.0f);
                    AppxDebug.log(16384, "send: " + this.src + ", " + this.pctComplete + "% of " + this.sizeString + " bytes sent", 1);
                    view.setStatusText("send: " + this.src + ", " + this.pctComplete + "% of " + this.sizeString + " bytes sent", this.pctComplete);
                    view.paintNow();
                }
                catch (Exception e) {
                    System.err.println("e=" + e);
                }
                loops = 0;
                blocks = 0;
            }
            this.out.writeInt(0);
            this.updateTimer.stop();
            AppxDebug.log(16384, "send: " + this.src + ", 100% of " + this.sizeString + " bytes sent", 1);
            view.setStatusText("send: " + this.src + ", 100% of " + this.sizeString + " bytes sent", 100);
            view.paintNow();
            fi.close();
            this.out.writeInt(this.src.length());
            this.out.writeBytes(this.src);
            stat = new MStatus(3, true);
            stat.write(this.out);
        }
        catch (Exception e) {
            MStatus stat = new MStatus(3, false);
            stat.write(this.out);
        }
    }

    class TRecvFileTimer
    implements ActionListener {
        TRecvFileTimer() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                TRecvFile.this.pctComplete = (int)((float)TRecvFile.this.bytesRead / (float)TRecvFile.this.fileSize * 100.0f);
                view.setStatusText("send: " + TRecvFile.this.src + ", " + TRecvFile.this.pctComplete + "% of " + TRecvFile.this.sizeString + " bytes sent", TRecvFile.this.pctComplete);
                view.repaint();
            }
            catch (Exception e) {
                System.err.println("e=" + e);
            }
        }
    }
}

