/*
 * Decompiled with CFR 0.152.
 */
package comm;

import comm.IOHandler;
import comm.TReconnect;
import comm.Transaction;
import comm.msg.MLogin;
import comm.msg.MStatus;
import doc.Globals;
import java.io.IOException;
import view.UserDialog;

public class TLogin
extends Transaction {
    public static final String what_str = "@(#)Appx $Header: /src/cvs/joe/comm/TLogin.java,v 1.1.2.7 2013/08/12 15:42:24 pete Exp $";
    public boolean loginOK = false;
    public boolean serverOK = false;
    public byte remote_version = 0;
    private String msgString;
    private int msgSize;
    private byte[] msgData;
    private MLogin login;
    private UserDialog ud;
    private int reconnectid = 0;

    public TLogin(String user, String password, String startAP, String startDB, String startTY, String startPR, boolean remap, int vers, UserDialog udlal, int reconnectid) {
        this.reconnectid = reconnectid;
        this.ud = udlal;
        this.login = new MLogin(user, password, startAP, startDB, startTY, startPR, remap, vers, reconnectid);
    }

    @Override
    public void start() throws IOException {
        MStatus status = new MStatus();
        if (this.ud != null) {
            this.ud.updateStat("Sending Login transaction");
        }
        this.login.write(this.out);
        if (this.ud != null) {
            this.ud.updateStat("Login sent, waiting for reply");
        }
        status.read(this.in);
        this.loginOK = status.success;
        if (this.loginOK) {
            if (!IOHandler.currentHandler.secureConnection2()) {
                this.loginOK = false;
                this.ud.updateStat("Login failed to secure SSL connection");
            } else if (this.ud != null) {
                this.ud.updateStat("Login OK, starting server");
            }
            this.in = IOHandler.currentHandler.inStr;
            this.out = IOHandler.currentHandler.outStr;
            status.read(this.in);
            this.serverOK = status.success;
            if (this.serverOK) {
                this.remote_version = status.version;
                if (this.reconnectid > 0) {
                    TReconnect recon = new TReconnect();
                    recon.setStreams(this.in, this.out, this.socket);
                    recon.start();
                    Globals.setOptionValue("screenRows", recon.getRows());
                    Globals.setOptionValue("screenColumns", recon.getCols());
                }
            }
        } else {
            try {
                this.msgSize = this.in.readInt();
                if (this.msgSize > 0) {
                    this.msgData = new byte[this.msgSize];
                    this.in.readFully(this.msgData);
                    this.msgString = new String(this.msgData);
                }
            }
            catch (Exception e) {
                this.msgString = "Login failed.  Probably incorrect or expired password";
            }
        }
    }

    public String getFailureMessage() {
        return this.msgString;
    }

    public static byte type() {
        return 2;
    }
}

