/*
 * Decompiled with CFR 0.152.
 */
package comm;

import comm.AppxInputStream;
import comm.AppxOutputStream;
import comm.AppxTrustManager;
import comm.TAddField;
import comm.TAddItem;
import comm.TAppList;
import comm.TAttach;
import comm.TButton;
import comm.TCommand;
import comm.TConstantsExch;
import comm.TCreateObject;
import comm.TDeferEdit;
import comm.TDestroyObject;
import comm.TDisplayMessages;
import comm.TDragAndDrop;
import comm.TFeature2Exch;
import comm.TFeatureExch;
import comm.TFieldList;
import comm.TFileList;
import comm.TFormatDate;
import comm.TGuiEditCmd;
import comm.TInit;
import comm.TInvokeMethod;
import comm.TKeymap;
import comm.TLoadUrl;
import comm.TLogin;
import comm.TLongData;
import comm.TMenu;
import comm.TMoveItem;
import comm.TObjectEvent;
import comm.TPcbStack;
import comm.TPing;
import comm.TProcId;
import comm.TReadClipboard;
import comm.TRecvFile;
import comm.TResizeItem;
import comm.TResource;
import comm.TSendFile;
import comm.TSetField;
import comm.TShow;
import comm.TSlctkeysData;
import comm.TToken;
import comm.TUpdateAttribute;
import comm.TUpdateExtendedAttribute;
import comm.TUpdateLangId;
import comm.TUpdateScreen;
import comm.TWriteClipboard;
import comm.Transaction;
import comm.msg.Compressor;
import comm.msg.MDragAndDrop;
import comm.msg.MGuiEditCmd;
import comm.msg.MStatus;
import comm.msg.MToken;
import debug.AppxDebug;
import doc.AppxToolkit;
import doc.Document;
import doc.Globals;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import netscape.security.PrivilegeManager;
import view.AppxMain;
import view.CharView;
import view.UserDialog;

public class IOHandler
implements Runnable {
    public static final String what_str = "@(#)Appx $Header: /src/cvs/joe/comm/IOHandler.java,v 1.2.2.77 2015/05/13 17:03:15 pete Exp $";
    public static IOHandler currentHandler = null;
    public boolean receivedReply = true;
    private Socket socket;
    Document doc;
    public CharView view;
    private InputStream in;
    private OutputStream out;
    public DataInputStream inStr;
    public DataOutputStream outStr;
    private byte[][] localCache;
    private byte[] answer;
    private byte[] answerNull;
    private byte[] answerNullCompressed;
    private int srvFeatureMask = 0;
    private int cliFeatureMask = -5;
    private int comFeatureMask = 0;
    private int srvFeature2Mask = 0;
    private int cliFeature2Mask = 15;
    private int comFeature2Mask = 0;
    private byte ssl;
    private TLongData longData = null;
    private TSlctkeysData slctkeysData = null;
    public ArrayList<MDragAndDrop> dndData = null;
    protected static int vers;
    public TShow show;
    public static String module;
    public static final int E_IO_ERROR = 1;
    public static final int E_CONNECTION_REFUSED = 2;
    public static final int E_LOGIN_INCORRECT = 3;
    public static final int E_SERVER_ERROR = 4;
    public static final int E_HOSTNAME_ERROR = 5;
    public static final int E_SSL_HANDSHAKE_ERROR = 6;
    public static final int DEFAULT_FEATURE_MASK = -5;
    public static final int MAX_FEATURE_MASK = -5;
    public static final int MIN_FEATURE_MASK = 9330;
    public static final int DEFAULT_FEATURE2_MASK = 15;
    public static final int MAX_FEATURE2_MASK = 15;
    public static final int MIN_FEATURE2_MASK = 0;
    public static final int FEATURE_RUNNING_GUI_CLIENT = 1;
    public static final int FEATURE_PASS_PROC_ID_ON_INIT = 2;
    public static final int FEATURE_LOAD_KEYMAP_FROM_SERVER = 4;
    public static final int FEATURE_RUN_VIA_RT_LOAD = 8;
    public static final int FEATURE_DATA_PALETTE_SUPPORT = 16;
    public static final int FEATURE_DOWNLOAD_FILE = 32;
    public static final int FEATURE_UPLOAD_FILE = 64;
    public static final int FEATURE_ADD_FIELD = 128;
    public static final int FEATURE_GET_LANG_BLK = 256;
    public static final int FEATURE_BUTTONS = 512;
    public static final int FEATURE_CLI_PRINT = 1024;
    public static final int FEATURE_REL41P1_SELECT = 2048;
    public static final int FEATURE_REL41P2_TOKENS = 4096;
    public static final int FEATURE_FILTER_BOXES = 8192;
    public static final int FEATURE_DATE_CHOOSER = 16384;
    public static final int FEATURE_AUTO_MENUS = 32768;
    public static final int FEATURE_BOX_ITM_WDGT = 65536;
    public static final int FEATURE_GUI_EDIT_CMD = 131072;
    public static final int FEATURE_LONG_DATA = 262144;
    public static final int FEATURE_TOKEN_SCANS = 524288;
    public static final int FEATURE_JOE2_GUI_CLIENT = 0x100000;
    public static final int FEATURE_NO_END_PARAG = 0x200000;
    public static final int FEATURE_CLIENT_CLIPBOARD = 0x400000;
    public static final int FEATURE_CONSTANTS_EXCH = 0x800000;
    public static final int FEATURE_SERVER_TOOLBARS = 0x1000000;
    public static final int FEATURE_CLIENT_PATH_EXPANSION = 0x2000000;
    public static final int FEATURE_ALPHA_CHANNEL_COLORS = 0x4000000;
    public static final int FEATURE_LONG_TOKENS = 0x8000000;
    public static final int FEATURE_SERVER_PULLDOWNS = 0x10000000;
    public static final int FEATURE_LOGIN_FAILURE_MESSAGE = 0x20000000;
    public static final int FEATURE_TABLE_WIDGETS = 0x40000000;
    public static final int FEATURE_FEATURE2 = Integer.MIN_VALUE;
    public static final int FEATURE2_RECONNECT = 1;
    public static final int FEATURE2_INTERRUPT = 2;
    public static final int FEATURE2_SCROLLPANE_RESIZE = 4;
    public static final int FEATURE2_TABLE_SORTDATA = 8;
    public static final char COM_END_PARAG_DFLT = '\u00b6';
    public static final int VERSION = 4;
    private static final String[] errorMessage;
    private String lastHost;
    private int lastPort;
    private SSLSocketFactory sslsocketfactory = null;
    private SSLSocket sslsocket = null;

    static {
        module = new String("comm.IOHandler");
        errorMessage = new String[]{"Network I/O error", "Connection refused by host", "Incorrect login information", "Network server error", "Unknown Host error", "SSL Handshake or Certificate error"};
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void addImageItem(String ap, String fld, int r, int c) {
        TAddItem addItem = new TAddItem(ap, fld, r, c);
        try {
            this.initiate(new TCommand(3, 70));
            this.initiate(addItem);
        }
        catch (IOException e) {
            System.err.println("comm.IOHandler.addImageItem() IOException = " + e);
        }
    }

    public void addLongData(int row, int col, byte[] value) {
        if (this.longData == null) {
            this.longData = new TLongData();
        }
        this.longData.add(row, col, value);
    }

    public void addLongData(int row, int col, String value) {
        if (this.longData == null) {
            this.longData = new TLongData();
        }
        this.longData.add(row, col, value);
    }

    public boolean checkForFeature(int featureMask) {
        return (this.comFeatureMask & featureMask) == featureMask;
    }

    public boolean checkForFeature2(int feature2Mask) {
        return (this.comFeature2Mask & feature2Mask) == feature2Mask;
    }

    public boolean connected() {
        return this.in != null && vers != 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String connect(String host, int port, String user, String password, String startAP, String startDB, String startTY, String startPR, boolean remap, UserDialog ud, int reconnectid) {
        AppxTrustManager.setTrustLevel(null);
        Globals.setTrustLevel(null);
        Globals.setCurrentCertificate(null);
        this.lastHost = host;
        this.lastPort = port;
        if (CharView.browserID == 1) {
            try {
                PrivilegeManager.enablePrivilege((String)"TerminalEmulator");
                PrivilegeManager.enablePrivilege((String)"DatabaseAccess");
            }
            catch (Exception e) {
                System.err.println("oops e=" + e);
            }
        }
        if (vers < 2 || vers > 4) {
            vers = 4;
        }
        if (host.equals("invoke")) {
            try {
                ServerSocket server = new ServerSocket(0, 5);
                String startupArgs = "";
                if (Globals.getOptionValueString("runApplication") != null) {
                    startupArgs = String.valueOf(startupArgs) + " -a=" + Globals.getOptionValueString("runApplication");
                }
                if (Globals.getOptionValueString("runDatabase") != null) {
                    startupArgs = String.valueOf(startupArgs) + " -d=" + Globals.getOptionValueString("runDatabase");
                }
                if (Globals.getOptionValueString("runProcessType") != null) {
                    startupArgs = String.valueOf(startupArgs) + " -t=" + Globals.getOptionValueString("runProcessType");
                }
                if (Globals.getOptionValueString("runProcess") != null) {
                    startupArgs = String.valueOf(startupArgs) + " -p=" + Globals.getOptionValueString("runProcess");
                }
                Runtime.getRuntime().exec(String.valueOf(user) + " -x=localhost:" + server.getLocalPort() + " -m=WINDOWS" + startupArgs);
                this.socket = server.accept();
                this.socket.setTcpNoDelay(Globals.getOptionValueBoolean("tcpNoDelay"));
                System.err.println("IOHandler.connect() socket.setTcpNoDelay(" + this.socket.getTcpNoDelay() + ")");
                this.out = new AppxOutputStream(this.socket.getOutputStream());
                this.in = new AppxInputStream(this.socket.getInputStream(), (AppxOutputStream)this.out);
                this.inStr = new DataInputStream(this.in);
                this.outStr = new DataOutputStream(this.out);
                MStatus status = new MStatus();
                status.read(this.in);
                return null;
            }
            catch (IOException e) {
                System.err.println(Thread.currentThread() + " " + module + ".connect(): Unknown Host");
                e.printStackTrace();
                return this.xlateMessage(2);
            }
        }
        try {
            InetAddress inetAddr = null;
            InetSocketAddress inetSockAddr = null;
            boolean tryagain = false;
            try {
                inetAddr = InetAddress.getByName(host);
                inetSockAddr = new InetSocketAddress(inetAddr, port);
                this.socket = new Socket();
                this.socket.connect(inetSockAddr, 3000);
            }
            catch (Exception ex) {
                tryagain = true;
            }
            if (tryagain) {
                inetAddr = InetAddress.getByName(host);
                inetSockAddr = new InetSocketAddress(inetAddr, port);
                this.socket = new Socket();
                this.socket.connect(inetSockAddr, 1000 * Globals.getOptionValueInteger("connectTimeout"));
            }
            this.socket.setTcpNoDelay(Globals.getOptionValueBoolean("tcpNoDelay"));
            this.socket.setKeepAlive(true);
            this.ssl = this.negotiateSslType(this.socket.getOutputStream(), this.socket.getInputStream());
            if (this.ssl == 88) {
                this.socket.shutdownInput();
                this.socket.shutdownOutput();
                this.socket.close();
                this.socket = new Socket();
                this.socket.connect(inetSockAddr, 1000 * Globals.getOptionValueInteger("connectTimeout"));
                this.socket.setKeepAlive(true);
                this.socket.setTcpNoDelay(Globals.getOptionValueBoolean("tcpNoDelay"));
                System.err.println("IOHandler.connect() socket.setTcpNoDelay(" + this.socket.getTcpNoDelay() + ")");
            }
            if (this.ssl == 120) {
                this.ssl = (byte)88;
            }
            System.err.print("SSL Negotiation: Client=" + Globals.getOptionValueString("SSLMode") + ", Server Negotiated=");
            if (this.ssl == 82) {
                System.err.println("Rejected");
            }
            if (this.ssl == 80) {
                System.err.println("Plaintext");
            }
            if (this.ssl == 83) {
                System.err.println("SSL");
            }
            if (this.ssl == 88) {
                System.err.println("Plaintext, pre-4.3 server");
            }
            if (this.ssl == 82) {
                return "SSL Connection Type rejected by server";
            }
            if (this.ssl == 83 && Globals.getOptionValueString("SSLMode").equals("disabled")) {
                int n = 1;
                if (Globals.getOptionValueBoolean("SSLMismatchAllowed")) {
                    n = JOptionPane.showConfirmDialog(CharView.view, "The server that you are connecting to requires SSL\nconnections.  If you continue with this connection the\ndata sent over the network will be secure using SSL.\n\nContinue to connect using SSL?", "SSL Handshake Mismatch", 0, 1);
                } else {
                    JOptionPane.showMessageDialog(CharView.view, "The server that you are connecting to requires SSL\nconnections.  Your client is configured to disable\nSSL connections.  You must change your client SSL\nsettings if you wish to connect to this server.", "SSL Handshake Mismatch", 0);
                }
                if (n == 1) {
                    this.socket.shutdownInput();
                    this.socket.shutdownOutput();
                    this.socket.close();
                    return "Connection rejected, Server requires SSL";
                }
            }
            if ((this.ssl == 80 || this.ssl == 88) && Globals.getOptionValueString("SSLMode").equals("required")) {
                int n = 1;
                if (Globals.getOptionValueBoolean("SSLMismatchAllowed")) {
                    n = JOptionPane.showConfirmDialog(CharView.view, "The server that you are connecting to does not support SSL\nconnections.  If you continue with this connection the\ndata sent over the network will not be secure.\n\nContinue to connect without using SSL?", "SSL Handshake Mismatch", 0, 2);
                } else {
                    JOptionPane.showMessageDialog(CharView.view, "The server that you are connecting to does not support\nSSL connections.  Your client is configured to require\nSSL connections.  You must change your client SSL\nsettings if you wish to connect to this server.", "SSL Handshake Mismatch", 0);
                }
                if (n == 1) {
                    this.socket.shutdownInput();
                    this.socket.shutdownOutput();
                    this.socket.close();
                    return "Connection rejected, Server requires non-SSL";
                }
            }
            if (this.ssl == 83) {
                if (!this.secureConnection()) {
                    return "Failed to secure SSL connection";
                }
                if (this.inStr == null) return this.xlateMessage(6);
                if (this.outStr == null) {
                    return this.xlateMessage(6);
                }
            } else {
                this.out = new AppxOutputStream(this.socket.getOutputStream());
                this.in = new AppxInputStream(this.socket.getInputStream(), (AppxOutputStream)this.out);
                this.inStr = new DataInputStream(this.in);
                this.outStr = new DataOutputStream(this.out);
            }
        }
        catch (UnknownHostException e) {
            System.err.println(Thread.currentThread() + " " + module + ".connect(): Unknown Host");
            return this.xlateMessage(5);
        }
        catch (IOException e) {
            System.err.println(Thread.currentThread() + " " + module + ".connect(): Connection Error");
            e.printStackTrace();
            return this.xlateMessage(2);
        }
        try {
            TLogin login = (TLogin)this.initiate(new TLogin(user, password, startAP, startDB, startTY, startPR, remap, vers, ud, reconnectid));
            if (!login.loginOK) {
                if (login.getFailureMessage() != null) return login.getFailureMessage();
                return this.xlateMessage(3);
            }
            if (!login.serverOK) {
                return this.xlateMessage(4);
            }
            if (login.remote_version >= vers) return null;
            vers = login.remote_version;
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return this.xlateMessage(1);
        }
    }

    private byte negotiateSslType(OutputStream os, InputStream is) {
        byte[] response;
        block5: {
            if (Globals.getOptionValueString("SSLMode").equalsIgnoreCase("disabled")) {
                return 120;
            }
            byte[] request = new byte[2];
            response = new byte[2];
            request[0] = 4;
            request[1] = Globals.getOptionValueString("SSLMode").equalsIgnoreCase("required") ? 115 : (Globals.getOptionValueString("SSLMode").equalsIgnoreCase("optional") ? 115 : (Globals.getOptionValueString("SSLMode").equalsIgnoreCase("disabled") ? 112 : 115));
            try {
                os.write(request);
                BufferedInputStream bis = new BufferedInputStream(is);
                int i = Globals.getOptionValueInteger("SSLHandshakeTimeout");
                while (i > 0) {
                    if (bis.available() == 2) break;
                    Thread.sleep(1000L);
                    --i;
                }
                if (bis.available() == 2) {
                    bis.read(response);
                    break block5;
                }
                return 88;
            }
            catch (Exception e) {
                return 82;
            }
        }
        return response[1];
    }

    public boolean secureConnection() {
        try {
            this.sslsocketfactory = AppxTrustManager.getAppxSSLSocketFactory();
            this.sslsocket = (SSLSocket)this.sslsocketfactory.createSocket(this.socket, this.lastHost, this.lastPort, false);
            this.sslsocket.startHandshake();
            Globals.setTrustLevel(AppxTrustManager.getTrustLevel());
            Globals.setCurrentCertificate(AppxTrustManager.getCurrentCertificate());
            this.out = new AppxOutputStream(this.sslsocket.getOutputStream());
            this.in = new AppxInputStream(this.sslsocket.getInputStream(), (AppxOutputStream)this.out);
        }
        catch (Exception e) {
            System.err.println("IOHandler.connect(ssl error) e=" + e);
            this.in = null;
            this.out = null;
            return false;
        }
        if (this.in == null || this.out == null) {
            this.inStr = null;
            this.outStr = null;
            return false;
        }
        this.inStr = new DataInputStream(this.in);
        this.outStr = new DataOutputStream(this.out);
        return true;
    }

    public boolean secureConnection2() {
        if (this.ssl == 80 || this.ssl == 88) {
            return true;
        }
        try {
            this.sslsocket.getSession().invalidate();
            this.sslsocket.close();
            return this.secureConnection();
        }
        catch (Exception e) {
            System.err.println("IOHandler.connect(ssl error) e=" + e);
            return false;
        }
    }

    public void deferEdit(int row, int col, int height, int width, int op) {
        TDeferEdit edit = new TDeferEdit(row, col, height, width, op);
        try {
            this.initiate(new TCommand(3, 78));
            this.initiate(edit);
            if (Globals.getOptionValueBoolean("newTypeaheadCode")) {
                this.serverLoop();
            }
        }
        catch (IOException e) {
            System.err.println("comm.IOHandler.deferEdit() IOException = " + e);
        }
    }

    public void disconnect() throws IOException {
        this.socket.close();
        this.in = null;
        this.out = null;
        this.socket = null;
    }

    public void fireObjectEvent(int handle, int return_code) {
        TObjectEvent evt = new TObjectEvent();
        evt.setReturnHandle(handle);
        evt.setReturnError(return_code);
        try {
            this.initiate(evt);
            if (Globals.getOptionValueBoolean("newTypeaheadCode")) {
                this.serverLoop();
            }
        }
        catch (IOException e) {
            System.err.println("comm.IOHandler.filreObjectEvent() IOException = " + e);
        }
    }

    public void formatDate(int row, int col, byte[] rawDate) {
        TFormatDate tran = new TFormatDate(row, col, rawDate);
        try {
            this.initiate(new TCommand(3, 84));
            this.initiate(tran);
            if (Globals.getOptionValueBoolean("newTypeaheadCode")) {
                this.serverLoop();
            }
        }
        catch (IOException e) {
            System.err.println("IOHandler.formatDate(): IOException " + e);
        }
    }

    public void fireServerInterrupt() {
        if (this.checkForFeature2(2)) {
            try {
                this.initiate(new TCommand(0, 95));
            }
            catch (IOException e) {
                System.err.println("fireServerInterrupt(): IOException " + e);
            }
        }
    }

    public void getAppList() {
        try {
            this.initiate(new TCommand(0, 28));
            if (Globals.getOptionValueBoolean("newTypeaheadCode")) {
                this.serverLoop();
            }
        }
        catch (IOException e) {
            System.err.println("sendAppListReq(): IOException " + e);
        }
    }

    public int getCliFeatureMask() {
        return this.cliFeatureMask;
    }

    public int getComFeatureMask() {
        return this.comFeatureMask;
    }

    public void getFieldList(String app, String file) {
        try {
            this.initiate(new TCommand(3, 49));
            this.initiate(new TFieldList(app, file));
            if (Globals.getOptionValueBoolean("newTypeaheadCode")) {
                this.serverLoop();
            }
        }
        catch (IOException e) {
            System.err.println("sendFieldListReq(): IOException " + e);
        }
    }

    public void getFileList(String app) {
        try {
            this.initiate(new TCommand(3, 29));
            this.initiate(new TFileList(app));
            if (Globals.getOptionValueBoolean("newTypeaheadCode")) {
                this.serverLoop();
            }
        }
        catch (IOException e) {
            System.err.println("sendFileListReq(): IOException " + e);
        }
    }

    public String getResource(String cacheSig, String group, String cachePath) {
        TResource resource = new TResource(cacheSig, group, cachePath);
        try {
            this.initiate(new TCommand(3, 83));
            this.initiate(resource);
            return resource.getResource();
        }
        catch (IOException e) {
            System.err.println("sendResourceReq(): IOException " + e);
            return null;
        }
    }

    public int getSrvFeatureMask() {
        return this.srvFeatureMask;
    }

    public MToken getToken(int group, int start, int max) {
        TToken token = new TToken(group, start, max);
        try {
            this.initiate(new TCommand(3, 79));
            this.initiate(token);
            token = new TToken();
            this.initiate(token);
            return token.getToken();
        }
        catch (IOException e) {
            System.err.println("sendTokenReq(): IOException " + e);
            return null;
        }
    }

    public Transaction initiate(Transaction t) throws IOException {
        t.setStreams(this.inStr, this.outStr, this.socket);
        t.start();
        return t;
    }

    public void setDocument(Document document) {
        this.doc = document;
        this.doc.registerIOHandler(this);
    }

    public void setView(CharView v) {
        this.view = v;
        Transaction.setView(v);
    }

    public IOHandler(Document document, CharView v, int ver) {
        currentHandler = this;
        this.doc = document;
        this.view = v;
        vers = ver;
        if (this.doc != null) {
            this.doc.registerIOHandler(this);
        }
        if (this.view != null) {
            Transaction.setView(v);
        }
    }

    public IOHandler(Document document, CharView v) {
        this(document, v, 4);
    }

    public void moveImageItem(int oldRow, int oldCol, int newRow, int newCol) {
        TMoveItem moveItem = new TMoveItem(oldRow, oldCol, newRow, newCol);
        try {
            this.initiate(new TCommand(3, 76));
            this.initiate(moveItem);
            if (Globals.getOptionValueBoolean("newTypeaheadCode")) {
                this.serverLoop();
            }
        }
        catch (IOException e) {
            System.err.println("comm.IOHandler.moveImageItem() IOException = " + e);
        }
    }

    public void resizeImageItem(int oldRow, int oldCol, int newRow, int newCol, int newRows, int newCols) {
        TResizeItem resizeItem = new TResizeItem(oldRow, oldCol, newRow, newCol, newRows, newCols);
        try {
            this.initiate(new TCommand(3, 77));
            this.initiate(resizeItem);
            if (Globals.getOptionValueBoolean("newTypeaheadCode")) {
                this.serverLoop();
            }
        }
        catch (IOException e) {
            System.err.println("comm.IOHandler.resizeImageItem() IOException = " + e);
        }
    }

    @Override
    public void run() {
        this.serverLoop();
    }

    public void sendGuiEditCmd(int cmd, int subCmd, int pOldRow, int pOldCol, int pNewRow, int pNewCol, int sRows, int sCols, String ap, String fld) {
        MGuiEditCmd editCmd = new MGuiEditCmd(cmd, subCmd, pOldRow, pOldCol, pNewRow, pNewCol, sRows, sCols, ap, fld);
        this.sendGuiEditCmd(editCmd);
    }

    public void sendGuiEditCmd(MGuiEditCmd cmd) {
        if (this.checkForFeature(131072)) {
            TGuiEditCmd editCmd = new TGuiEditCmd(cmd);
            try {
                this.initiate(new TCommand(3, 82));
                this.initiate(editCmd);
            }
            catch (IOException e) {
                System.err.println("comm.IOHandler.sendGuiEditCmd() IOException = " + e);
            }
        }
    }

    public void sendShow() {
        int c;
        int r;
        if (!this.receivedReply) {
            return;
        }
        Document.setLocked(true);
        if ((this.doc.display.mode & 0x20) != 0) {
            this.show.success = false;
            r = 0;
            while (r < Document.sizMax.height) {
                c = 0;
                while (c < Document.sizMax.width) {
                    this.answer[r * Document.sizMax.width + c] = this.doc.screen[r][c] == this.localCache[r][c] ? (byte)0 : this.doc.screen[r][c];
                    if (!this.show.success && r < Document.sizMax.height - 3 && this.doc.screen[r][c] != this.doc.cache[r][c]) {
                        this.show.success = true;
                    }
                    ++c;
                }
                ++r;
            }
        } else if ((this.doc.display.mode & 8) == 0) {
            this.show.success = true;
        } else {
            this.show.success = true;
            r = 0;
            while (r < Document.sizMax.height) {
                c = 0;
                while (c < Document.sizMax.width) {
                    this.answer[r * Document.sizMax.width + c] = this.doc.screen[r][c] == this.localCache[r][c] ? (byte)0 : this.doc.screen[r][c];
                    ++c;
                }
                ++r;
            }
        }
        try {
            this.initiate(new TCommand(2, 12));
            if ((this.doc.display.mode & 8) == 0) {
                this.initiate(new TUpdateScreen(this.answerNullCompressed, true));
            } else {
                this.initiate(new TUpdateScreen(this.answer));
            }
            this.initiate(this.show);
        }
        catch (IOException e) {
            System.err.println("sendShow(): IOException " + e);
            System.exit(0);
        }
        if ((this.doc.display.mode & 0x40) != 0) {
            int r2 = 0;
            while (r2 < Document.sizMax.height) {
                System.arraycopy(this.doc.screen[r2], 0, this.doc.cache[r2], 0, Document.sizMax.width);
                ++r2;
            }
        }
        if (this.checkForFeature(262144)) {
            try {
                this.initiate(new TCommand(2, 86));
                if (this.longData == null) {
                    this.longData = new TLongData();
                }
                this.initiate(this.longData);
                this.longData = null;
            }
            catch (IOException e) {
                System.err.println("sendShow(): IOException " + e);
            }
        }
        if (this.checkForFeature(0x40000000)) {
            try {
                this.initiate(new TCommand(2, 90));
                if (this.slctkeysData == null) {
                    this.slctkeysData = new TSlctkeysData(CharView.view.getSelectedKeys());
                }
                this.initiate(this.slctkeysData);
                this.slctkeysData = null;
                this.initiate(new TCommand(2, 92));
                this.initiate(new TDragAndDrop(this.dndData));
                this.dndData = null;
            }
            catch (IOException e) {
                System.err.println("sendShow(): IOException " + e);
            }
        }
        this.doc.resetMenus();
    }

    public void serverLoop() {
        boolean finished = false;
        this.localCache = new byte[Document.sizMax.height][Document.sizMax.width];
        this.answer = new byte[Document.sizMax.height * Document.sizMax.width];
        this.answerNull = new byte[Document.sizMax.height * Document.sizMax.width];
        int i = Document.sizMax.height * Document.sizMax.width - 1;
        while (i >= 0) {
            this.answerNull[i] = 0;
            --i;
        }
        this.answerNullCompressed = Compressor.compress(this.answerNull);
        block41: do {
            try {
                Document.setLocked(true);
                if (this.doc.isServerInterrupt()) {
                    this.doc.setServerInterrupt(false);
                }
                TCommand command = (TCommand)this.initiate(new TCommand());
                Document.setLocked(true);
                Document.setGotTimeout(false);
                switch (command.command) {
                    case -1: {
                        if (this.view == null || CharView.topBox == null) continue block41;
                        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                        eventQueue.postEvent(new ComponentEvent(CharView.topBox.getCatchFocus(), 100));
                        Document.setGotTimeout(true);
                        Document.setLocked(false);
                        finished = true;
                        break;
                    }
                    case 93: {
                        TPcbStack pcbStack = (TPcbStack)this.initiate(new TPcbStack());
                        this.doc.setPcbList(pcbStack.getPcbList());
                        break;
                    }
                    case 88: {
                        this.view.setStatusText("Sending clipboard to server...");
                        this.view.repaint();
                        this.initiate(new TReadClipboard());
                        break;
                    }
                    case 87: {
                        this.view.setStatusText("Loading clipboard from server...");
                        this.view.repaint();
                        this.initiate(new TWriteClipboard());
                        break;
                    }
                    case 10: {
                        this.view.setStatusText("Negotiating GUI Interface options...");
                        this.view.repaint();
                        this.initiate(new TInit());
                        break;
                    }
                    case 17: {
                        this.view.setStatusText("Attaching GUI interface to server session...");
                        this.view.repaint();
                        this.initiate(new TAttach(Document.siz, Document.sizMin, Document.sizMax));
                        this.view.newConnection();
                        break;
                    }
                    case 19: {
                        this.view.setStatusText("Loading Initialization data from server...");
                        this.view.repaint();
                        if (this.doc.keymap == null) {
                            this.doc.keymap = new Hashtable();
                        }
                        TKeymap tk = (TKeymap)this.initiate(new TKeymap());
                        this.doc.keymap.put(tk.map.id, tk.map);
                        if (this.doc.keymap.size() <= 3) continue block41;
                        this.initiate(new TCommand());
                        break;
                    }
                    case 21: {
                        TUpdateScreen scr = (TUpdateScreen)this.initiate(new TUpdateScreen());
                        int r = 0;
                        while (r < Document.sizMax.height) {
                            try {
                                System.arraycopy(scr.data, r * Document.sizMax.width, this.doc.Schanges[r], 0, Document.sizMax.width);
                            }
                            catch (Exception e) {
                                System.err.println("IOHandler.serverLoop() arraycopy() exception: " + e);
                                System.err.println("-->System.arraycopy(scr.data, r * Document.sizMax.width, doc.Schanges[r], 0, Document.sizMax.width);");
                                System.err.println("-->  scr.data.length=" + scr.data.length + ", r=" + r + ", Document.sizMax.width=" + Document.sizMax.width + ", doc.Schanges[r].length=" + this.doc.Schanges[r].length);
                                AppxDebug.logBytes(scr.data);
                                Thread.dumpStack();
                            }
                            int c = 0;
                            while (c < Document.sizMax.width) {
                                if (scr.data[r * Document.sizMax.width + c] != 0) {
                                    this.doc.screen[r][c] = scr.data[r * Document.sizMax.width + c];
                                }
                                ++c;
                            }
                            ++r;
                        }
                        continue block41;
                    }
                    case 22: {
                        TUpdateAttribute attr = (TUpdateAttribute)this.initiate(new TUpdateAttribute());
                        int r = 0;
                        while (r < Document.sizMax.height) {
                            int c = 0;
                            while (c < Document.sizMax.width) {
                                if (attr.data[r * Document.sizMax.width + c] != -1) {
                                    this.doc.attributes[r][c] = this.doc.attributes[r][c] & 0xFFFFFFFF00000000L | (long)attr.data[r * Document.sizMax.width + c] & 0xFFFFFFFFL;
                                }
                                ++c;
                            }
                            ++r;
                        }
                        int c = 0;
                        while (c < Document.sizMax.width) {
                            long[] lArray = this.doc.attributes[Document.sizMax.height - 4];
                            int n = c++;
                            lArray[n] = lArray[n] & 0xFFFFFFFFFFFFFEFFL;
                        }
                        continue block41;
                    }
                    case 27: {
                        TUpdateExtendedAttribute attrX = (TUpdateExtendedAttribute)this.initiate(new TUpdateExtendedAttribute());
                        int r = 0;
                        while (r < Document.sizMax.height) {
                            int c = 0;
                            while (c < Document.sizMax.width) {
                                if (attrX.data[r * Document.sizMax.width + c] != -1) {
                                    this.doc.attributes[r][c] = this.doc.attributes[r][c] & 0xFFFFFFFFL | (long)attrX.data[r * Document.sizMax.width + c] << 32 & 0xFFFFFFFF00000000L;
                                }
                                ++c;
                            }
                            ++r;
                        }
                        continue block41;
                    }
                    case 74: {
                        TUpdateLangId lang = (TUpdateLangId)this.initiate(new TUpdateLangId());
                        this.doc.updateLangId(lang);
                        break;
                    }
                    case 12: {
                        this.show = (TShow)this.initiate(new TShow(this.checkForFeature(65536), this.doc.button));
                        if ((this.show.display.mode & 4) == 4) {
                            this.view.beep();
                        }
                        this.doc.display = this.show.display;
                        int r = 0;
                        while (r < Document.sizMax.height) {
                            System.arraycopy(this.doc.screen[r], 0, this.localCache[r], 0, Document.sizMax.width);
                            ++r;
                        }
                        if ((this.doc.display.mode & 2) == 0 && this.doc.display.mode != 32) continue block41;
                        this.doc.update();
                        if ((this.doc.display.mode & 8) == 0) continue block41;
                        Document.setLocked(false);
                        this.view.processTypeaheadBuffer();
                        break;
                    }
                    case 75: {
                        TButton button = (TButton)this.initiate(new TButton());
                        this.doc.button = button.button;
                        break;
                    }
                    case 81: {
                        TMenu menu = (TMenu)this.initiate(new TMenu());
                        this.doc.addMenu(menu);
                        break;
                    }
                    case 25: {
                        this.initiate(new TPing());
                        if (Globals.getOptionValueBoolean("newTypeaheadCode")) continue block41;
                        Document.setLocked(false);
                        break;
                    }
                    case 26: {
                        TLoadUrl loadUrl = new TLoadUrl();
                        this.initiate(loadUrl);
                        this.doc.loadUrl(loadUrl.url());
                        break;
                    }
                    case 69: {
                        TProcId procId = new TProcId();
                        this.initiate(procId);
                        this.doc.setProcId(procId.pid());
                        Globals.setOptionValue("lastPid", procId.pid());
                        Globals.resetExpandedCache();
                        this.view.setTitle(Globals.getOptionValueString("windowTitle", true, false));
                        break;
                    }
                    case 79: {
                        break;
                    }
                    case 28: {
                        this.view.setStatusText("Downloading App List...");
                        this.view.repaint();
                        TAppList appList = new TAppList();
                        this.initiate(appList);
                        this.doc.loadAppList(appList.getList());
                        this.view.setStatusText("");
                        this.view.repaint();
                        Document.setLocked(false);
                        break;
                    }
                    case 29: {
                        this.view.setStatusText("Downloading File List...");
                        this.view.repaint();
                        TFileList fileList = new TFileList();
                        this.initiate(fileList);
                        this.doc.loadFileList(fileList.getList());
                        this.view.setStatusText("");
                        this.view.repaint();
                        Document.setLocked(false);
                        break;
                    }
                    case 49: {
                        this.view.setStatusText("Downloading Field List...");
                        this.view.repaint();
                        TFieldList fieldList = new TFieldList();
                        this.initiate(fieldList);
                        this.doc.loadFieldList(fieldList.getList());
                        this.view.setStatusText("");
                        this.view.repaint();
                        Document.setLocked(false);
                        break;
                    }
                    case 72: {
                        TAddField addField = new TAddField(this.checkForFeature(65536));
                        this.initiate(addField);
                        this.doc.addField(addField.getList());
                        break;
                    }
                    case 91: {
                        TDisplayMessages dsplMsgs = new TDisplayMessages();
                        this.initiate(dsplMsgs);
                        this.doc.loadDisplayMessages(dsplMsgs.getMessages());
                        break;
                    }
                    case 85: {
                        final TSetField setField = new TSetField();
                        this.initiate(setField);
                        if (Globals.getOptionValueBoolean("newTypeaheadCode")) {
                            this.doc.setField(setField.getRow(), setField.getCol(), setField.getValue());
                            Document.setLocked(false);
                            break;
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                IOHandler.this.doc.setField(setField.getRow(), setField.getCol(), setField.getValue());
                                Document.setLocked(false);
                                IOHandler.this.view.repaint();
                            }
                        });
                        break;
                    }
                    case 71: {
                        this.view.setStatusText("Downloading File...");
                        this.view.repaint();
                        TSendFile sendFile = new TSendFile();
                        this.initiate(sendFile);
                        this.view.setStatusText("");
                        this.view.paintNow();
                        break;
                    }
                    case 73: {
                        this.view.setStatusText("uploading File...");
                        this.view.repaint();
                        TRecvFile recvFile = new TRecvFile();
                        this.initiate(recvFile);
                        this.view.setStatusText("");
                        this.view.paintNow();
                        break;
                    }
                    case 64: {
                        TCreateObject objectSpecs = new TCreateObject();
                        this.initiate(objectSpecs);
                        this.doc.createLocalObject(objectSpecs);
                        this.initiate(objectSpecs);
                        if (Globals.getOptionValueBoolean("newTypeaheadCode")) continue block41;
                        Document.setLocked(false);
                        break;
                    }
                    case 65: {
                        TInvokeMethod methodSpecs = new TInvokeMethod();
                        this.initiate(methodSpecs);
                        this.doc.invokeLocalMethod(methodSpecs);
                        this.initiate(methodSpecs);
                        if (Globals.getOptionValueBoolean("newTypeaheadCode")) {
                            if (methodSpecs == null || methodSpecs.getMethodName().indexOf("showTheList") < 0) continue block41;
                            Document.setLocked(false);
                            CharView.view.repaint();
                            break;
                        }
                        Document.setLocked(false);
                        break;
                    }
                    case 66: {
                        TDestroyObject objectSpecsD = new TDestroyObject();
                        this.initiate(objectSpecsD);
                        this.doc.destroyLocalObject(objectSpecsD);
                        if (Globals.getOptionValueBoolean("newTypeaheadCode")) continue block41;
                        Document.setLocked(false);
                        break;
                    }
                    case 68: {
                        TFeatureExch featureTran = new TFeatureExch();
                        this.initiate(featureTran);
                        this.srvFeatureMask = featureTran.getSrvMask();
                        this.comFeatureMask = this.srvFeatureMask & this.cliFeatureMask;
                        featureTran.setCliMask(this.cliFeatureMask);
                        this.initiate(featureTran);
                        if (AppxDebug.isLoggingEnabled()) {
                            System.err.println("Feature Exchange: Server=" + Integer.toHexString(this.srvFeatureMask));
                            System.err.println("Feature Exchange: Client=" + Integer.toHexString(this.cliFeatureMask));
                            System.err.println("Feature Exchange: Merged=" + Integer.toHexString(this.comFeatureMask));
                        }
                        if (!Globals.getOptionValueBoolean("presentationMode")) {
                            this.view.makeMenubar();
                            this.view.makeToolbar();
                            if (Globals.getOptionValueBoolean("showToolbar")) {
                                this.view.getContentPane().add("North", this.view.toolBar);
                            }
                        }
                        if (this.checkForFeature(0x1000000)) continue block41;
                        this.view.createDefaultToolbar();
                        break;
                    }
                    case 94: {
                        TFeature2Exch feature2Tran = new TFeature2Exch();
                        this.initiate(feature2Tran);
                        this.srvFeature2Mask = feature2Tran.getSrvMask();
                        if (Globals.getOptionValueBoolean("resizeMainWindowPane") == Boolean.FALSE) {
                            this.cliFeature2Mask -= 4;
                        }
                        this.comFeature2Mask = this.srvFeature2Mask & this.cliFeature2Mask;
                        feature2Tran.setCliMask(this.cliFeature2Mask);
                        this.initiate(feature2Tran);
                        if (!AppxDebug.isLoggingEnabled()) continue block41;
                        System.err.println("Feature2 Exchange: Server=" + Integer.toHexString(this.srvFeature2Mask));
                        System.err.println("Feature2 Exchange: Client=" + Integer.toHexString(this.cliFeature2Mask));
                        System.err.println("Feature2 Exchange: Merged=" + Integer.toHexString(this.comFeature2Mask));
                        break;
                    }
                    case 89: {
                        TConstantsExch constantsTran = new TConstantsExch();
                        Hashtable<String, String> clientConstants = null;
                        if (Globals.getOptionValueBoolean("netcardLockupFix")) {
                            clientConstants = new Hashtable<String, String>(6);
                        } else {
                            String keyword;
                            int optionCount = Globals.getOptionCount();
                            int[] optionMap = Globals.getOptionMapping();
                            int prefCount = 0;
                            int i2 = 0;
                            while (i2 < optionCount) {
                                keyword = Globals.getOptionTag(optionMap[i2]);
                                if (keyword.charAt(0) != '[' && Globals.getOptionHidden(optionMap[i2]) == Boolean.FALSE) {
                                    ++prefCount;
                                }
                                ++i2;
                            }
                            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                            GraphicsDevice[] gDevs = ge.getScreenDevices();
                            int numberOfDisplays = gDevs.length;
                            clientConstants = new Hashtable(19 + numberOfDisplays * 4 + prefCount);
                            int i3 = 0;
                            while (i3 < optionCount) {
                                keyword = Globals.getOptionTag(optionMap[i3]);
                                if (keyword.charAt(0) != '[' && Globals.getOptionHidden(optionMap[i3]) == Boolean.FALSE) {
                                    String datavalue = Globals.getOptionValueString(keyword);
                                    clientConstants.put("pref." + keyword, datavalue == null ? "(null)" : datavalue);
                                }
                                ++i3;
                            }
                            clientConstants.put("sun.cpu.endian", System.getProperty("sun.cpu.endian"));
                            clientConstants.put("user.name", System.getProperty("user.name"));
                            clientConstants.put("user.language", System.getProperty("user.language"));
                            clientConstants.put("os.arch", System.getProperty("os.arch"));
                            clientConstants.put("user.dir", System.getProperty("user.dir"));
                            clientConstants.put("java.io.tmpdir", System.getProperty("java.io.tmpdir"));
                            clientConstants.put("java.home", System.getProperty("java.home"));
                            clientConstants.put("java.vm.version", System.getProperty("java.vm.version"));
                            clientConstants.put("user.home", Globals.getOptionValueString("userHome"));
                            clientConstants.put("clientHome", Globals.getOptionValueString("clientHome"));
                            clientConstants.put("client.version", "5.4.2");
                            clientConstants.put("client.version.num", "050402.28");
                            clientConstants.put("client.address", this.socket.getLocalAddress().toString());
                            clientConstants.put("server.address", this.socket.getInetAddress().toString());
                            clientConstants.put("client.port", "" + this.socket.getLocalPort());
                            clientConstants.put("server.port", "" + this.socket.getPort());
                            clientConstants.put("display.count", "" + numberOfDisplays);
                            int dispNo = 0;
                            while (dispNo < numberOfDisplays) {
                                GraphicsConfiguration currentGC = gDevs[dispNo].getDefaultConfiguration();
                                clientConstants.put("display." + dispNo + ".x", "" + currentGC.getBounds().x);
                                clientConstants.put("display." + dispNo + ".y", "" + currentGC.getBounds().y);
                                clientConstants.put("display." + dispNo + ".width", "" + currentGC.getBounds().width);
                                clientConstants.put("display." + dispNo + ".height", "" + currentGC.getBounds().height);
                                ++dispNo;
                            }
                        }
                        clientConstants.put("file.separator", System.getProperty("file.separator"));
                        clientConstants.put("line.separator", System.getProperty("line.separator"));
                        clientConstants.put("path.separator", System.getProperty("path.separator"));
                        clientConstants.put("os.name", System.getProperty("os.name"));
                        clientConstants.put("os.version", System.getProperty("os.version"));
                        constantsTran.setClientList(clientConstants);
                        this.initiate(constantsTran);
                        Globals.getCurrentGlobals().setServerConstants(constantsTran.getServerList());
                        break;
                    }
                    case 14: {
                        this.doc.finish = true;
                        this.disconnect();
                        if (Globals.getOptionValueBoolean("clearCache")) {
                            if (AppxDebug.isLoggingEnabled()) {
                                System.err.println("Clearing cachePath=" + Globals.getOptionValueString("cachePath"));
                            }
                            AppxToolkit.removeFiles(Globals.getOptionValueString("cachePath"), true, true);
                        }
                        finished = true;
                        AppxMain.appxmain.cleanup();
                        System.exit(0);
                        if (!Globals.getOptionValueBoolean("newTypeaheadCode")) continue block41;
                        Document.setLocked(false);
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
            }
            catch (IOException e) {
                finished = true;
            }
        } while (!(Globals.getOptionValueBoolean("newTypeaheadCode") ? !Document.isLocked() || finished : finished));
    }

    public void setCliFeatureMask(int newValue) {
        this.cliFeatureMask = newValue;
    }

    public void setComFeatureMask(int newValue) {
        this.comFeatureMask = newValue;
    }

    public void setSrvFeatureMask(int newValue) {
        this.srvFeatureMask = newValue;
    }

    public String xlateMessage(int retCode) {
        return errorMessage[retCode - 1];
    }
}

