/*
 * Decompiled with CFR 0.152.
 */
package comm;

import doc.AppxResource;
import doc.Globals;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.StringTokenizer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.swing.JOptionPane;
import view.CharView;

public class AppxTrustManager
implements X509TrustManager {
    private X509TrustManager standardTrustManager = null;
    private static X509Certificate currentCertificate = null;
    private static X509Certificate ourCert = null;
    private static final String cert = "-----BEGIN CERTIFICATE-----\nMIIDbDCCAtWgAwIBAgIJAIYJHffYskHyMA0GCSqGSIb3DQEBBAUAMIGBMQswCQYD\nVQQGEwJVUzEQMA4GA1UECBMHRmxvcmlkYTEVMBMGA1UEBxMMSmFja3NvbnZpbGxl\nMRwwGgYDVQQKExNBcHB4IFNvZnR3YXJlLCBJbmMuMQowCAYDVQQDFAEqMR8wHQYJ\nKoZIhvcNAQkBFhBzdXBwb3J0QGFwcHguY29tMB4XDTA2MDUyNDE5NTEyNFoXDTA2\nMDYyMzE5NTEyNFowgYExCzAJBgNVBAYTAlVTMRAwDgYDVQQIEwdGbG9yaWRhMRUw\nEwYDVQQHEwxKYWNrc29udmlsbGUxHDAaBgNVBAoTE0FwcHggU29mdHdhcmUsIElu\nYy4xCjAIBgNVBAMUASoxHzAdBgkqhkiG9w0BCQEWEHN1cHBvcnRAYXBweC5jb20w\ngZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAMQU2IGYa/dina27SEj/fozvx7CR\nwjCA6MzeQMdzI3m7QohDPgG+G/YKnMhtr1YGVbnwDfcf7dMw5Ha8NnMp1St0g6c/\nSYqi0nR2OhvC8+eShEcrbGF/miSkbskEk2wL5VvLNCVwIf+RRshp+P0o/Iul6+dv\ncJqrDEnG1TBuWGrFAgMBAAGjgekwgeYwHQYDVR0OBBYEFC3cOrHd9FAmWR782Ned\n1ZeJuGHhMIG2BgNVHSMEga4wgauAFC3cOrHd9FAmWR782Ned1ZeJuGHhoYGHpIGE\nMIGBMQswCQYDVQQGEwJVUzEQMA4GA1UECBMHRmxvcmlkYTEVMBMGA1UEBxMMSmFj\na3NvbnZpbGxlMRwwGgYDVQQKExNBcHB4IFNvZnR3YXJlLCBJbmMuMQowCAYDVQQD\nFAEqMR8wHQYJKoZIhvcNAQkBFhBzdXBwb3J0QGFwcHguY29tggkAhgkd99iyQfIw\nDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0BAQQFAAOBgQBLhpsXbI0Ex6AHn5P+u9Dl\n09m1+wXbPcn40oG/kbYSyfDiTt2jGIovEeEU0fnArWy2urmD7VpvFse8caAfp6ou\ngFTgSM5O+PBvg2KItfmDzd1/I3CfLf5p8J70Ph31OWdOs/2CUMlhV4NmBLsODQjE\n6jtVuI+41GuEDjjV6ek+RQ==\n-----END CERTIFICATE-----\n";
    private static TrustLevel trustLevel = null;

    private final KeyStore getKeyStore() {
        KeyStore ks = null;
        char[] pwd = new char[]{'a', 'p', 'p', 'x'};
        try {
            ks = KeyStore.getInstance(KeyStore.getDefaultType());
            File file = new File(String.valueOf(Globals.getOptionValueString("cacheRoot")) + File.separator + "keystore");
            if (file.exists()) {
                FileInputStream fi = new FileInputStream(file);
                ks.load(fi, pwd);
            } else {
                ks.load(null, pwd);
            }
        }
        catch (Exception ex) {
            System.err.println("AppxTrustManager.getKeyStore() Exception=" + ex);
        }
        return ks;
    }

    public static TrustLevel getTrustLevel() {
        if (trustLevel == null) {
            return TrustLevel.UNPROTECTED;
        }
        return trustLevel;
    }

    private static X509Certificate getOurCert() {
        if (ourCert == null) {
            try {
                byte[] byteArray = cert.getBytes("ISO-8859-1");
                ByteArrayInputStream is = new ByteArrayInputStream(byteArray);
                CertificateFactory cf = CertificateFactory.getInstance("X509");
                ourCert = (X509Certificate)cf.generateCertificate(is);
                ((InputStream)is).close();
            }
            catch (Exception e) {
                System.err.println("AppxTrustManager.getOurCert() exception=" + e);
            }
        }
        return ourCert;
    }

    public static SSLSocketFactory getAppxSSLSocketFactory() {
        SSLContext context = null;
        try {
            context = SSLContext.getInstance("SSL");
            context.init(null, new TrustManager[]{new AppxTrustManager(null)}, null);
        }
        catch (Exception e) {
            System.err.println("AppxTrustManager.getAppxSSLSocketFactory() exception=" + e);
        }
        return context.getSocketFactory();
    }

    public AppxTrustManager(KeyStore keystore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory factory = TrustManagerFactory.getInstance("SunX509");
        factory.init(keystore);
        TrustManager[] trustmanagers = factory.getTrustManagers();
        if (trustmanagers.length == 0) {
            throw new NoSuchAlgorithmException("SunX509 trust manager not supported");
        }
        this.standardTrustManager = (X509TrustManager)trustmanagers[0];
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        this.standardTrustManager.checkClientTrusted(certificates, authType);
    }

    public static X509Certificate getCurrentCertificate() {
        return currentCertificate;
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        currentCertificate = null;
        if (trustLevel != null) {
            return;
        }
        if (certificates.length > 0) {
            currentCertificate = certificates[0];
        }
        if (currentCertificate != null && certificates.length == 1) {
            if (Globals.getOptionValueBoolean("SSLAnonAllowed") && certificates[0].equals(AppxTrustManager.getOurCert())) {
                trustLevel = TrustLevel.ANONYMOUS;
                return;
            }
            if (Globals.getOptionValueBoolean("SSLSelfSignedAllowed")) {
                trustLevel = TrustLevel.SELF_SIGNED;
                if (this.getCertificateFromStore("" + currentCertificate.getSerialNumber()) == null) {
                    this.approveCertificate("Untrusted Self-signed Certificate", currentCertificate);
                }
                return;
            }
        }
        this.standardTrustManager.checkServerTrusted(certificates, authType);
        if (trustLevel == null) {
            trustLevel = TrustLevel.AUTHENTICATED;
            if (this.getCertificateFromStore("" + currentCertificate.getSerialNumber()) == null) {
                this.approveCertificate("Trusted Certificate", currentCertificate);
            }
        }
    }

    private void addCertificateToStore(X509Certificate cert) {
        try {
            char[] pwd = new char[]{'a', 'p', 'p', 'x'};
            KeyStore ks = this.getKeyStore();
            ks.setCertificateEntry("" + cert.getSerialNumber(), cert);
            FileOutputStream fo = new FileOutputStream(String.valueOf(Globals.getOptionValueString("cacheRoot")) + File.separator + "keystore");
            ks.store(fo, pwd);
        }
        catch (Exception ex) {
            System.err.println("AppxStrustManager.addCertificateToStore() Exception=" + ex);
        }
    }

    private Certificate getCertificateFromStore(String alias) {
        try {
            return this.getKeyStore().getCertificate(alias);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void approveCertificate(String certType, X509Certificate cert) throws CertificateException {
        Object[] options = new Object[]{"Accept", "Accept Permenantly", "Reject"};
        int result = JOptionPane.showOptionDialog(CharView.view, AppxTrustManager.getCurrentCertificateDesc(), "Certificate Viewer", 1, -1, AppxResource.Gfx.CERT_ICON.icon(), options, options[1]);
        if (result == 1) {
            this.addCertificateToStore(cert);
        }
        if (result == 2) {
            throw new CertificateException();
        }
    }

    public static final String getCurrentCertificateDesc() {
        X509Certificate cert = Globals.getCurrentCertificate();
        String resultString = "<html>";
        resultString = String.valueOf(resultString) + "<font size=4><b>Server Certificate Information&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</b></font><br>";
        resultString = String.valueOf(resultString) + "<font size=3><b>" + trustLevel.desc() + "</b></font><br>&nbsp;";
        resultString = String.valueOf(resultString) + "<table cellspacing=1 cellpadding=0>";
        resultString = String.valueOf(resultString) + AppxTrustManager.certName2HTML("Issued To", cert.getSubjectX500Principal().getName());
        if (trustLevel == TrustLevel.APPX_SIGNED || trustLevel == TrustLevel.AUTHENTICATED) {
            resultString = String.valueOf(resultString) + AppxTrustManager.certName2HTML("Issued By", cert.getIssuerX500Principal().getName());
        }
        resultString = String.valueOf(resultString) + "<tr><th align=left colspan=2>Validity</th></tr>";
        resultString = String.valueOf(resultString) + "<tr><td>&nbsp;&nbsp;Issued On:&nbsp;&nbsp;</td><td>" + DateFormat.getDateInstance(1).format(cert.getNotBefore()) + "</td></tr>";
        resultString = String.valueOf(resultString) + "<tr><td>&nbsp;&nbsp;Expires On:&nbsp;&nbsp;</td><td>" + DateFormat.getDateInstance(1).format(cert.getNotAfter()) + "</td></tr>";
        resultString = String.valueOf(resultString) + "<tr><td>&nbsp;&nbsp;Serial No:&nbsp;&nbsp;</td><td>" + cert.getSerialNumber() + "</td></tr>";
        resultString = String.valueOf(resultString) + "<tr><td colspan=2>&nbsp;</td></tr>";
        resultString = String.valueOf(resultString) + "</table>";
        resultString = String.valueOf(resultString) + "</html>";
        return resultString;
    }

    private static final String certName2HTML(String title, String name) {
        StringTokenizer st = new StringTokenizer(name.replaceAll("\\\\,", "\t"), ",");
        String resultString = "";
        resultString = String.valueOf(resultString) + "<tr><th align=left colspan=2>" + title + "</th></tr>";
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(token.replaceAll("\t", ","), "=");
            if (st2.countTokens() <= 1) continue;
            String workStr = st2.nextToken();
            resultString = workStr.equals("O") ? String.valueOf(resultString) + "<tr><td>&nbsp;&nbsp;Company:&nbsp;&nbsp;</td><td>" + st2.nextToken() + "</td></tr>" : (workStr.equals("L") ? String.valueOf(resultString) + "<tr><td>&nbsp;&nbsp;City:&nbsp;&nbsp;</td><td>" + st2.nextToken() + "</td></tr>" : (workStr.equals("ST") ? String.valueOf(resultString) + "<tr><td>&nbsp;&nbsp;State:&nbsp;&nbsp;</td><td>" + st2.nextToken() + "</td></tr>" : (workStr.equals("C") ? String.valueOf(resultString) + "<tr><td>&nbsp;&nbsp;Country:&nbsp;&nbsp;</td><td>" + st2.nextToken() + "</td></tr>" : (workStr.equals("CN") ? String.valueOf(resultString) + "<tr><td>&nbsp;&nbsp;Common Name:&nbsp;&nbsp;</td><td>" + st2.nextToken() + "</td></tr>" : String.valueOf(resultString) + "<tr><td>&nbsp;&nbsp;" + workStr + ":&nbsp;&nbsp;</td><td>" + st2.nextToken() + "</td></tr>"))));
        }
        return resultString;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.standardTrustManager.getAcceptedIssuers();
    }

    public static final String getCurrentCertificateSubjectName() {
        X509Certificate cert = Globals.getCurrentCertificate();
        if (cert != null) {
            if (cert.equals(AppxTrustManager.getOurCert())) {
                return "Anonymous SSL";
            }
            StringBuffer buf = new StringBuffer(cert.getSubjectDN().getName());
            int quote0 = -1;
            int quote1 = -1;
            int quote2 = -1;
            String cnString = null;
            int i = 0;
            while (i < buf.length()) {
                if (buf.charAt(i) == '\"') {
                    quote2 *= -1;
                }
                if (buf.charAt(i) == '\'') {
                    quote1 *= -1;
                }
                if (buf.charAt(i) == '`') {
                    quote0 *= -1;
                }
                if (quote0 < 0 && quote1 < 0 && quote2 < 0 && buf.charAt(i) == ',') {
                    StringBuffer tmp;
                    buf = tmp = buf.replace(i, i + 1, "<br>");
                }
                ++i;
            }
            String work = buf.substring(buf.indexOf("CN=") + 3);
            cnString = work.substring(0, work.indexOf("<br>"));
            return "Authenticated SSL: " + cnString;
        }
        return null;
    }

    public static void setTrustLevel(TrustLevel object) {
        trustLevel = object;
    }

    public static enum TrustLevel {
        UNPROTECTED("No SSL Certificate"),
        ANONYMOUS("Embedded APPX Certificate"),
        SELF_SIGNED("Untrusted Self-Signed Certificate"),
        APPX_SIGNED("APPX Signed Certificate"),
        AUTHENTICATED("Trusted Authority Signed Certificate");

        private final String desc;

        private TrustLevel(String str) {
            this.desc = str;
        }

        public String desc() {
            return this.desc;
        }
    }
}

