/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing;

import java.security.AccessController;
import java.security.PrivilegedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum NSSystemProperty {
    LOCALHOSTADDRESS("nativeswing.localhostAddress", Type.READ_WRITE),
    LOCALHOSTADDRESS_DEBUG_PRINTDETECTION("nativeswing.localhostAddress.debug.printDetection", Type.READ_WRITE),
    LOCALHOSTADDRESS_DEBUG_PRINT("nativeswing.localhostAddress.debug.print", Type.READ_WRITE),
    WEBSERVER_DEBUG_PRINTPORT("nativeswing.webserver.debug.printPort", Type.READ_WRITE),
    WEBSERVER_DEBUG_PRINTREQUESTS("nativeswing.webserver.debug.printRequests", Type.READ_WRITE),
    WEBSERVER_DEBUG_PRINTDATA("nativeswing.webserver.debug.printData", Type.READ_WRITE),
    COMPONENTS_DEBUG_PRINTOPTIONS("nativeswing.components.debug.printOptions", Type.READ_WRITE),
    COMPONENTS_DEBUG_PRINTSHAPECOMPUTING("nativeswing.components.debug.printShapeComputing", Type.READ_WRITE),
    COMPONENTS_FORCESINGLERECTANGLESHAPES("nativeswing.components.forceSingleRectangleShapes", Type.READ_WRITE),
    INTEGRATION_ACTIVE("nativeswing.integration.active", Type.READ_WRITE),
    DEPENDENCIES_CHECKVERSIONS("nativeswing.dependencies.checkVersions", Type.READ_WRITE);

    private final String _name;
    private final boolean _readOnly;

    private NSSystemProperty(String name) {
        this(name, Type.READ_ONLY);
    }

    private NSSystemProperty(String name, Type type) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if ("".equals(name = name.trim())) {
            throw new IllegalArgumentException();
        }
        this._name = name;
        this._readOnly = type == Type.READ_ONLY;
    }

    public String get() {
        return this.get(null);
    }

    public String get(final String defaultValue) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(NSSystemProperty.this.getName(), defaultValue);
            }
        });
    }

    public String set(final String value) {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException(String.valueOf(this.getName()) + " is a read-only property");
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.setProperty(NSSystemProperty.this.getName(), value);
            }
        });
    }

    public String getName() {
        return this._name;
    }

    public boolean isReadOnly() {
        return this._readOnly;
    }

    public String toString() {
        return this.get();
    }

    public String toDebugString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.name()).append(": ");
        buf.append(this.getName()).append("=");
        buf.append(this.get());
        if (this.isReadOnly()) {
            buf.append(" (read-only)");
        }
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        READ_WRITE,
        READ_ONLY;

    }
}

